/*
 * Decompiled with CFR 0.152.
 */
package conifer.fastpf;

import conifer.fastpf.FastPFUtils;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nuts.util.Tree;
import pty.RootedTree;
import pty.smc.models.CTMC;
import pty.smc.models.FastDiscreteModelCalculator;

public class FastParticle {
    public final CacheNode[] cacheNodes;
    public final int nNonTrivialRoots;
    public final int nIternalNodes;

    public String toString() {
        return "FastParticle(nRoots=" + this.nRoots() + ")";
    }

    public FastParticle(CacheNode[] cacheNodes, int nNonTrivialRoots, int nIternalNodes) {
        this.cacheNodes = cacheNodes;
        this.nNonTrivialRoots = nNonTrivialRoots;
        this.nIternalNodes = nIternalNodes;
    }

    public FastParticle(CacheNode[] cacheNodes) {
        this.cacheNodes = cacheNodes;
        this.nNonTrivialRoots = 0;
        this.nIternalNodes = 0;
    }

    public static FastParticle initFastParticle(Map<Taxon, double[][]> observations, CTMC ctmc, List<Taxon> taxaOrder) {
        int nTaxa = observations.size();
        if (nTaxa != taxaOrder.size()) {
            throw new RuntimeException();
        }
        CacheNode[] cacheNodes = new CacheNode[observations.size()];
        for (int i = 0; i < nTaxa; ++i) {
            Taxon current = taxaOrder.get(i);
            if (current == null) {
                throw new RuntimeException();
            }
            cacheNodes[i] = new CacheNode(FastDiscreteModelCalculator.observation(ctmc, observations.get(current)), new Tree<PhyloNode>(new PhyloNode(current, Collections.EMPTY_LIST)));
        }
        return new FastParticle(cacheNodes);
    }

    public FastParticle next(int p0, int p1, double bl0, double bl1, FastDiscreteModelCalculator newDMC, int nNonTrivialRoots2) {
        Taxon newTaxon = new Taxon("internal_" + this.nIternalNodes);
        ArrayList<Double> childrenBranchLengths = new ArrayList<Double>(2);
        childrenBranchLengths.add(bl0);
        childrenBranchLengths.add(bl1);
        PhyloNode phyloNode = new PhyloNode(newTaxon, childrenBranchLengths);
        Tree<PhyloNode> newTree = new Tree<PhyloNode>(phyloNode);
        newTree.getChildren().add(this.cacheNodes[p0].tree);
        newTree.getChildren().add(this.cacheNodes[p1].tree);
        CacheNode newCache = new CacheNode(newDMC, newTree);
        CacheNode[] newCaches = new CacheNode[this.nRoots() - 1];
        FastPFUtils.merge(this.cacheNodes, newCaches, p0, p1, newCache);
        return new FastParticle(newCaches, nNonTrivialRoots2, this.nIternalNodes + 1);
    }

    public int nRoots() {
        return this.cacheNodes.length;
    }

    public RootedTree getTree() {
        if (this.nRoots() != 1) {
            throw new RuntimeException();
        }
        return FastPFUtils.getTree(this.cacheNodes[0]);
    }

    public static class CacheNode {
        public final FastDiscreteModelCalculator calculator;
        public final Tree<PhyloNode> tree;

        public CacheNode(FastDiscreteModelCalculator calculator, Tree<PhyloNode> tree) {
            this.calculator = calculator;
            this.tree = tree;
        }

        public boolean isLeaf() {
            return this.tree.getChildren().isEmpty();
        }
    }

    public static class PhyloNode {
        public final Taxon taxon;
        public final List<Double> childrenBLs;

        public PhyloNode(Taxon taxon, List<Double> childrenBLs) {
            this.taxon = taxon;
            this.childrenBLs = childrenBLs;
        }
    }
}

