/*
 * Decompiled with CFR 0.152.
 */
package conifer.largemove;

import conifer.largemove.LargeMoveUtils;
import fig.basic.NumUtils;
import fig.basic.Pair;
import fig.basic.UnorderedPair;
import fig.prob.SampleUtils;
import goblin.Taxon;
import java.util.Map;
import java.util.Random;
import nuts.math.MutableGraph;
import nuts.util.Arbre;
import nuts.util.CoordinatesPacker;
import nuts.util.MathUtils;

public final class MicroGibbsResult {
    final double[] logProbabilities;
    private double[] probabilities = null;
    public final double[] branchLengths;
    private final Taxon[] originalTaxonOrder;
    private final CoordinatesPacker.MSCoordinatePacker packer;
    private Pair<Arbre<Taxon>, Arbre<Taxon>> edge;

    public int sampleIndex(Random rand) {
        this.ensurePrs();
        return SampleUtils.sampleMultinomial(rand, this.probabilities);
    }

    public double[] samplingProbabilities() {
        this.ensurePrs();
        return this.probabilities;
    }

    private void ensurePrs() {
        if (this.probabilities != null) {
            return;
        }
        this.probabilities = (double[])this.logProbabilities.clone();
        NumUtils.expNormalize(this.probabilities);
    }

    public int argmaxIndex() {
        return MathUtils.argmax(this.logProbabilities);
    }

    public double branchLength(int sampledIndex) {
        return this.branchLengths[this.branchLengthIndex(sampledIndex)];
    }

    public MicroGibbsResult(double[] branchLengths, Taxon[] originalTaxonOrder, Pair<Arbre<Taxon>, Arbre<Taxon>> edge) {
        this.edge = edge;
        this.branchLengths = branchLengths;
        this.originalTaxonOrder = originalTaxonOrder;
        this.logProbabilities = new double[3 * branchLengths.length];
        for (int i = 0; i < this.logProbabilities.length; ++i) {
            this.logProbabilities[i] = Double.NEGATIVE_INFINITY;
        }
        this.packer = new CoordinatesPacker.MSCoordinatePacker(new int[]{3, branchLengths.length});
    }

    public void alter(MutableGraph<Taxon> topology, Map<UnorderedPair<Taxon, Taxon>, Double> branchLengths, int sampledIndex) {
        UnorderedPair<Taxon, Taxon> unordered;
        int config = this.configuration(sampledIndex);
        if (config != 0) {
            for (int clade = 0; clade < 2; ++clade) {
                Taxon edgeNode = clade == 0 ? this.edge.getFirst().getContents() : this.edge.getSecond().getContents();
                for (int index = 0; index < 2; ++index) {
                    UnorderedPair<Taxon, Taxon> newKey;
                    UnorderedPair<Taxon, Taxon> oldKey = new UnorderedPair<Taxon, Taxon>(edgeNode, this.getTaxon(0, clade, index));
                    if (oldKey.equals(newKey = new UnorderedPair<Taxon, Taxon>(edgeNode, this.getTaxon(config, clade, index)))) continue;
                    double bl = branchLengths.get(oldKey);
                    topology.removeEdge(oldKey.getFirst(), oldKey.getSecond());
                    branchLengths.remove(oldKey);
                    topology.addEdge(newKey.getFirst(), newKey.getSecond());
                    branchLengths.put(newKey, bl);
                }
            }
        }
        if (!branchLengths.containsKey(unordered = new UnorderedPair<Taxon, Taxon>(this.edge.getFirst().getContents(), this.edge.getSecond().getContents()))) {
            throw new RuntimeException();
        }
        branchLengths.put(unordered, this.branchLengths[this.branchLengthIndex(sampledIndex)]);
    }

    public int configuration(int pack) {
        return this.packer.int2coord(pack)[0];
    }

    public int branchLengthIndex(int pack) {
        return this.packer.int2coord(pack)[1];
    }

    public Taxon getTaxon(int topologyConfiguration, int clade, int index) {
        int basicIndex = index + clade * 2;
        int finalIndex = -1;
        if (topologyConfiguration == 0) {
            finalIndex = basicIndex;
        } else if (topologyConfiguration == 1) {
            finalIndex = LargeMoveUtils.shuffle(basicIndex, 1, 2);
        } else if (topologyConfiguration == 2) {
            finalIndex = LargeMoveUtils.shuffle(basicIndex, 1, 3);
        } else {
            throw new RuntimeException();
        }
        return this.originalTaxonOrder[finalIndex];
    }

    public int findConfig(Taxon c0i1) {
        for (int config = 0; config < 3; ++config) {
            if (!c0i1.equals(this.getTaxon(config, 0, 1))) continue;
            return config;
        }
        throw new RuntimeException();
    }

    public int prsIndex(int topologyConfiguration, int blIndex) {
        return this.packer.coord2int(topologyConfiguration, blIndex);
    }
}

