/*
 * Decompiled with CFR 0.152.
 */
package conifer.msa;

import conifer.evol.PIPLikelihoodModel;
import conifer.msa.TreeMSAState;
import ev.poi.PoissonParameters;
import fig.basic.Pair;
import java.util.Random;
import monaco.prop.Proposal;
import nuts.math.Sampling;

public class TreeMSAParamProposal
implements Proposal<TreeMSAState> {
    public final double multiplier = 1.2;
    public final double intensityMeanHyperParam = 100.0;
    public final double lenMeanHyperParam = 10000.0;

    @Override
    public Pair<TreeMSAState, Double> propose_logRatio(Random rand, TreeMSAState current, boolean avoidExtensiveCaching) {
        boolean useIntensity = rand.nextBoolean();
        double m = Sampling.nextDouble(rand, 0.8333333333333334, 1.2);
        PIPLikelihoodModel oldModel = (PIPLikelihoodModel)current.params;
        double oldValue = useIntensity ? PoissonParameters.getIndelIntensityParameterForAdditiveIntensityParam(oldModel.params.insertRate, oldModel.params.deleteRate) : PoissonParameters.getAsymptoticLengthParameterForAdditiveIntensityParam(oldModel.params.insertRate, oldModel.params.deleteRate);
        double newValue = m * oldValue;
        PIPLikelihoodModel newModel = useIntensity ? oldModel.copyWithNewIntensity(newValue) : oldModel.copyWithNewLen(newValue);
        current.inPlaceParamChange(newModel);
        double hyper = useIntensity ? 100.0 : 10000.0;
        double logRatio = Math.log(m) + Sampling.exponentialLogDensity(hyper, newValue) - Sampling.exponentialLogDensity(hyper, oldValue);
        return Pair.makePair(current, logRatio);
    }

    @Override
    public String name() {
        return "TreeMSAParamProposal";
    }
}

