/*
 * Decompiled with CFR 0.152.
 */
package conifer.pip;

import ev.poi.PoissonParameters;
import fig.basic.IOUtils;
import fig.prob.SampleUtils;
import goblin.Taxon;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ma.MSAPoset;
import ma.RateMatrixLoader;
import nuts.math.RateMtxUtils;
import nuts.util.Arbre;
import nuts.util.CollUtils;
import nuts.util.MathUtils;
import pty.RandomRootedTrees;
import pty.RootedTree;

public class PIPForwardSampler {
    private final PoissonParameters pip;
    private final RootedTree tree;

    public MSAPoset sampleMSA(Random rand) {
        return this.convert(this.sample(rand));
    }

    public PIPForwardSampler(PoissonParameters pip, RootedTree tree) {
        this.pip = pip;
        this.tree = tree;
    }

    public static void main(String[] args) {
        double num = 0.0;
        double denom = 0.0;
        Random rand = new Random(1L);
        for (int i = 0; i < 10000; ++i) {
            PoissonParameters pip = PoissonParameters.createFromAdditiveLengthIntensityParameterization(RateMatrixLoader.rnaIndexer(), RateMatrixLoader.k2p(), 10.0, 0.5);
            RootedTree rt = RandomRootedTrees.sampleCoalescent(rand, 10, 1.0);
            PIPForwardSampler pipf = new PIPForwardSampler(pip, rt);
            MSAPoset msa = pipf.sampleMSA(rand);
            for (Taxon t : msa.sequences().keySet()) {
                num += (double)msa.sequences().get(t).length();
                denom += 1.0;
            }
            if (i % 10 != 0) continue;
            System.out.println("current avg = " + num / denom);
        }
    }

    private MSAPoset convert(List<Map<Taxon, Character>> data) {
        File tempFile = null;
        try (PrintWriter out = null;){
            tempFile = File.createTempFile("temp-PIPForward_" + System.currentTimeMillis(), null);
            tempFile.deleteOnExit();
            out = IOUtils.openOutHard(tempFile);
            HashMap strings = new HashMap();
            List<Taxon> leaves = this.tree.topology().leaveContents();
            for (Map<Taxon, Character> c : data) {
                for (Taxon t : leaves) {
                    CollUtils.getNoNull(strings, t, new StringBuilder()).append("" + (c.containsKey(t) ? c.get(t).charValue() : (char)'-'));
                }
            }
            for (Taxon t : leaves) {
                out.println(">" + t);
                out.println(((StringBuilder)strings.get(t)).toString());
            }
        }
        return MSAPoset.parseFASTA(tempFile);
    }

    public List<Map<Taxon, Character>> sample(Random rand) {
        double[] insertPrs = new double[this.tree.topology().nodes().size()];
        ArrayList<Arbre<Taxon>> subtrees = new ArrayList<Arbre<Taxon>>(this.tree.topology().nodes());
        Collections.sort(subtrees, new ATComparator());
        if (subtrees.size() != insertPrs.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < subtrees.size(); ++i) {
            Arbre cur = (Arbre)subtrees.get(i);
            insertPrs[i] = cur.isRoot() ? this.pip.insertRate / this.pip.deleteRate : this.pip.insertRate * this.tree.branchLengths().get(cur.getContents());
        }
        double norm = MathUtils.normalizeAndGetNorm(insertPrs);
        int nCols = (int)SampleUtils.samplePoisson(rand, norm);
        ArrayList<Map<Taxon, Character>> result = new ArrayList<Map<Taxon, Character>>();
        for (int _i = 0; _i < nCols; ++_i) {
            int edgeIdx = SampleUtils.sampleMultinomial(rand, insertPrs);
            Arbre subtree = (Arbre)subtrees.get(edgeIdx);
            double stemLen = 0.0;
            if (!subtree.isRoot()) {
                stemLen = rand.nextDouble() * this.tree.branchLengths().get(subtree.getContents());
            }
            HashMap<Taxon, Character> current = new HashMap<Taxon, Character>();
            this.generateColumn(rand, stemLen, current, subtree, -1);
            if (current.isEmpty()) continue;
            result.add(current);
        }
        return result;
    }

    private void generateColumn(Random rand, double stemLen, Map<Taxon, Character> currentCol, Arbre<Taxon> bottomOfStemSubtree, int topOfStemValue) {
        double[][] marginal;
        int botOfStemValue;
        if (topOfStemValue == -1) {
            topOfStemValue = SampleUtils.sampleMultinomial(rand, this.pip.quasiStatProbs);
        }
        if ((botOfStemValue = SampleUtils.sampleMultinomial(rand, (marginal = RateMtxUtils.marginalTransitionMtx(this.pip.Q, stemLen))[topOfStemValue])) != this.pip.gapIndex) {
            if (bottomOfStemSubtree.isLeaf()) {
                currentCol.put(bottomOfStemSubtree.getContents(), this.pip.indexer.i2o(botOfStemValue));
            } else {
                ArrayList<Arbre<Taxon>> subtrees = CollUtils.list(bottomOfStemSubtree.getChildren());
                Collections.sort(subtrees, new ATComparator());
                for (Arbre arbre : subtrees) {
                    this.generateColumn(rand, this.tree.branchLengths().get(arbre.getContents()), currentCol, arbre, botOfStemValue);
                }
            }
        }
    }

    public static class ATComparator
    implements Comparator<Arbre<Taxon>> {
        @Override
        public int compare(Arbre<Taxon> o1, Arbre<Taxon> o2) {
            return o1.getContents().toString().compareTo(o2.getContents().toString());
        }
    }
}

