/*
 * Decompiled with CFR 0.152.
 */
package conifer.proposals;

import conifer.msa.TreeMSAState;
import conifer.particle.PhyloParticle;
import fig.basic.Pair;
import java.util.Random;
import monaco.prop.Proposal;
import pty.RootedTree;
import pty.UnrootedTree;
import pty.mcmc.ProposalDistribution;
import pty.mcmc.UnrootedTreeState;
import pty.smc.PartialCoalescentState;

public class Adaptor
implements Proposal<PhyloParticle> {
    private final ProposalDistribution proposal;

    public Adaptor(ProposalDistribution proposal) {
        this.proposal = proposal;
    }

    @Override
    public Pair<PhyloParticle, Double> propose_logRatio(Random rand, PhyloParticle current, boolean avoidExtensiveCaching) {
        UnrootedTreeState newState;
        UnrootedTreeState treeState;
        UnrootedTree currentUnrooted;
        Pair<UnrootedTree, Double> proposed;
        if (current instanceof TreeMSAState) {
            TreeMSAState treeMSAState = (TreeMSAState)current;
            Pair<UnrootedTree, Double> proposed2 = this.proposal.propose(treeMSAState.getPhylogeny().getUnrooted(), rand);
            RootedTree rooted = RootedTree.Util.centroidRooting(proposed2.getFirst());
            treeMSAState.inPlaceTreeChange(rooted);
            return Pair.makePair(current, proposed2.getSecond());
        }
        if (!(current instanceof UnrootedTreeState)) {
            UnrootedTreeState converted = new UnrootedTreeState();
            PartialCoalescentState old = (PartialCoalescentState)current;
            converted.init(old.calculators, old.getPriorDensity(), old.context);
            current = converted;
        }
        if ((proposed = this.proposal.propose(currentUnrooted = (treeState = ((UnrootedTreeState)current).deepClone()).getUnrootedTree(), rand)) == null) {
            throw new RuntimeException("Probably using UnrootedTreeStates in a multithread fashion... UnrootedTreeState is not thread safe!");
        }
        UnrootedTreeState newParticle = newState = treeState.copyAndChange(proposed.getFirst());
        return Pair.makePair(newParticle, proposed.getSecond());
    }

    @Override
    public String name() {
        return this.proposal.description();
    }
}

