/*
 * Decompiled with CFR 0.152.
 */
package conifer.spr;

import conifer.data.DataOptions;
import conifer.data.PhylogeneticData;
import conifer.fastpf.FastPriorPrior;
import conifer.fastpf.TaxaOrderHeuristic;
import conifer.largemove.LargeMoveKernel;
import conifer.largemove.TestClimbLikelihood;
import conifer.multicategories.PhylogeneticFactorGraph;
import conifer.spr.SPROperator;
import fig.basic.LogInfo;
import goblin.Taxon;
import java.util.List;
import java.util.Random;
import ma.RateMatrixLoader;
import nuts.io.IO;
import pty.io.Dataset;
import pty.smc.ParticleFilter;

public class TestClades
implements Runnable {
    private static DataOptions syntheticOptions = new DataOptions();
    private static LargeMoveKernel.LargeMoveKernelOptions largeKernelOptions = new LargeMoveKernel.LargeMoveKernelOptions();
    private static FastPriorPrior.SimplePriorOptions priorOptions = new FastPriorPrior.SimplePriorOptions();
    private static ParticleFilter<LargeMoveKernel.LargeMoveParticle> pf = new ParticleFilter();

    public static void main(String[] args) {
        IO.run(args, new TestClades(), "s", syntheticOptions, "l", largeKernelOptions, "p", priorOptions, "pf", pf);
    }

    @Override
    public void run() {
        PhylogeneticData data = TestClades.syntheticOptions.dataModel.loadDataset(syntheticOptions);
        Dataset obs = (Dataset)((Object)data.getObservedTaxonIndexData());
        double[][] rateMtx = RateMatrixLoader.k2p();
        List<Taxon> order = TaxaOrderHeuristic.heuristicOrder(obs.observations());
        Random rand = new Random(1L);
        LargeMoveKernel.LargeMoveParticle init = TestClimbLikelihood.starInit(order.subList(0, 3), rand, obs.observations().keySet().size());
        PhylogeneticFactorGraph pfg = PhylogeneticFactorGraph.createSingleCategoryFromStationaryProcess(SPROperator.starInitialization(order.subList(0, 3), 0.2), rateMtx, obs);
        if (!TestClades.largeKernelOptions.useRegraftMode) {
            throw new RuntimeException();
        }
        LargeMoveKernel lmk = new LargeMoveKernel(largeKernelOptions, priorOptions, init, pfg.potentials.categoryPriors, pfg.potentials.rateMatrices, pfg.observations, pfg.potentials.stationaryDistributions, 0.0, order);
        for (int i = 0; i < 10; ++i) {
            ParticleFilter.StoreProcessor processor = new ParticleFilter.StoreProcessor();
            TestClades.pf.resampleLastRound = true;
            pf.sample(lmk, processor);
            LogInfo.logsForce("logZ = " + pf.estimateNormalizer());
        }
    }
}

