/*
 * Decompiled with CFR 0.152.
 */
package conifer.ssm;

import conifer.ssm.Edit;
import fig.basic.Option;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.List;
import nuts.math.Sampling;
import nuts.util.MathUtils;

public class StringMutationModel {
    @Option(gloss="length of SSM's (constrained to all be of same length for now)")
    public int ssmLength = 3;
    @Option(gloss="(per base)")
    public double pointSubstitutionRate = 0.03;
    @Option(gloss="(global)")
    public double pointInsertionRate = 0.05;
    @Option(gloss="(per base)")
    public double pointDeletionRate = 0.2;
    @Option(gloss="(global)")
    public double ssmInsertionRate = 2.0;
    @Option(gloss="(per valid ssm deletion location)")
    public double ssmDeletionRate = 2.0;

    public String toString() {
        return "StringMutationModel(ssmLength=" + this.ssmLength + ", pointSubstitutionRate=" + this.pointSubstitutionRate + ", pointInsertionRate=" + this.pointInsertionRate + ", pointDeletionRate=" + this.pointDeletionRate + ", ssmInsertionRate=" + this.ssmInsertionRate + ", ssmDeletionRate=" + this.ssmDeletionRate + ")";
    }

    public StringMutationModel(int ssmLength, double pointSubstitutionRate, double pointInsertionRate, double pointDeletionRate, double ssmInsertionRate, double ssmDeletionRate) {
        this.ssmLength = ssmLength;
        this.pointSubstitutionRate = pointSubstitutionRate;
        this.pointInsertionRate = pointInsertionRate;
        this.pointDeletionRate = pointDeletionRate;
        this.ssmInsertionRate = ssmInsertionRate;
        this.ssmDeletionRate = ssmDeletionRate;
    }

    public StringMutationModel() {
    }

    public Pair<List<Edit>, double[]> rates(String current) {
        List<Edit> ptSubstitutions = Edit.pointSubstitutions(current);
        List<Edit> ptInsertions = Edit.pointInsertions(current);
        List<Edit> ptDeletions = Edit.pointDeletions(current);
        List<Edit> ssmInsertions = Edit.ssmInsertions(current, this.ssmLength);
        List<Edit> ssmDeletions = Edit.ssmDeletions(current, this.ssmLength);
        ArrayList<Edit> candidates = new ArrayList<Edit>();
        ArrayList<Double> rates = new ArrayList<Double>();
        for (Edit e : ptSubstitutions) {
            candidates.add(e);
            rates.add(this.pointSubstitutionRate);
        }
        double currentPtInsertRate = this.pointInsertionRate / (double)ptInsertions.size();
        for (Edit e : ptInsertions) {
            candidates.add(e);
            rates.add(currentPtInsertRate);
        }
        for (Edit e : ptDeletions) {
            candidates.add(e);
            rates.add(this.pointDeletionRate);
        }
        double currentSSMInsertRate = this.ssmInsertionRate / (double)ssmInsertions.size();
        for (Edit e : ssmInsertions) {
            candidates.add(e);
            rates.add(currentSSMInsertRate);
        }
        for (Edit e : ssmDeletions) {
            candidates.add(e);
            rates.add(this.ssmDeletionRate);
        }
        double[] convertedRates = new double[rates.size()];
        for (int i = 0; i < rates.size(); ++i) {
            convertedRates[i] = (Double)rates.get(i);
        }
        return Pair.makePair(candidates, convertedRates);
    }

    public double logLikelihood(List<Pair<String, Double>> subSeries) {
        double sum = 0.0;
        for (int i = 0; i < subSeries.size(); ++i) {
            Pair<List<Edit>, double[]> rates = this.rates(subSeries.get(i).getFirst());
            double currentTime = subSeries.get(i).getSecond();
            double[] prs = rates.getSecond();
            double totalRate = MathUtils.normalizeAndGetNorm(prs);
            if (i == subSeries.size() - 1) {
                sum += Sampling.exponentialLogCDF(1.0 / totalRate, currentTime);
                continue;
            }
            Edit current = new Edit(subSeries.get(i).getFirst(), subSeries.get(i + 1).getFirst());
            int index = rates.getFirst().indexOf(current);
            if (index == -1) {
                throw new RuntimeException();
            }
            sum += Math.log(prs[index]);
            sum += Sampling.exponentialLogDensity(1.0 / totalRate, currentTime);
        }
        return sum;
    }

    public double logPrior(String topStr) {
        return 0.0;
    }
}

