/*
 * Decompiled with CFR 0.152.
 */
package emc;

import fig.basic.Pair;
import java.util.List;
import java.util.Map;
import nuts.util.CollUtils;

public final class EntangledStatistics {
    private static EntangledStatistics entangledStat = null;
    private Map<Long, CoalescentStatistics> coalescentTimes = CollUtils.map();
    private Pair<Double, Integer> reconstructionStat = new Pair<Double, Integer>(0.0, 0);

    private EntangledStatistics() {
    }

    public static synchronized EntangledStatistics getEntangledStatistics() {
        if (entangledStat == null) {
            entangledStat = new EntangledStatistics();
        }
        return entangledStat;
    }

    public synchronized void setCoalescentStat(long r, int T) {
        if (!this.coalescentTimes.containsKey(r)) {
            this.coalescentTimes.put(r, new CoalescentStatistics(0));
        }
        CoalescentStatistics stat = this.coalescentTimes.get(r);
        stat.addStat(T);
    }

    public CoalescentStatistics getCoalescentStat(Long r) {
        return this.coalescentTimes.get(r);
    }

    public synchronized void addReconstructionStat(int T) {
        this.reconstructionStat.setFirst(this.reconstructionStat.getFirst() + (double)T);
        this.reconstructionStat.setSecond(this.reconstructionStat.getSecond() + 1);
    }

    public Pair<Double, Integer> getReconstructionStat() {
        return this.reconstructionStat;
    }

    public void reset() {
        this.coalescentTimes = CollUtils.map();
        this.reconstructionStat = new Pair<Double, Integer>(0.0, 0);
    }

    public static class CoalescentStatistics {
        List<Integer> stats = CollUtils.list();
        private int r;

        public CoalescentStatistics(int r) {
            this.r = r;
        }

        public void addStat(int T) {
            this.stats.add(T);
        }

        public double getMean() {
            int sum = 0;
            for (Integer stat : this.stats) {
                sum += stat.intValue();
            }
            double mean = (double)sum / (double)this.stats.size();
            return mean;
        }

        public double getStdev() {
            double mean = this.getMean();
            double ss = 0.0;
            for (Integer stat : this.stats) {
                ss += Math.pow(stat.doubleValue() - mean, 2.0);
            }
            double stdev = Math.sqrt(ss / (double)(this.stats.size() - 1));
            return stdev;
        }

        public int getNumSamples() {
            return this.stats.size();
        }
    }
}

