/*
 * Decompiled with CFR 0.152.
 */
package ev;

import fig.basic.Pair;
import goblin.Taxon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ma.MultiAlignment;
import nuts.math.EqClasses;
import nuts.util.CollUtils;

public interface MSA {
    public Map<Taxon, String> sequences();

    public Map<Taxon, Integer> alignments(Taxon var1, int var2);

    public Map<Taxon, Integer> alignments(Pair<Taxon, Integer> var1);

    public boolean isAligned(Taxon var1, int var2, Taxon var3, int var4);

    public void addAlign(Taxon var1, int var2, Taxon var3, int var4);

    public boolean isAligned(Pair<Taxon, Integer> var1, Pair<Taxon, Integer> var2);

    public void addAlign(Pair<Taxon, Integer> var1, Pair<Taxon, Integer> var2);

    public static class Utils {
        public static void addAll(MSA source, MSA dest) {
            for (Pair<Taxon, Integer> rep : Utils.allSCs(source.sequences())) {
                if (!dest.sequences().keySet().contains(rep.getFirst())) continue;
                Map<Taxon, Integer> alignment = source.alignments(rep);
                for (Taxon other : alignment.keySet()) {
                    if (!dest.sequences().containsKey(other)) continue;
                    dest.addAlign(rep, Pair.makePair(other, alignment.get(other)));
                }
            }
        }

        public static MSA fromMultiAlignment(MultiAlignment ma) {
            return new BasicMSA(ma);
        }

        public static MSA restrict(MSA msa, Set<Taxon> restriction) {
            HashMap<Taxon, String> restricted = new HashMap<Taxon, String>();
            for (Taxon lang : restriction) {
                restricted.put(lang, msa.sequences().get(lang));
            }
            BasicMSA result = new BasicMSA(restricted);
            Utils.addAll(msa, result);
            return result;
        }

        public static List<Pair<Taxon, Integer>> allSCs(Map<Taxon, String> seq) {
            ArrayList<Pair<Taxon, Integer>> result = new ArrayList<Pair<Taxon, Integer>>();
            for (Taxon lang : seq.keySet()) {
                int cL = seq.get(lang).length();
                for (int i = 0; i < cL; ++i) {
                    result.add(Pair.makePair(lang, i));
                }
            }
            return result;
        }
    }

    public static class BasicMSA
    extends AbstractMSA {
        private final Map<Pair<Taxon, Integer>, Map<Taxon, Integer>> map;
        private final Map<Taxon, String> sequences;

        public BasicMSA(Map<Taxon, String> sequences) {
            this.sequences = CollUtils.archive(sequences);
            this.map = BasicMSA.init(sequences);
        }

        public BasicMSA(MultiAlignment ma) {
            this.sequences = ma.getSequences();
            EqClasses<MultiAlignment.SequenceCoordinate> eqClasses = ma.eqClasses();
            this.map = new HashMap<Pair<Taxon, Integer>, Map<Taxon, Integer>>();
            for (MultiAlignment.SequenceCoordinate rep : eqClasses.representatives()) {
                Set<MultiAlignment.SequenceCoordinate> eqClass = eqClasses.eqClass(rep);
                HashMap<Taxon, Integer> converted = new HashMap<Taxon, Integer>();
                for (MultiAlignment.SequenceCoordinate sc : eqClass) {
                    converted.put(sc.getNodeIdentifier(), sc.indexInSequence());
                }
                for (MultiAlignment.SequenceCoordinate elt : eqClasses.eqClass(rep)) {
                    this.map.put(Pair.makePair(elt.getNodeIdentifier(), elt.indexInSequence()), converted);
                }
            }
        }

        @Override
        public void addAlign(Taxon l1, int i1, Taxon l2, int i2) {
            if (this.alignments(l1, i1).containsKey(l2) || this.alignments(l2, i2).containsKey(l1) || l1.equals(l2) || i1 < 0 || i1 >= this.sequences().get(l1).length() || i2 < 0 || i2 >= this.sequences().get(l2).length()) {
                throw new RuntimeException();
            }
            if (this.isAligned(l1, i2, l2, i2)) {
                return;
            }
            HashMap<Taxon, Integer> newEqClass = new HashMap<Taxon, Integer>();
            newEqClass.putAll(this.alignments(l1, i1));
            newEqClass.putAll(this.alignments(l2, i2));
            for (Taxon l : newEqClass.keySet()) {
                this.map.put(Pair.makePair(l, newEqClass.get(l)), newEqClass);
            }
        }

        public static Map<Pair<Taxon, Integer>, Map<Taxon, Integer>> init(Map<Taxon, String> sequences) {
            HashMap<Pair<Taxon, Integer>, Map<Taxon, Integer>> result = new HashMap<Pair<Taxon, Integer>, Map<Taxon, Integer>>();
            for (Taxon l : sequences.keySet()) {
                String cur = sequences.get(l);
                for (int i = 0; i < cur.length(); ++i) {
                    HashMap<Taxon, Integer> value = new HashMap<Taxon, Integer>();
                    value.put(l, i);
                    result.put(Pair.makePair(l, i), value);
                }
            }
            return result;
        }

        @Override
        public Map<Taxon, Integer> alignments(Taxon seq, int index) {
            return Collections.unmodifiableMap(this.map.get(Pair.makePair(seq, index)));
        }

        @Override
        public Map<Taxon, String> sequences() {
            return Collections.unmodifiableMap(this.sequences);
        }
    }

    public static abstract class AbstractMSA
    implements MSA {
        @Override
        public boolean isAligned(Taxon l1, int i1, Taxon l2, int i2) {
            Map<Taxon, Integer> eqClass = this.alignments(l1, i1);
            if (!eqClass.containsKey(l2)) {
                return false;
            }
            return eqClass.get(l2).equals(i2);
        }

        @Override
        public boolean isAligned(Pair<Taxon, Integer> sc1, Pair<Taxon, Integer> sc2) {
            return this.isAligned(sc1.getFirst(), sc1.getSecond(), sc2.getFirst(), sc2.getSecond());
        }

        @Override
        public void addAlign(Pair<Taxon, Integer> sc1, Pair<Taxon, Integer> sc2) {
            this.addAlign(sc1.getFirst(), sc1.getSecond(), sc2.getFirst(), sc2.getSecond());
        }

        @Override
        public Map<Taxon, Integer> alignments(Pair<Taxon, Integer> sc) {
            return this.alignments(sc.getFirst(), sc.getSecond());
        }
    }
}

