/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import ev.ex.SimpleCoalescentState;
import fig.basic.Pair;
import java.util.List;
import java.util.Random;
import nuts.math.Sampling;
import nuts.util.MathUtils;
import pty.smc.ParticleKernel;

public class SimplePriorPrior
implements ParticleKernel<SimpleCoalescentState> {
    private final SimpleCoalescentState initial;

    public SimplePriorPrior(SimpleCoalescentState initial) {
        this.initial = initial;
    }

    @Override
    public SimpleCoalescentState getInitial() {
        return this.initial;
    }

    @Override
    public int nIterationsLeft(SimpleCoalescentState partialState) {
        return partialState.nRoots() - 1;
    }

    @Override
    public Pair<SimpleCoalescentState, Double> next(Random rand, SimpleCoalescentState current) {
        double delta = Sampling.sampleExponential(rand, 1.0 / (double)MathUtils.nChoose2(current.nRoots()));
        List<Integer> sampledIndices = Sampling.sampleWithoutReplacement(rand, current.nRoots(), 2);
        int i0 = sampledIndices.get(0);
        int i1 = sampledIndices.get(1);
        SimpleCoalescentState result = current.coalesce(i0, i1, delta);
        double ratio = result.logLikelihood() - current.logLikelihood();
        return Pair.makePair(result, ratio);
    }
}

