/*
 * Decompiled with CFR 0.152.
 */
package ev.ex;

import ev.Test;
import ev.ex.PairAlign;
import ev.hmm.HetPairHMM;
import ev.par.ExponentialFamily;
import ev.par.FeatureExtractor;
import ev.par.Input;
import ev.par.Output;
import ev.poi.exp.MSAOutput;
import ev.poi.exp.PhylogeneticOutput;
import goblin.Taxon;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ma.GreedyDecoder;
import ma.MSAParser;
import ma.MSAPoset;
import ma.MultiAlignment;
import nuts.io.IO;
import nuts.maxent.LabeledInstance;
import nuts.maxent.MaxentClassifier;
import nuts.util.Counter;
import nuts.util.IncrementalExperiment;

public class TrainSystem
implements IncrementalExperiment.ReestimatedSystem,
IncrementalExperiment.Parallelizable {
    public static ExponentialFamily.ExponentialFamilyOptions expFamOptions = new ExponentialFamily.ExponentialFamilyOptions();
    public static FeatureExtractor.FeatureOptions featureOptions = new FeatureExtractor.FeatureOptions();
    public static MaxentClassifier.MaxentOptions<Object> learningOptions = new MaxentClassifier.MaxentOptions();
    private ExponentialFamily _expFam = null;

    public ExponentialFamily getModel() {
        if (this._expFam == null) {
            this._expFam = ExponentialFamily.createExpfam(learningOptions, expFamOptions, featureOptions, null);
        }
        return this._expFam;
    }

    public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        TrainSystem system = new TrainSystem();
        IncrementalExperiment experiments = new IncrementalExperiment(system);
        experiments.outputTypeClassPackage = PhylogeneticOutput.class.getPackage().getName();
        IO.run(args, experiments, "expFam", expFamOptions, "feat", featureOptions, "learn", learningOptions, "system", system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inference(IncrementalExperiment.InferenceContext context) {
        ExponentialFamily expFam = this.getModel();
        MultiAlignment msa = PairAlign.PairAlignMain.fixMSA(expFam.model.enc, MSAParser.parseMSA(context.getInput()).toMultiAlignmentObject());
        Counter<LabeledInstance<Input, Output>> suffStats = new Counter<LabeledInstance<Input, Output>>();
        Counter<GreedyDecoder.Edge> edgePosteriors = new Counter<GreedyDecoder.Edge>();
        List<MultiAlignment> pairs = Test.extractPairwiseAlignments(msa, false);
        for (MultiAlignment pairAlign : pairs) {
            Taxon topL = pairAlign.nodes().get(0);
            Taxon botL = pairAlign.nodes().get(1);
            String top = pairAlign.getSequences().get(topL);
            String bot = pairAlign.getSequences().get(botL);
            HetPairHMM hmm = expFam.getHMM(top, bot, topL, botL);
            expFam.addSufficientStatistics(suffStats, hmm, topL, botL);
            for (int botPos = 0; botPos < bot.length(); ++botPos) {
                for (int topPos = 0; topPos < top.length(); ++topPos) {
                    edgePosteriors.setCount(new GreedyDecoder.Edge(topPos, botPos, topL, botL), Math.exp(hmm.logPosteriorAlignment(topPos, botPos)));
                }
            }
        }
        TrainSystem trainSystem = this;
        synchronized (trainSystem) {
            expFam.suffStats.incrementAll(suffStats);
        }
        File msaFile = context.getMainOutputFile(MSAOutput.MSA_OUTPUT);
        MSAPoset.maxRecallMSA(msa.getSequences(), edgePosteriors).toMultiAlignmentObject().saveToMSF(msaFile);
    }

    @Override
    public boolean estimation(IncrementalExperiment.EstimationContext context) {
        ExponentialFamily expFam = this.getModel();
        expFam.updateParameters();
        expFam.saveWeights(new File(context.getCurrentSystemDirectory(), "reestimated.weights"));
        return true;
    }

    @Override
    public String name() {
        return "PseudoLikelihoodTrain";
    }

    @Override
    public Map<IncrementalExperiment.OutputType, IncrementalExperiment.System> requiredInferenceInitializers() {
        return Collections.emptyMap();
    }
}

