/*
 * Decompiled with CFR 0.152.
 */
package ev.io;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;
import goblin.Taxon;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nuts.io.IO;
import nuts.util.CollUtils;

public class CreatePairwiseData
implements Runnable {
    @Option
    public String alignmentFile = "/Users/bouchard/Documents/data/utcs/16S.B.ALL/R0/cleaned.alignment.fasta";
    @Option
    public ArrayList<Taxon> t1s = new ArrayList();
    @Option
    public ArrayList<Taxon> t2s = new ArrayList();

    @Override
    public void run() {
        int npairs = this.t1s.size();
        if (npairs != this.t2s.size()) {
            throw new RuntimeException("t1s size does not match with t2s'");
        }
        LogInfo.track("Loading data");
        LightMSA lmsa = LightMSA.parseStrictFASTA(new File(this.alignmentFile));
        LogInfo.logsForce("Read msa with " + lmsa.taxa.size() + " taxa");
        LogInfo.end_track();
        LogInfo.track("Creating pairwise aligns");
        File output = new File(Execution.getFile("pairwiseAlignments"));
        output.mkdir();
        for (int i = 0; i < npairs; ++i) {
            Taxon t1 = this.t1s.get(i);
            Taxon t2 = this.t2s.get(i);
            StringBuilder s1 = lmsa.sequences.get(t1);
            StringBuilder s2 = lmsa.sequences.get(t2);
            PrintWriter out = IOUtils.openOutHard(new File(output, "" + t1 + "_" + t2 + ".fasta"));
            out.println(">" + t1);
            out.println(s1);
            out.println(">" + t2);
            out.println(s2);
            out.close();
        }
        LogInfo.end_track();
    }

    public static void main(String[] args) {
        IO.run(args, new CreatePairwiseData());
    }

    public static class LightMSA {
        public final Map<Taxon, StringBuilder> sequences;
        public final List<Taxon> taxa;

        public LightMSA(Map<Taxon, StringBuilder> sequences) {
            this.sequences = sequences;
            this.taxa = new ArrayList<Taxon>();
            this.taxa.addAll(sequences.keySet());
            Collections.sort(this.taxa);
        }

        public static LightMSA parseStrictFASTA(File f) {
            HashMap<Taxon, StringBuilder> map = CollUtils.map();
            StringBuilder current = null;
            int len = -1;
            LogInfo.track("Reading alignment");
            int i = 0;
            for (String line : IO.i(f)) {
                if (line.length() <= 0) continue;
                if (line.charAt(0) == '>') {
                    LogInfo.logs("Taxon " + i++);
                    if (len == -1 && current != null) {
                        len = current.length();
                    }
                    if (current != null && current.length() != len) {
                        throw new RuntimeException();
                    }
                    current = new StringBuilder();
                    Taxon currentTaxon = new Taxon(line.substring(1));
                    map.put(currentTaxon, current);
                    continue;
                }
                current.append(line);
            }
            LogInfo.end_track();
            return new LightMSA(map);
        }
    }
}

