/*
 * Decompiled with CFR 0.152.
 */
package ev.io;

import ev.io.PreprocessGutellData;
import goblin.Taxon;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ma.GreedyDecoder;
import ma.MSAPoset;
import ma.MultiAlignment;
import nuts.io.IO;
import nuts.math.Sampling;
import nuts.util.CollUtils;
import pty.RootedTree;

public class RandomOverlappingDataset {
    public static String id16S = "16S";
    public static String id5S = "5S";

    public static void main(String[] args) {
        int nRep = 10;
        int n5S = 2;
        int n16S = 3;
        int len = 100;
        Random rand = new Random(1L);
        File balistyle = new File("data/gutell/processed/5S+16S/alignments-balistyle-10-2-3-100");
        balistyle.mkdir();
        List<MSAPoset> gp16Ss = PreprocessGutellData.randomDataSet(new File("/Users/bouchard/w/evolvere/data/gutell/raw/16S.3.alnfasta"), 10, 3, rand);
        List<MSAPoset> gp5Ss = PreprocessGutellData.randomDataSet(new File("/Users/bouchard/w/evolvere/data/gutell/raw/5S.3.alnfasta"), 10, 2, rand);
        for (int i = 0; i < gp16Ss.size(); ++i) {
            MSAPoset msa16S = RandomOverlappingDataset.annotate(RandomOverlappingDataset.chunk(gp16Ss.get(i), 100), (Object)id16S);
            MSAPoset msa5S = RandomOverlappingDataset.annotate(RandomOverlappingDataset.chunk(gp5Ss.get(i), 100), (Object)id5S);
            MSAPoset merged = RandomOverlappingDataset.merge(msa16S, msa5S);
            System.out.println(merged);
            MultiAlignment converted = merged.toMultiAlignmentObject();
            converted.saveToMSF(new File(balistyle, "" + i + ".msf"));
            RootedTree randomTree = RootedTree.Util.random(rand, merged.taxa());
            IO.writeToDisk(new File(balistyle, "" + i + ".newick"), RootedTree.Util.toNewick(randomTree));
        }
    }

    public static MSAPoset annotate(MSAPoset chunk, Object ann) {
        MSAPoset result = new MSAPoset(RandomOverlappingDataset.annotate(chunk.sequences(), ann));
        for (MSAPoset.Column c : chunk.columns()) {
            if (result.tryAdding(RandomOverlappingDataset.annotate(c.getPoints(), ann))) continue;
            throw new RuntimeException();
        }
        return result;
    }

    private static <S> Map<Taxon, S> annotate(Map<Taxon, S> map, Object ann) {
        HashMap result = CollUtils.map();
        for (Taxon t : map.keySet()) {
            result.put(new Taxon(t.toString() + "-" + ann), map.get(t));
        }
        return result;
    }

    public static MSAPoset merge(MSAPoset msa16s, MSAPoset msa5s) {
        HashMap<Taxon, String> seqs = CollUtils.map();
        seqs.putAll(msa16s.sequences());
        seqs.putAll(msa5s.sequences());
        MSAPoset result = new MSAPoset(seqs);
        for (MSAPoset.Column c : msa16s.columns()) {
            if (result.tryAdding(c)) continue;
            throw new RuntimeException();
        }
        for (MSAPoset.Column c : msa5s.columns()) {
            if (result.tryAdding(c)) continue;
            throw new RuntimeException();
        }
        return result;
    }

    public static MSAPoset chunk(MSAPoset msa, int length) {
        MSAPoset.Column anchor = null;
        for (MSAPoset.Column c : msa.linearizedColumns()) {
            if (!msa.isFull(c)) continue;
            anchor = c;
            break;
        }
        HashMap<Taxon, String> newSequences = CollUtils.map();
        HashMap<Taxon, Integer> leftBounds = CollUtils.map();
        for (Taxon t : msa.taxa()) {
            String oldSeq = msa.sequences().get(t);
            int pos = anchor.getPoints().get(t);
            leftBounds.put(t, pos);
            String newSeq = oldSeq.substring(pos, Math.min(oldSeq.length(), pos + length));
            newSequences.put(t, newSeq);
        }
        MSAPoset result = new MSAPoset(newSequences);
        for (GreedyDecoder.Edge e : msa.edges()) {
            if (!RandomOverlappingDataset.inBound(e, leftBounds, length)) continue;
            result.tryAdding(RandomOverlappingDataset.transform(e, leftBounds, length));
        }
        return result;
    }

    public static MSAPoset randomOverlappingSequences(MSAPoset msa, int length, Random rand) {
        ArrayList fulls = CollUtils.list();
        for (MSAPoset.Column c : msa.columns()) {
            if (!msa.isFull(c)) continue;
            fulls.add(c);
        }
        int randomIndex = rand.nextInt(fulls.size());
        MSAPoset.Column anchor = (MSAPoset.Column)fulls.get(randomIndex);
        HashMap<Taxon, String> newSequences = CollUtils.map();
        HashMap<Taxon, Integer> leftBounds = CollUtils.map();
        for (Taxon t : msa.taxa()) {
            String oldSeq = msa.sequences().get(t);
            int leftBound = Math.max(0, anchor.getPoints().get(t) - length + 1);
            int rightBound = Math.min(anchor.getPoints().get(t), oldSeq.length() - length + 1);
            int pos = Sampling.nextInt(rand, leftBound, rightBound);
            leftBounds.put(t, pos);
            String newSeq = oldSeq.substring(pos, pos + length);
            newSequences.put(t, newSeq);
        }
        MSAPoset result = new MSAPoset(newSequences);
        for (GreedyDecoder.Edge e : msa.edges()) {
            if (!RandomOverlappingDataset.inBound(e, leftBounds, length)) continue;
            result.tryAdding(RandomOverlappingDataset.transform(e, leftBounds, length));
        }
        return result;
    }

    private static GreedyDecoder.Edge transform(GreedyDecoder.Edge e, Map<Taxon, Integer> leftBounds, int length) {
        return new GreedyDecoder.Edge(e.index1() - leftBounds.get(e.lang1()), e.index2() - leftBounds.get(e.lang2()), e.lang1(), e.lang2());
    }

    private static boolean inBound(GreedyDecoder.Edge e, Map<Taxon, Integer> leftBounds, int length) {
        return RandomOverlappingDataset.inBound(e.index1(), leftBounds.get(e.lang1()), length) && RandomOverlappingDataset.inBound(e.index2(), leftBounds.get(e.lang2()), length);
    }

    private static boolean inBound(int index, int leftBound, int length) {
        return index >= leftBound && index < leftBound + length;
    }
}

