/*
 * Decompiled with CFR 0.152.
 */
package ev.io;

import ev.PairAlignCognateSet;
import fig.basic.IOUtils;
import fig.basic.Parallelizer;
import goblin.CognateSet;
import goblin.Taxon;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nuts.io.IO;
import nuts.util.CollUtils;
import nuts.util.Indexer;
import nuts.util.MathUtils;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class ReadCognates {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        CognateSet cs = CognateSet.restoreCognateSet(args[0]);
        final PairAlignCognateSet.CognateDataset data = new PairAlignCognateSet.CognateDataset(cs);
        ArrayList fileIndices = CollUtils.list();
        for (File f : IO.ls(new File(args[1]), "currentPartition")) {
            fileIndices.add(Integer.parseInt(("" + f).replaceAll("[^0-9]", "")));
        }
        Collections.sort(fileIndices);
        Iterator<File> iterator = fileIndices.iterator();
        while (iterator.hasNext()) {
            int fileIndex = (Integer)((Object)iterator.next());
            File f = new File("iteration" + fileIndex + ".currentPartition");
            ObjectInputStream in = IOUtils.openBinInHard(f);
            final Map current = (Map)in.readObject();
            final SummaryStatistics stat = new SummaryStatistics();
            Parallelizer<PairAlignCognateSet.Concept> parallelizer = new Parallelizer<PairAlignCognateSet.Concept>(4);
            parallelizer.setPrimaryThread();
            parallelizer.process(CollUtils.list(data.concepts()), new Parallelizer.Processor<PairAlignCognateSet.Concept>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void process(PairAlignCognateSet.Concept c, int _i, int _n, boolean log) {
                    Map map = (Map)current.get(c);
                    final ArrayList<Set<Taxon>> goldClusters = CollUtils.list(CollUtils.invert(data.cognateGroups(c)).values());
                    final ArrayList guessClusters = CollUtils.list(CollUtils.invert(map).values());
                    MathUtils.CostFunction<Set<Taxon>, Set<Taxon>> cf = new MathUtils.CostFunction<Set<Taxon>, Set<Taxon>>(){

                        @Override
                        public double cost(Set<Taxon> s, Set<Taxon> t) {
                            return CollUtils.inter(s, t).size();
                        }

                        @Override
                        public List<Set<Taxon>> getSs() {
                            return goldClusters;
                        }

                        @Override
                        public List<Set<Taxon>> getTs() {
                            return guessClusters;
                        }
                    };
                    double max = ReadCognates.sum(cf);
                    double score = MathUtils.cost(cf, MathUtils.maxWeightMatching(cf));
                    SummaryStatistics summaryStatistics = stat;
                    synchronized (summaryStatistics) {
                        stat.addValue(score / max);
                    }
                }
            });
            System.out.println("" + ("" + f).replaceAll("[^0-9]", "") + "\t" + stat.getMean());
        }
    }

    private static double sum(MathUtils.CostFunction<Set<Taxon>, Set<Taxon>> cf) {
        double sum = 0.0;
        for (Set<Taxon> s : cf.getSs()) {
            for (Set<Taxon> t : cf.getTs()) {
                sum += cf.cost(s, t);
            }
        }
        return sum;
    }

    private static Indexer<Set<Taxon>> getIndexer(Map<Taxon, Integer> map) {
        return new Indexer<Set<Taxon>>(CollUtils.invert(map).values());
    }
}

