/*
 * Decompiled with CFR 0.152.
 */
package ev.io;

import fig.basic.LogInfo;
import goblin.HLFeatureExtractor;
import goblin.HLParams;
import goblin.Taxon;
import java.util.HashMap;
import java.util.Map;
import ma.AffineGapAlignmentSampler;
import nuts.maxent.LabeledInstance;
import nuts.util.Arbre;
import nuts.util.Counter;
import pepper.Encodings;
import pty.UnrootedTree;

public class TKFWeights {
    public static Map<Taxon, AffineGapAlignmentSampler.CompiledTKFParams> compiledTKFParams(AffineGapAlignmentSampler.TKFParams params, UnrootedTree unrootedTree, Arbre<Taxon> rootedSubtree, double addSmallDelta) {
        HashMap<Taxon, AffineGapAlignmentSampler.CompiledTKFParams> result = new HashMap<Taxon, AffineGapAlignmentSampler.CompiledTKFParams>();
        for (Arbre<Taxon> a : rootedSubtree.nodes()) {
            if (a.isRoot()) continue;
            result.put(a.getContents(), params.compile(addSmallDelta + unrootedTree.totalBranchLengthDistance(a.getContents(), a.getParent().getContents())));
        }
        return result;
    }

    public static Counter<String> weights(Map<Taxon, AffineGapAlignmentSampler.CompiledTKFParams> params) {
        Counter<String> result = new Counter<String>();
        Encodings enc = params.values().iterator().next().getEncodings();
        for (Taxon lang : params.keySet()) {
            AffineGapAlignmentSampler.CompiledTKFParams curParam = params.get(lang);
            for (HLParams.HLContext ctxt : HLParams.allHLContexts(enc, lang)) {
                for (HLParams.HLOutcome out : ctxt.allOutcomes()) {
                    LabeledInstance<HLParams.HLContext, HLParams.HLOutcome> li = new LabeledInstance<HLParams.HLContext, HLParams.HLOutcome>(out, ctxt);
                    String feature = HLFeatureExtractor.getTKFFeatureName(li);
                    if (result.containsKey(feature)) continue;
                    double pr = Double.NaN;
                    if (HLFeatureExtractor.isSubstitution(li)) {
                        pr = curParam.alpha * curParam.transition(ctxt.top, out.outcome);
                    } else if (HLFeatureExtractor.isPhonemeInsertion(li)) {
                        pr = curParam.beta * curParam.stationary(out.outcome);
                    } else if (HLFeatureExtractor.isStopInsertion(li)) {
                        pr = 1.0 - curParam.beta;
                    } else if (HLFeatureExtractor.isDeletion(li)) {
                        pr = 1.0 - curParam.alpha;
                    } else if (HLFeatureExtractor.isRootModel(li)) {
                        double p = curParam.mu / (curParam.mu + curParam.lambda);
                        pr = out.outcomeChar() == '#' ? p : 1.0 - p;
                    } else {
                        throw new RuntimeException();
                    }
                    LogInfo.logsForce(feature + "\t" + pr);
                    result.setCount(feature, Math.log(pr));
                }
            }
        }
        return result;
    }
}

