/*
 * Decompiled with CFR 0.152.
 */
package ev.multi;

import ev.ex.PairAlign;
import ev.multi.ManyPairsAligner;
import ev.par.ExponentialFamily;
import ev.par.FeatureExtractor;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.exec.Execution;
import goblin.CognateId;
import java.io.File;
import java.io.ObjectOutputStream;
import java.util.List;
import ma.BalibaseCorpus;
import ma.GreedyDecoder;
import ma.MSAPoset;
import nuts.io.IO;
import nuts.maxent.MaxentClassifier;
import nuts.util.Counter;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class SimpleGreedyExperiment
implements Runnable {
    public static ExponentialFamily.ExponentialFamilyOptions expFamOptions = new ExponentialFamily.ExponentialFamilyOptions();
    public static FeatureExtractor.FeatureOptions featureOptions = new FeatureExtractor.FeatureOptions();
    public static MaxentClassifier.MaxentOptions<Object> learningOptions = new MaxentClassifier.MaxentOptions();
    public static ManyPairsAligner.ManyPairsAlignerOptions pairAlignOptions = new ManyPairsAligner.ManyPairsAlignerOptions();

    public static void main(String[] args) {
        IO.run(args, new SimpleGreedyExperiment(), "pair", pairAlignOptions, "bali", PairAlign.options, "efo", expFamOptions, "featop", featureOptions, "lo", learningOptions);
    }

    @Override
    public void run() {
        BalibaseCorpus bc = new BalibaseCorpus(PairAlign.options);
        ExponentialFamily expFam = ExponentialFamily.createExpfam(learningOptions, expFamOptions, featureOptions, bc.getDistances());
        SummaryStatistics stats = new SummaryStatistics();
        File dir = new File(Execution.getFile("alignments"));
        dir.mkdir();
        for (CognateId id : bc.getMultiAlignments().keySet()) {
            MSAPoset gold = MSAPoset.fromMultiAlignmentObject(bc.getMultiAlignment(id));
            Counter<GreedyDecoder.Edge> mostPairsPosterior = ManyPairsAligner.mostPairsPosterior(gold.sequences(), expFam, pairAlignOptions);
            List<MSAPoset.ROCPoint> roc = MSAPoset.ROC(gold.sequences(), mostPairsPosterior, gold, 50);
            double recall = roc.get((int)(roc.size() - 1)).recall;
            stats.addValue(recall);
            LogInfo.logsForce("PosteriorThreshold\tPrecision\tRecall");
            for (MSAPoset.ROCPoint point : roc) {
                LogInfo.logsForce("" + point.posterior + "\t" + point.precision + "\t" + point.recall);
            }
            try {
                ObjectOutputStream oos = IOUtils.openBinOut(new File(dir, id.toString().replace('/', '-') + ".Counter_Edge"));
                oos.writeObject(mostPairsPosterior);
                oos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

