/*
 * Decompiled with CFR 0.152.
 */
package ev.to;

import fig.basic.LogInfo;
import fig.basic.Option;
import java.io.File;
import ma.MSAPoset;
import ma.MultiAlignment;
import nuts.io.IO;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class Eval {
    public static void main(String[] args) {
        IO.run(args, new EvalMain());
    }

    public static class EvalMain
    implements Runnable {
        @Option
        public static String filter = "msf";
        @Option(required=true)
        public static String refDir = null;
        @Option(required=true)
        public static String guessDir = null;
        @Option
        public static boolean skipAnn = false;

        @Override
        public void run() {
            SummaryStatistics recall = new SummaryStatistics();
            SummaryStatistics precision = new SummaryStatistics();
            for (File refFile : IO.ls(new File(refDir), filter)) {
                File guessFile = new File(guessDir, refFile.getName());
                if (guessFile.exists()) {
                    try {
                        MSAPoset ref = skipAnn ? MSAPoset.fromMultiAlignmentObject(MultiAlignment.parse(refFile.getAbsolutePath())) : MSAPoset.coreBlocksFromMultiAlignmentObject(MultiAlignment.parseMSFToMultiAlignment(refFile.getAbsolutePath(), refFile.getAbsolutePath().replaceAll("[.]msf", "_ref1.ann")));
                        MSAPoset guess = MSAPoset.fromMultiAlignmentObject(MultiAlignment.parse(guessFile.getAbsolutePath()));
                        double currentRecall = MSAPoset.edgeRecall(ref, guess);
                        double currentPrecision = MSAPoset.edgePrecision(ref, guess);
                        recall.addValue(currentRecall);
                        precision.addValue(currentPrecision);
                        LogInfo.logs("" + refFile + "Recall:" + currentRecall + ", Precision:" + currentPrecision);
                    }
                    catch (Exception e) {
                        System.err.println("Problems with: " + refFile + ", skipping");
                    }
                    continue;
                }
                recall.addValue(0.0);
                LogInfo.warning("Missing file:" + guessFile + ", score set to zero");
            }
            LogInfo.logsForce("Recall:\n" + recall);
            LogInfo.logsForce("Precision:\n" + precision);
        }
    }
}

