/*
 * Decompiled with CFR 0.152.
 */
package fenchel.factor.multisites;

import fenchel.algo.FactorGraphInferenceAlgorithm;
import fenchel.factor.IdentityFactor;
import fenchel.factor.UnaryFactor;
import fenchel.factor.multisites.MSFactorGraph;
import fenchel.factor.multisites.MSUnaryFactor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nuts.tui.Table;

public class MSUnaryMap<N> {
    public final boolean skipLast;
    private final Map<N, double[][]> data;

    private MSUnaryMap(Map<N, double[][]> data, boolean skipLast) {
        this.skipLast = skipLast;
        this.data = data;
    }

    public static <N> MSUnaryMap<N> fromMSFactorGraphUnaryParameters(MSFactorGraph<N> fg, Collection<N> nodes, boolean skipLast) {
        return MSUnaryMap._fromFactorGraph(fg, nodes, false, skipLast);
    }

    public static <N> MSUnaryMap<N> emptyCopy(MSFactorGraph<N> fg, Collection<N> nodes, boolean skipLast) {
        return MSUnaryMap._fromFactorGraph(fg, nodes, true, skipLast);
    }

    private static <N> MSUnaryMap<N> _fromFactorGraph(MSFactorGraph<N> fg, Collection<N> nodes, boolean makeEmpty, boolean skipLast) {
        int nSites = fg.nSites();
        HashMap<N, double[][]> data = new HashMap<N, double[][]>();
        for (N node : nodes) {
            double[][] current = null;
            UnaryFactor factor = fg.getUnary(node);
            if (factor == IdentityFactor.identity) {
                int nStates = fg.nStates(node);
                current = new double[nSites][nStates];
                for (int site = 0; site < nSites; ++site) {
                    for (int state = 0; state < nStates; ++state) {
                        current[site][state] = makeEmpty || skipLast && state == nStates - 1 ? Double.NaN : 1.0;
                    }
                }
            } else {
                MSUnaryFactor cast = (MSUnaryFactor)factor;
                double[][] model = cast.normalizedValues();
                current = new double[nSites][cast.nStates()];
                for (int site = 0; site < cast.nSites(); ++site) {
                    double inverseOfLastValue = !skipLast ? 1.0 : 1.0 / model[site][cast.nStates() - 1];
                    for (int state = 0; state < cast.nStates(); ++state) {
                        current[site][state] = makeEmpty || skipLast && state == cast.nStates() - 1 ? Double.NaN : model[site][state] * inverseOfLastValue;
                    }
                }
            }
            data.put(node, current);
        }
        return new MSUnaryMap(data, skipLast);
    }

    public static <N> MSUnaryMap<N> fromMoments(FactorGraphInferenceAlgorithm<N> algorithm, Collection<N> nodes, boolean skipLast) {
        HashMap<N, double[][]> data = new HashMap<N, double[][]>();
        for (N node : nodes) {
            MSUnaryFactor factor = (MSUnaryFactor)algorithm.moment(node);
            double[][] values = factor.normalizedValues();
            if (skipLast) {
                for (int site = 0; site < values.length; ++site) {
                    values[site][values[0].length - 1] = Double.NaN;
                }
            }
            data.put(node, values);
        }
        return new MSUnaryMap(data, skipLast);
    }

    public Collection<N> nodes() {
        return this.data.keySet();
    }

    public double[][] getUnaryArray(N node) {
        return this.data.get(node);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (N node : this.nodes()) {
            result.append(node + ":\n" + Table.toString(this.getUnaryArray(node)) + "\n\n");
        }
        return result.toString();
    }

    public void setLastStatesToOne() {
        for (N node : this.nodes()) {
            double[][] current = this.getUnaryArray(node);
            for (int site = 0; site < current.length; ++site) {
                current[site][current[0].length - 1] = 1.0;
            }
        }
    }
}

