/*
 * Decompiled with CFR 0.152.
 */
package fenchel.measurefacto;

import fig.basic.UnorderedPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import nuts.math.Graph;
import nuts.math.Graphs;
import nuts.math.MutableGraph;
import nuts.util.CollUtils;

public class AcyclicDecompositions {
    public static <S> List<Graph<S>> randomForestCover(Graph<S> graph, Random rand) {
        boolean mainGraphConnected = Graphs.isConnected(graph);
        Set<UnorderedPair<S, S>> toCover = Graphs.edgeSet(graph);
        ArrayList<Graph<S>> result = new ArrayList<Graph<S>>();
        while (!toCover.isEmpty()) {
            ArrayList<UnorderedPair<S, S>> edgesList = CollUtils.list(toCover);
            AcyclicDecompositions.orderUsingToString(edgesList);
            Collections.shuffle(edgesList, rand);
            Set<UnorderedPair<S, S>> alreadyCovered = Graphs.edgeSet(graph);
            alreadyCovered.removeAll(toCover);
            ArrayList<UnorderedPair<S, S>> alreadyCoveredList = CollUtils.list(alreadyCovered);
            AcyclicDecompositions.orderUsingToString(alreadyCoveredList);
            Collections.shuffle(alreadyCoveredList, rand);
            edgesList.addAll(alreadyCoveredList);
            Graph<S> current = AcyclicDecompositions.forestSubgraph(edgesList, graph.vertexSet());
            if (mainGraphConnected && !Graphs.isTree(current)) {
                throw new RuntimeException();
            }
            result.add(current);
            toCover.removeAll(Graphs.edgeSet(current));
        }
        return result;
    }

    public static <S> Graph<S> forestSubgraph(List<UnorderedPair<S, S>> edges, Set<S> vertexSet) {
        MutableGraph<Object> result = new MutableGraph<Object>();
        for (S s : vertexSet) {
            result.addVertex(s);
        }
        for (UnorderedPair unorderedPair : edges) {
            result.addEdge(unorderedPair);
            if (Graphs.isForest(result)) continue;
            result.removeEdge(unorderedPair.getFirst(), unorderedPair.getSecond());
        }
        if (!Graphs.isForest(result)) {
            throw new RuntimeException();
        }
        return result;
    }

    public static <S> void orderUsingToString(List<S> items) {
        TreeMap<String, S> map = new TreeMap<String, S>();
        for (S item : items) {
            String str = item.toString();
            if (map.containsKey(str)) {
                throw new RuntimeException();
            }
            map.put(str, item);
        }
        items.clear();
        for (String key : map.keySet()) {
            items.add(map.get(key));
        }
    }

    public static Graph<Integer> completeBipart(int n) {
        MutableGraph<Integer> graph = new MutableGraph<Integer>();
        for (int i = 0; i < n; ++i) {
            for (int j = n; j < 2 * n; ++j) {
                graph.addEdge(i, j);
            }
        }
        return graph;
    }

    public static Graph<Integer> erdos(Random rand, int n) {
        MutableGraph<Integer> graph = new MutableGraph<Integer>();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!(rand.nextDouble() < 0.2)) continue;
                graph.addEdge(i, j);
            }
        }
        return graph;
    }

    public static void main(String[] args) {
        Random rand1 = new Random(10L);
        Graph<Integer> graph = AcyclicDecompositions.erdos(rand1, 50);
        for (int i = 0; i < 100; ++i) {
            Random rand = new Random(1L);
            List<Graph<Integer>> decomp = AcyclicDecompositions.randomForestCover(graph, rand);
            System.out.println(decomp.size());
            System.out.println("_------");
        }
    }
}

