/*
 * Decompiled with CFR 0.152.
 */
package fenchel.tests.utils;

import fenchel.factor.UnaryFactor;
import fenchel.factor.multisites.MSBinaryFactor;
import fenchel.tests.utils.NaiveUnary;
import java.util.List;

public class NaiveBinary
implements MSBinaryFactor {
    private final double[][] values;

    public NaiveBinary(double[][] values) {
        this.values = values;
    }

    @Override
    public UnaryFactor marginalize(List<UnaryFactor> _factorsOnSource) {
        int nSrc = this.values[0].length;
        int nDest = this.values.length;
        NaiveUnary factorOnSource = _factorsOnSource.size() == 0 ? null : (NaiveUnary)_factorsOnSource.get(0);
        NaiveUnary resultFactorOnDest = new NaiveUnary(new double[nDest]);
        for (int dest = 0; dest < nDest; ++dest) {
            double sum = 0.0;
            for (int src = 0; src < nSrc; ++src) {
                sum += (factorOnSource == null ? 1.0 : factorOnSource.values[src]) * this.values[dest][src];
            }
            resultFactorOnDest.values[dest] = sum;
        }
        return resultFactorOnDest;
    }

    @Override
    public int maxNumberOfFactorsSupported() {
        return 1;
    }

    @Override
    public int nFirstStates() {
        return this.values[0].length;
    }

    @Override
    public int nSecondStates() {
        return this.values.length;
    }
}

