/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.CharEncUtils;
import fig.basic.Exceptions;
import fig.basic.IOUtils;
import fig.basic.LogRun;
import fig.basic.Option;
import fig.basic.StopWatch;
import fig.basic.StrUtils;
import fig.basic.SysInfoUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LogInfo {
    @Option(gloss="Maximum indent level.")
    public static int maxIndLevel = 10;
    @Option(gloss="Maximum number of milliseconds between consecutive lines of output.")
    public static int msPerLine = 1000;
    @Option(gloss="File to write log.")
    public static String file = "";
    @Option(gloss="Whether to output to the console.", name="stdout")
    public static boolean writeToStdout = true;
    @Option(gloss="Dummy placeholder for a comment")
    public static String note = "";
    @Option(gloss="Force printing from logs*")
    public static boolean forcePrint;
    @Option(gloss="Maximum number of errors (via error()) to print")
    public static int maxPrintErrors;
    public static boolean forceSilent;
    public static BufferedReader stdin;
    public static PrintWriter stdout;
    public static PrintWriter stderr;
    static PrintWriter out;
    static PrintWriter fout;
    static int indLevel;
    static int stoppedIndLevel;
    static StringBuilder buf;
    static ArrayList<LogRun> runs;
    static StopWatch watch;
    static int numErrors;
    static int numWarnings;

    public static void track(String format, Object ... args) {
        LogInfo.track((Object)String.format(format, args), false);
    }

    public static void track(Object o) {
        LogInfo.track(o, false);
    }

    public static synchronized void track_methods(Object o, String[] methodNames) throws Exception {
        for (String methodName : methodNames) {
            LogInfo.track_method(o, methodName);
        }
    }

    public static synchronized void track_method(Object o, String methodName, Object ... args) throws Exception {
        Class<?> c = o.getClass();
        Method[] methods = c.getDeclaredMethods();
        Method targetMethod = null;
        for (Method m : methods) {
            if (!m.getName().equals(methodName)) continue;
            targetMethod = m;
            break;
        }
        if (targetMethod == null) {
            String msg = String.format("Couldn't find method %d in class %s", methodName, c.getName());
            throw new IllegalArgumentException(msg);
        }
        LogInfo.track(methodName);
        targetMethod.invoke(o, args);
        LogInfo.end_track();
    }

    public static synchronized void track_method(Object o, String methodName) throws Exception {
        LogInfo.track_method(o, methodName, new Object[0]);
    }

    public static synchronized void track(Object o, boolean printAllLines) {
        LogInfo.track(o, printAllLines, false);
    }

    public static synchronized void track(Object o, boolean printAllChildLines, boolean printIfParentPrinted) {
        if (LogInfo.indWithin()) {
            if (printIfParentPrinted && LogInfo.parentPrinted()) {
                LogInfo.thisRun().forcePrint();
            }
            if (LogInfo.thisRun().shouldPrint()) {
                LogInfo.print(o);
                buf.append(" {\n");
                LogInfo.childRun().init();
                LogInfo.childRun().printAllLines = printAllChildLines;
            } else {
                stoppedIndLevel = indLevel;
                maxIndLevel = -maxIndLevel;
            }
        }
        ++indLevel;
    }

    public static <T> T end_track(T x) {
        LogInfo.end_track();
        return x;
    }

    public static synchronized void end_track() {
        if (stoppedIndLevel == --indLevel) {
            stoppedIndLevel = -1;
            maxIndLevel = -maxIndLevel;
        }
        if (LogInfo.indWithin() && LogInfo.thisRun().newLine()) {
            ++indLevel;
            int n = LogInfo.thisRun().numOmitted();
            if (n > 0) {
                LogInfo.print("... " + n + " lines omitted ...\n");
            }
            --indLevel;
            LogInfo.childRun().finish();
            if (buf.length() > 0) {
                buf.delete(0, buf.length());
            } else {
                LogInfo.print("}");
            }
            StopWatch ct = LogInfo.childRun().watch;
            if (ct.ms > 1000L) {
                LogInfo.rawPrint(" [" + ct);
                if (indLevel > 0) {
                    StopWatch tt = LogInfo.thisRun().watch;
                    tt.stop();
                    LogInfo.rawPrint(", cum. " + tt);
                }
                LogInfo.rawPrint("]");
            }
            LogInfo.rawPrint("\n");
        }
    }

    public static void logs(String format, Object ... args) {
        LogInfo.logs(String.format(format, args));
    }

    public static synchronized void logs(Object o) {
        if (forcePrint || LogInfo.indWithin() && LogInfo.thisRun().newLine()) {
            LogInfo.printLines(o);
        }
    }

    public static synchronized void logsForce(String format, Object ... args) {
        LogInfo.printLines(String.format(format, args));
    }

    public static synchronized void logsForce(Object o) {
        LogInfo.thisRun().newLine();
        LogInfo.printLines(o);
    }

    public static void logss(String format, Object ... args) {
        LogInfo.logss(String.format(format, args));
    }

    public static synchronized void logss(Object o) {
        if (LogInfo.parentPrinted()) {
            LogInfo.thisRun().forcePrint();
        }
        LogInfo.logs(o);
    }

    private static boolean parentPrinted() {
        return indLevel == 0 || indLevel <= maxIndLevel && LogInfo.parentIndWithin() && LogInfo.parentRun().shouldPrint();
    }

    public static void dbg(String format, Object ... args) {
        LogInfo.dbg(String.format(format, args));
    }

    public static void dbg(Object o) {
        LogInfo.logss("DBG: " + o);
    }

    public static void rant(String format, Object ... args) {
        LogInfo.rant(String.format(format, args));
    }

    public static void rant(Object o) {
        LogInfo.logss("RANT: " + o);
    }

    public static void error(String format, Object ... args) {
        LogInfo.error(String.format(format, args));
    }

    public static void error(Object o) {
        if (numErrors < maxPrintErrors) {
            LogInfo.print("ERROR: " + o + "\n");
        }
        ++numErrors;
    }

    public static void warning(String format, Object ... args) {
        LogInfo.warning(String.format(format, args));
    }

    public static void warning(Object o) {
        LogInfo.print("WARNING: " + o + "\n");
        ++numWarnings;
    }

    public static void fail(String format, Object ... args) {
        LogInfo.fail(String.format(format, args));
    }

    public static void fail(Object o) {
        throw Exceptions.bad(o);
    }

    public static void printProgStatus() {
        LogInfo.logs("PROG_STATUS: time = " + watch.stop() + ", memory = " + SysInfoUtils.getUsedMemoryStr());
    }

    public static <T> void printList(String s, String lines) {
        LogInfo.printList(s, Arrays.asList(lines.split("\n")));
    }

    public static <T> void printList(String s, List<T> items) {
        LogInfo.track((Object)s, true);
        for (T x : items) {
            LogInfo.logs(x);
        }
        LogInfo.end_track();
    }

    public static void updateStdStreams() {
        try {
            stdin = CharEncUtils.getReader(System.in);
            stdout = CharEncUtils.getWriter(System.out);
            stderr = CharEncUtils.getWriter(System.err);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void init() {
        if (!file.equals("")) {
            fout = IOUtils.openOutHard(file);
        }
        if (writeToStdout) {
            out = stdout;
        }
    }

    private static LogRun parentRun() {
        return runs.get(indLevel - 1);
    }

    private static LogRun thisRun() {
        return runs.get(indLevel);
    }

    private static LogRun childRun() {
        return runs.get(indLevel + 1);
    }

    private static boolean indWithin() {
        return indLevel <= maxIndLevel;
    }

    private static boolean parentIndWithin() {
        return indLevel - 1 <= maxIndLevel;
    }

    public static void main(String[] args) {
        System.out.println(forceSilent);
    }

    private static void rawPrint(Object o) {
        if (forceSilent) {
            return;
        }
        if (out != null) {
            out.print(o);
            out.flush();
        }
        if (fout != null) {
            fout.print(o);
            fout.flush();
        }
    }

    private static void print(Object o) {
        LogInfo.rawPrint(buf);
        buf.delete(0, buf.length());
        for (int i = 0; i < indLevel; ++i) {
            LogInfo.rawPrint("  ");
        }
        LogInfo.rawPrint(o);
    }

    private static void printLines(Object o) {
        String s;
        if (o == null) {
            o = "null";
        }
        if ((s = StrUtils.toString(o)).indexOf(10) == -1) {
            LogInfo.print(s + "\n");
        } else {
            for (String t : StrUtils.split(s, "\n")) {
                LogInfo.print(t + "\n");
            }
        }
    }

    public static StopWatch getWatch() {
        return watch;
    }

    public static int getNumErrors() {
        return numErrors;
    }

    public static int getNumWarnings() {
        return numWarnings;
    }

    static {
        maxPrintErrors = 10000;
        LogInfo.updateStdStreams();
        forceSilent = false;
        buf = new StringBuilder();
        indLevel = 0;
        stoppedIndLevel = -1;
        runs = new ArrayList(128);
        for (int i = 0; i < 128; ++i) {
            runs.add(new LogRun());
        }
        watch = new StopWatch();
        watch.start();
        out = stdout;
    }
}

