/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.LogInfo;
import fig.basic.StopWatch;

class LogRun {
    int numLines;
    int numLinesPrinted;
    int nextLineToPrint;
    StopWatch watch = new StopWatch();
    boolean printAllLines;
    boolean forcePrint;

    public LogRun() {
        this.init();
    }

    void init() {
        this.numLines = 0;
        this.numLinesPrinted = 0;
        this.nextLineToPrint = 0;
        this.printAllLines = false;
        this.watch.start();
    }

    void finish() {
        this.nextLineToPrint = -1;
        this.watch.stop();
    }

    void forcePrint() {
        this.forcePrint = true;
    }

    boolean shouldPrint() {
        return this.forcePrint || this.nextLineToPrint == this.numLines;
    }

    int numOmitted() {
        return this.numLines - this.numLinesPrinted;
    }

    boolean newLine() {
        boolean p = this.shouldPrint();
        ++this.numLines;
        if (!p) {
            return false;
        }
        ++this.numLinesPrinted;
        int msPerLine = LogInfo.msPerLine;
        if (this.numLines <= 2 || msPerLine == 0 || this.printAllLines || this.forcePrint) {
            ++this.nextLineToPrint;
        } else {
            this.watch.stop();
            this.nextLineToPrint = this.watch.ms == 0L ? (this.nextLineToPrint *= 2) : (this.nextLineToPrint += (int)Math.max((double)this.numLines * (double)msPerLine / (double)this.watch.ms, 1.0));
        }
        this.forcePrint = false;
        return true;
    }
}

