/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.exec.servlet.ArgumentException;
import fig.exec.servlet.DirFileView;
import fig.exec.servlet.DirSource;
import fig.exec.servlet.DomainView;
import fig.exec.servlet.FieldListMap;
import fig.exec.servlet.FileFactory;
import fig.exec.servlet.FileView;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Trail;
import fig.exec.servlet.UpdateQueue;
import fig.exec.servlet.UpdateSpec;
import fig.exec.servlet.View;
import fig.exec.servlet.WebState;
import java.io.File;

public class FileViewDB
extends View<FileView> {
    private static final String rootName = new File("/").toString();
    private static final int cacheSize = 10;
    protected FileFactory factory;
    protected DomainView domainView;
    protected FileView rootFileView;

    public FileViewDB(Trail trail, FileFactory factory, DomainView domainView) {
        this.trail = trail;
        this.factory = factory;
        this.domainView = domainView;
        this.rootFileView = new DirFileView(this.childTrail(rootName), new DirSource(domainView, rootName), factory, true, false);
        this.addItemHard(this.rootFileView);
    }

    @Override
    public FileView getItem(String name) throws MyException {
        FileView fileView = (FileView)this.items.get(name);
        if (fileView != null) {
            if (!name.equals(rootName)) {
                this.items.putAtEnd(name);
            }
        } else {
            WebState.logs("FileViewDB: CREATE " + this.childTrail(name));
            File path = new File(name);
            if (!path.isDirectory()) {
                throw new ArgumentException(path + " is not a directory");
            }
            fileView = new DirFileView(this.childTrail(name), new DirSource(this.domainView, path), this.factory, false, true);
            this.items.put(name, fileView);
            if (this.items.size() > 10) {
                this.items.removeAt(1);
            }
        }
        return fileView;
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.updateChildren(spec, priority);
    }

    @Override
    public FieldListMap getMetadataFields() {
        return new FieldListMap();
    }

    @Override
    public FieldListMap getItemsFields() {
        return this.rootFileView.getMetadataFields();
    }

    public FileView getRootFileView() {
        return this.rootFileView;
    }
}

