/*
 * Decompiled with CFR 0.152.
 */
package fig.exec.servlet;

import fig.basic.Fmt;
import fig.exec.servlet.Exceptions;
import fig.exec.servlet.Field;
import fig.exec.servlet.FileView;
import fig.exec.servlet.Item;
import fig.exec.servlet.MapFileItem;
import fig.exec.servlet.MyException;
import fig.exec.servlet.Value;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

class MapFileField
extends Field {
    private FileView fileView;
    private String file;
    private String key;
    private Class type;
    private static final DateFormat standardDateFormat = new SimpleDateFormat("EEE MMM dd kk:mm:ss zzz yyyy");

    public MapFileField(String name, String gloss, String file, String key, FileView fileView) {
        super(name, gloss);
        this.file = file;
        this.key = key;
        this.type = String.class;
        this.fileView = fileView;
    }

    public MapFileField(String name, String gloss, String file, String key, Class type, FileView fileView) {
        super(name, gloss);
        this.file = file;
        this.key = key;
        this.type = type;
        this.fileView = fileView;
    }

    public static Field parse(String name, String gloss, String s, FileView fileView) {
        StringTokenizer st = new StringTokenizer(s, ":");
        if (st.countTokens() != 2) {
            return null;
        }
        return new MapFileField(name, gloss, st.nextToken(), st.nextToken(), fileView);
    }

    public String toString() {
        return this.file + ":" + this.key;
    }

    public MapFileItem getMapFileItem(Item item) throws MyException {
        File path = item.getGroundedPath();
        return Exceptions.cast(this.fileView.getItem(new File(path, this.file).toString()), MapFileItem.class);
    }

    public MapFileItem getMapFileItemEasy(Item item) {
        try {
            return this.getMapFileItem(item);
        }
        catch (MyException e) {
            return null;
        }
    }

    @Override
    public Value getValue(Item item) {
        MapFileItem mapFileItem = this.getMapFileItemEasy(item);
        if (mapFileItem == null) {
            return new Value(null);
        }
        String s = mapFileItem.getValue(this.key);
        if (s == null) {
            return new Value(null);
        }
        if (this.type == Date.class) {
            try {
                Date d = standardDateFormat.parse(s);
                return this.processValue(new Value(Fmt.formatEasyDateTime(d.getTime())));
            }
            catch (ParseException e) {
                return this.processValue(new Value(s));
            }
        }
        return this.processValue(new Value(s));
    }

    @Override
    public void changeValue(Item item, String newValue) throws MyException {
        MapFileItem mapFileItem = this.getMapFileItem(item);
        mapFileItem.setValue(this.key, newValue);
    }
}

