/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.Fmt;
import fig.basic.StopWatch;
import fig.basic.Utils;
import fig.servlet.FieldListMap;
import fig.servlet.FileException;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.MyExceptions;
import fig.servlet.OperationRP;
import fig.servlet.Permissions;
import fig.servlet.ResponseObject;
import fig.servlet.ResponseParams;
import fig.servlet.ResponseStream;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import fig.servlet.Value;
import fig.servlet.WebState;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;

public class FileItem
extends Item {
    protected FileType fileType = null;
    protected long fileSize = -1L;
    protected long lastModifiedTime = -1L;

    public FileItem(Item parent, String name, String sourcePath) {
        super(parent, name, sourcePath);
    }

    @Override
    protected Value getIntrinsicFieldValue(String fieldName) throws MyException {
        if (fieldName.equals("type")) {
            return new Value("" + (Object)((Object)this.fileType));
        }
        if (fieldName.equals("size")) {
            return this.getFileSizeValue();
        }
        if (fieldName.equals("lastModified")) {
            return this.getLastModifiedTimeValue();
        }
        return super.getIntrinsicFieldValue(fieldName);
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap();
        fields.add("type", "File type");
        fields.add((String)"size", (String)"Size of file").numeric = true;
        fields.add((String)"lastModified", (String)"Time of last modification").numeric = true;
        return fields;
    }

    public void updateShallow(UpdateSpec spec) throws MyException {
        File path = new File(this.sourcePath);
        if (path.exists()) {
            this.fileType = path.isDirectory() ? FileType.dir : (path.isFile() ? FileType.file : null);
            this.fileSize = path.length();
            this.lastModifiedTime = path.lastModified();
        } else {
            this.fileType = null;
            this.fileSize = -1L;
            this.lastModifiedTime = -1L;
        }
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.updateShallow(spec);
    }

    @Override
    public ResponseObject handleOperation(OperationRP req, Permissions perm) throws MyException {
        String op = req.op;
        File path = new File(this.sourcePath);
        if (op.equals("summary")) {
            return new ResponseParams("Will be supported soon");
        }
        if (op.equals("cmd")) {
            perm.checkCanExecute();
            String cmd = req.getReq("cmd");
            cmd = "cat " + path + " | " + cmd;
            WebState.logs("Executing: " + cmd);
            try {
                Process proc = Utils.openSystem(cmd);
                return new ResponseStream(proc.getInputStream());
            }
            catch (IOException e) {
                throw new MyException("Error executing: " + e);
            }
        }
        if (op.equals("download")) {
            try {
                if (!path.getCanonicalPath().toString().startsWith(perm.accessRootDir.toString())) {
                    throw new MyException("Can only access " + perm.accessRootDir);
                }
                return new ResponseStream(new FileInputStream(path));
            }
            catch (IOException e) {
                throw new FileException(e);
            }
        }
        return super.handleOperation(req, perm);
    }

    @Override
    protected boolean isView() {
        return false;
    }

    @Override
    protected Item newItem(String name) throws MyException {
        throw MyExceptions.unsupported;
    }

    public Value getFileSizeValue() {
        if (this.fileSize == -1L) {
            return new Value(null);
        }
        return new Value(Fmt.bytesToString(this.fileSize), "" + this.fileSize);
    }

    public Value getLastModifiedTimeValue() {
        if (this.lastModifiedTime == -1L) {
            return new Value(null);
        }
        return new Value(Fmt.formatEasyDateTime(this.lastModifiedTime), "" + this.lastModifiedTime);
    }

    public Value getSinceLastModifiedTimeValue() {
        if (this.lastModifiedTime == -1L) {
            return new Value(null);
        }
        return FileItem.getSinceLastModifiedTimeValue(this.getSinceLastModifiedTime());
    }

    public static Value getSinceLastModifiedTimeValue(long lastModifiedTime) {
        long time = FileItem.getSinceLastModifiedTime(lastModifiedTime);
        return new Value(new StopWatch(time).toString(), "" + time);
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getSinceLastModifiedTime() {
        return FileItem.getSinceLastModifiedTime(this.lastModifiedTime);
    }

    public static long getSinceLastModifiedTime(long lastModifiedTime) {
        return new Date().getTime() - lastModifiedTime;
    }

    public static enum FileType {
        file,
        dir;

    }
}

