/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.Utils;
import fig.servlet.ExecItem;
import fig.servlet.FieldListMap;
import fig.servlet.FileItem;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.MyExceptions;
import fig.servlet.OperationRP;
import fig.servlet.Permissions;
import fig.servlet.ReadyExecView;
import fig.servlet.RequestParams;
import fig.servlet.ResponseObject;
import fig.servlet.ResponseParams;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import fig.servlet.Value;
import fig.servlet.ValueProcessor;
import fig.servlet.WorkerView;
import fig.servlet.WorkerViewDB;
import java.io.File;
import java.util.Date;

public class WorkerItem
extends Item {
    private static final int messageTimeoutMs = 300000;
    private long lastMessageTime = -1L;
    private long lastGetJobTime = -1L;
    private boolean hasUpdated;
    private boolean kill;
    private boolean terminate;

    public WorkerItem(Item parent, String name, String sourcePath) {
        super(parent, name, sourcePath);
    }

    @Override
    protected FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap();
        fields.add((String)"host", (String)"Host name").processor = new ValueProcessor("s/\\..*/");
        fields.add(countField);
        fields.add("sinceLastMessageTime", "last", "Time elapsed since last message from worker");
        fields.add("status", "Status of the worker");
        fields.add("version", "ver", "Version of the worker code");
        fields.add("uptime", "Time worker has spent up");
        fields.add((String)"cpuSpeed", (String)"CPU speed (MHz)").setNumeric((boolean)true).processor = new ValueProcessor("s/$/ MHz");
        Object[] objectArray = new Object[]{"$numFreeCPUs", "/", "$numTotalCPUs"};
        fields.add((String)"freeCPUs", (String)"#fcpu", (String)"Number of free CPUs", (Object[])objectArray).numeric = true;
        fields.add((String)"freeMemory", (String)"fmem", (String)"Free memory").setNumeric((boolean)true).processor = new ValueProcessor("BYTES");
        fields.add("procSummary", "The heavy processes running on the machine (%cpu, %mem, user, command)");
        Object[] objectArray2 = new Object[]{"$numSuccessJobs", "/", "$numJobs"};
        fields.add((String)"successJobs", (String)"jobs", (String)"Fraction of successful jobs", (Object[])objectArray2).numeric = true;
        fields.add("qualified", "If this worker asks for a job, will it be able to get one?");
        fields.add((String)"nice", (String)"What to set the nice value to when running jobs").setMutable((boolean)true).numeric = true;
        fields.add("disabled", "Whether this worker is temporarily disabled").setMutable(true);
        fields.add((String)"priority", (String)"Who has first dibs on jobs (lower is better)").setMutable((boolean)true).numeric = true;
        return fields;
    }

    @Override
    protected FieldListMap getItemsFields() {
        return ExecItem.createThunkFields();
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.updateItemsFromFile(spec);
    }

    public Value getSinceLastMessageTimeValue() throws MyException {
        if (this.lastMessageTime == -1L) {
            return new Value(null);
        }
        Value value = FileItem.getSinceLastModifiedTimeValue(this.lastMessageTime);
        if (FileItem.getSinceLastModifiedTime(this.lastMessageTime) >= 300000L) {
            return new Value(value.value + "*", value.cmpKey);
        }
        return value;
    }

    protected int getNice() {
        return Utils.parseIntEasy((String)this.metadataMap.get("nice"), 0);
    }

    protected int getNumFreeCPUs() {
        return Utils.parseIntEasy((String)this.metadataMap.get("numFreeCPUs"), 0);
    }

    protected long getFreeMemory() {
        return Utils.parseLongEasy((String)this.metadataMap.get("freeMemory"), 0L);
    }

    protected boolean isDisabled() {
        return Boolean.parseBoolean((String)this.metadataMap.get("disabled"));
    }

    protected int getPriority() {
        return Utils.parseIntEasy((String)this.metadataMap.get("priority"), Integer.MAX_VALUE);
    }

    protected boolean isQualified() {
        return ((WorkerView)this.parent).isQualified(this);
    }

    public boolean isSeekingJob() {
        if (this.isDisabled()) {
            return false;
        }
        int getJobTimeoutMs = 10000;
        return new Date().getTime() - this.lastGetJobTime < 10000L;
    }

    public ResponseObject setStatus(RequestParams params) throws MyException {
        this.lastMessageTime = new Date().getTime();
        if (!this.hasUpdated && new File(this.fileSourcePath()).exists()) {
            this.loadFromDisk();
        }
        this.metadataMap.put("host", params.get("host"));
        this.metadataMap.put("status", params.get("status"));
        this.metadataMap.put("version", params.get("version"));
        this.metadataMap.put("uptime", params.get("uptime"));
        this.metadataMap.put("cpuSpeed", params.get("cpuSpeed"));
        this.metadataMap.put("numFreeCPUs", params.get("numFreeCPUs"));
        this.metadataMap.put("numTotalCPUs", params.get("numTotalCPUs"));
        this.metadataMap.put("freeMemory", params.get("freeMemory"));
        this.metadataMap.put("procSummary", params.get("procSummary"));
        this.metadataMap.put("numSuccessJobs", params.get("numSuccessJobs"));
        this.metadataMap.put("numJobs", params.get("numJobs"));
        this.saveToDisk();
        this.hasUpdated = true;
        ResponseParams resp = new ResponseParams(true, "Status set");
        if (this.kill) {
            resp.put("kill", "true");
            this.kill = false;
        }
        if (this.terminate) {
            resp.put("terminate", "true");
            this.terminate = false;
        }
        return resp;
    }

    public ResponseObject getJob(RequestParams params) throws MyException {
        this.lastGetJobTime = new Date().getTime();
        ReadyExecView readyExecView = ((WorkerViewDB)this.parent.parent).readyExecView;
        if (this.isDisabled()) {
            return new ResponseParams(true, "Disabled");
        }
        if (!this.isQualified()) {
            return new ResponseParams(true, "Not qualified");
        }
        ExecItem execItem = readyExecView.popAReadyExecItem(this.getFreeMemory());
        if (execItem == null) {
            return new ResponseParams(true, "No ready exec items for you");
        }
        execItem.assignToWorker(this);
        this.addItem(execItem);
        this.saveToDisk();
        ResponseParams resp = new ResponseParams("Got a job");
        resp.put("nice", (Object)Math.max(execItem.getNice(), this.getNice()));
        resp.put("workingDir", execItem.getWorkingDir());
        resp.put("command", execItem.getCommand());
        return resp;
    }

    @Override
    protected Value getIntrinsicFieldValue(String fieldName) throws MyException {
        if (fieldName.equals("procSummary") && this.name.matches(".+-\\d+$") && !this.name.endsWith("-1")) {
            return new Value("(suppressed)");
        }
        if (fieldName.equals("sinceLastMessageTime")) {
            return this.getSinceLastMessageTimeValue();
        }
        if (fieldName.equals("qualified")) {
            return new Value("" + this.isQualified());
        }
        return super.getIntrinsicFieldValue(fieldName);
    }

    @Override
    public ResponseObject handleOperation(OperationRP req, Permissions perm) throws MyException {
        String op = req.op;
        if (op.equals("setStatus")) {
            return this.setStatus(req);
        }
        if (op.equals("getJob")) {
            return this.getJob(req);
        }
        if (op.equals("kill")) {
            this.kill = true;
            return new ResponseParams("Set the kill flag; will take effect when worker contacts server");
        }
        if (op.equals("terminate")) {
            this.terminate = true;
            return new ResponseParams("Set the terminate flag; will take effect when worker contacts server");
        }
        return super.handleOperation(req, perm);
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    protected Item newItem(String name) throws MyException {
        throw MyExceptions.unsupported;
    }

    boolean muchBetter(WorkerItem that) {
        return this.cpuMuchBetter(that) && this.memMuchBetter(that);
    }

    boolean cpuMuchBetter(WorkerItem that) {
        int n2;
        int n1 = this.getNumFreeCPUs();
        return n1 > (n2 = that.getNumFreeCPUs());
    }

    boolean memMuchBetter(WorkerItem that) {
        long n2;
        long n1 = this.getFreeMemory();
        return n1 > (n2 = that.getFreeMemory()) * 2L;
    }
}

