/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import fig.basic.Pair;
import fig.servlet.FieldListMap;
import fig.servlet.FileUtils;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import fig.servlet.WorkerItem;

public class WorkerView
extends Item {
    public WorkerView(Item parent, String name, String sourcePath) {
        super(parent, name, sourcePath);
        IOUtils.createNewDirIfNotExistsEasy(sourcePath);
    }

    @Override
    public FieldListMap getItemsFields() {
        return new WorkerItem(null, null, null).getMetadataFields();
    }

    @Override
    protected Item getItem(String name) throws MyException {
        return this.getItemOrNewAdd(name);
    }

    @Override
    protected String fileSourcePath() {
        return null;
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.updateItemsFromDir(-1, FileUtils.TraverseSpec.matchExt("index"), true);
        this.updateChildren(spec, priority);
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    protected Item newItem(String name) throws MyException {
        return new WorkerItem(this, name, this.childNameToIndexSourcePath(name));
    }

    @Override
    protected String tableType() {
        return "WorkerView";
    }

    @Override
    protected String getDescription() {
        return "List of worker machines";
    }

    @Override
    protected Pair<String, Boolean> getDefaultSortSpec() {
        return new Pair<String, Boolean>("name", false);
    }

    public boolean isQualified(WorkerItem queryItem) {
        WorkerItem item;
        int bestPriority = Integer.MAX_VALUE;
        for (Item _item : this.items.values()) {
            item = (WorkerItem)_item;
            if (!item.isSeekingJob()) continue;
            bestPriority = Math.min(bestPriority, item.getPriority());
        }
        if (bestPriority != queryItem.getPriority()) {
            return false;
        }
        for (Item _item : this.items.values()) {
            item = (WorkerItem)_item;
            if (!item.isSeekingJob() || bestPriority != item.getPriority() || !item.muchBetter(queryItem)) continue;
            return false;
        }
        return true;
    }
}

