/*
 * Decompiled with CFR 0.152.
 */
package gep.comparisons;

import java.io.File;
import java.util.Random;
import nuts.io.IO;
import nuts.math.RateMtxUtils;
import nuts.tui.Table;
import nuts.util.MathUtils;

public class TargetModel {
    public final double[][] transitionRates;
    public final double[][] emiPrs;

    public TargetModel(double[][] transitionRates, double[][] emiPrs) {
        RateMtxUtils.checkRateMtx(transitionRates);
        for (double[] prs : emiPrs) {
            MathUtils.checkIsProb(prs);
        }
        this.transitionRates = transitionRates;
        this.emiPrs = emiPrs;
    }

    public String toString() {
        return "RateMtx:\n" + Table.toString(this.transitionRates) + "\nUnitTranMtx:\n" + Table.toString(RateMtxUtils.marginalTransitionMtx(this.transitionRates, 1.0)) + "\nEmiMtx:\n" + Table.toString(this.emiPrs);
    }

    public void save(File f) {
        f.mkdir();
        IO.writeToDisk(new File(f, "transitionRates.csv"), this.transitionRates);
        IO.writeToDisk(new File(f, "emissionPrs.csv"), this.emiPrs);
        IO.writeToDisk(new File(f, "nHiddenStates.txt"), "" + this.transitionRates.length);
        IO.writeToDisk(new File(f, "nObservedStates.txt"), "" + this.emiPrs[0].length);
    }

    public static TargetModel randomTargetType1(Random rand, int hidSize, int obsSize, double p, double small, double largeSmallDiff) {
        double[][] emiPrs = TargetModel.randomDeterministic(rand, hidSize, obsSize);
        double[][] rateMtx = new double[hidSize][hidSize];
        for (int i = 0; i < hidSize; ++i) {
            for (int j = i + 1; j < hidSize; ++j) {
                double d = small + (rand.nextDouble() < p ? largeSmallDiff : 0.0);
                rateMtx[j][i] = d;
                rateMtx[i][j] = d;
            }
        }
        RateMtxUtils.fillRateMatrixDiagonalEntries(rateMtx);
        return new TargetModel(rateMtx, emiPrs);
    }

    private static double[][] randomDeterministic(Random rand, int hidSize, int obsSize) {
        double[][] result = new double[hidSize][obsSize];
        for (int i = 0; i < hidSize; ++i) {
            result[i][rand.nextInt((int)obsSize)] = 1.0;
        }
        return result;
    }
}

