/*
 * Decompiled with CFR 0.152.
 */
package gep.model;

import gep.model.SplitContext;
import gep.model.SufficientStatistics;
import java.util.HashSet;
import java.util.Random;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.CounterMap;
import nuts.util.MathUtils;

public class SufficientStatisticsImpl<C, S>
implements SufficientStatistics<C, S> {
    private Counter bmStats = new Counter();
    private CounterMap<C, S> stateTransStats = new CounterMap();
    private Counter<C> waitingTimeStats = new Counter();

    @Override
    public Counter getBaseMeasureStats() {
        return this.bmStats;
    }

    @Override
    public CounterMap<C, S> getStateTransitionStats() {
        return this.stateTransStats;
    }

    @Override
    public Counter<C> getWaitingTimeStats() {
        return this.waitingTimeStats;
    }

    public SufficientStatisticsImpl() {
    }

    public SufficientStatisticsImpl(SufficientStatistics<C, S> model) {
        this.bmStats.incrementAll(model.getBaseMeasureStats());
        this.waitingTimeStats.incrementAll(model.getWaitingTimeStats());
        this.stateTransStats.incrementAll(model.getStateTransitionStats());
    }

    public String toString() {
        return "StateTrans:" + this.stateTransStats.toString() + "\nWaitTimes:" + this.waitingTimeStats.toString() + "\nBM:" + this.bmStats.toString();
    }

    public static int nHiddenStates(SufficientStatistics<SplitContext, SplitContext> ss) {
        return SufficientStatisticsImpl.nHiddenStates(ss.getStateTransitionStats());
    }

    public static int nHiddenStates(CounterMap<SplitContext, SplitContext> stateTransStats) {
        HashSet set = CollUtils.set();
        for (SplitContext sc1 : stateTransStats.keySet()) {
            Counter<SplitContext> c = stateTransStats.getCounter(sc1);
            if (sc1.level() == 0 && c.totalCount() > 0.0) {
                set.add(sc1.getU());
            }
            for (SplitContext sc2 : c.keySet()) {
                if (!(stateTransStats.getCount(sc1, sc2) > 0.0) || sc2.level() != 0) continue;
                set.add(sc2.getU());
            }
        }
        return set.size();
    }

    public static <C, S> void plusEqual(SufficientStatistics<C, S> dest, SufficientStatistics<C, S> src) {
        dest.getBaseMeasureStats().incrementAll(src.getBaseMeasureStats());
        dest.getWaitingTimeStats().incrementAll(src.getWaitingTimeStats());
        dest.getStateTransitionStats().incrementAll(src.getStateTransitionStats());
    }

    public static <C, S> void minusEqualCheckNonNeg(SufficientStatistics<C, S> dest, SufficientStatistics<C, S> src) {
        CounterMap<C, S> destcm = dest.getStateTransitionStats();
        CounterMap<C, S> srccm = src.getStateTransitionStats();
        for (C key1 : srccm.keySet()) {
            for (S key2 : srccm.getCounter(key1).keySet()) {
                double value = destcm.getCount(key1, key2) - srccm.getCount(key1, key2);
                if (MathUtils.close(0.0, value)) {
                    value = 0.0;
                }
                if (value < 0.0) {
                    throw new RuntimeException();
                }
                destcm.setCount(key1, key2, value);
            }
        }
        Counter<C> destc = dest.getBaseMeasureStats();
        Counter<C> srcc = src.getBaseMeasureStats();
        for (Object key : srcc.keySet()) {
            double value = destc.getCount(key) - srcc.getCount(key);
            if (MathUtils.close(0.0, value)) {
                value = 0.0;
            }
            if (value < 0.0) {
                throw new RuntimeException();
            }
            destc.setCount(key, value);
        }
        destc = dest.getWaitingTimeStats();
        srcc = src.getWaitingTimeStats();
        for (Object key : srcc.keySet()) {
            double value = destc.getCount(key) - srcc.getCount(key);
            if (MathUtils.close(0.0, value)) {
                value = 0.0;
            }
            if (value < 0.0) {
                throw new RuntimeException();
            }
            destc.setCount(key, value);
        }
    }

    public static void main(String[] args) {
        int i;
        int i2;
        Random rand = new Random(1L);
        SufficientStatisticsImpl ss2 = new SufficientStatisticsImpl();
        for (i2 = 0; i2 < 10; ++i2) {
            ss2.getBaseMeasureStats().incrementCount(rand.nextInt(), rand.nextDouble());
        }
        for (i2 = 0; i2 < 10; ++i2) {
            ss2.getWaitingTimeStats().incrementCount(rand.nextInt(), rand.nextDouble());
        }
        for (i2 = 0; i2 < 10; ++i2) {
            for (int i22 = 0; i22 < 10; ++i22) {
                ss2.getStateTransitionStats().incrementCount(i2, i22, rand.nextDouble());
            }
        }
        SufficientStatisticsImpl ss = new SufficientStatisticsImpl();
        for (i = 0; i < 10; ++i) {
            ss.getBaseMeasureStats().incrementCount(rand.nextInt(), rand.nextDouble());
        }
        for (i = 0; i < 10; ++i) {
            ss.getWaitingTimeStats().incrementCount(rand.nextInt(), rand.nextDouble());
        }
        for (i = 0; i < 10; ++i) {
            for (int i23 = 0; i23 < 10; ++i23) {
                ss.getStateTransitionStats().incrementCount(i, i23, rand.nextDouble());
            }
        }
        System.out.println(ss2);
        SufficientStatisticsImpl.plusEqual(ss2, ss);
        System.out.println(ss2);
        SufficientStatisticsImpl.minusEqualCheckNonNeg(ss2, ss);
        System.out.println(ss2);
    }
}

