/*
 * Decompiled with CFR 0.152.
 */
package gep.pmcmc;

import fig.basic.Pair;
import fig.prob.SampleUtils;
import gep.GEPMain;
import gep.comparisons.TargetModel;
import gep.model.Predictives;
import gep.model.SplitContext;
import gep.model.SufficientStatistics;
import gep.model.SufficientStatisticsImpl;
import gep.timeseries.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nuts.math.RateMtxUtils;
import nuts.util.CollUtils;
import nuts.util.EasyFormat;
import nuts.util.Indexer;
import pepper.Encodings;

public class Generator {
    public static double MAX_INTERVAL = 100.0;
    public static double reject = 0.0;
    public static double accept = 0.0;

    public static <S> SufficientStatistics<S, S> generate(SufficientStatistics<S, S> init, Predictives<S, S> pred, Random rand, List<Event<S>> eventsList, double delta, int maxN, S begSymbol) {
        SufficientStatisticsImpl<S, S> result = new SufficientStatisticsImpl<S, S>(init);
        double initRight = eventsList.isEmpty() ? 0.0 : eventsList.get((int)(eventsList.size() - 1))._right;
        double currentDelta = 0.0;
        int cur = 0;
        while (currentDelta <= delta && cur < maxN) {
            ++cur;
            SufficientStatisticsImpl<S, S> current = new SufficientStatisticsImpl<S, S>(result);
            Pair<Object, Double> newSample = null;
            S prev = eventsList.isEmpty() ? begSymbol : eventsList.get((int)(eventsList.size() - 1))._contents;
            newSample = eventsList.isEmpty() ? Pair.makePair(pred.sampleState(rand, prev, current), 0.0) : pred.sample(rand, prev, current);
            if (newSample.equals(SplitContext.BEG) || newSample.getSecond() > MAX_INTERVAL) {
                reject += 1.0;
                continue;
            }
            accept += 1.0;
            double curLeft = currentDelta + initRight;
            double curRight = curLeft + newSample.getSecond();
            currentDelta += newSample.getSecond().doubleValue();
            eventsList.add(new Event<S>(curLeft, curRight, newSample.getFirst()));
            result = current;
        }
        return result;
    }

    public static SufficientStatistics<SplitContext, SplitContext> generate(Predictives<SplitContext, SplitContext> pred, Random rand, List<Event<SplitContext>> eventsList, double delta, int maxN) {
        return Generator.generate(new SufficientStatisticsImpl(), pred, rand, eventsList, delta, maxN, SplitContext.BEG);
    }

    public static void main(String[] args) {
        Generator.test();
    }

    public static void test() {
        Indexer<Character> observedIndexer = Encodings.rnaEncodings().nonGapCharactersIndexer();
        Indexer hiddenIndexer = new Indexer();
        double bmAlpha0 = 100.0;
        double alphaL1 = 100.0;
        double alphaL2 = 100.0;
        double alphaL3 = 100.0;
        double beta0 = 100.0;
        double gamma0 = 100.0;
        Predictives<SplitContext, SplitContext> pred = Predictives.splitPredictives(new SufficientStatisticsImpl<SplitContext, SplitContext>(), bmAlpha0, alphaL1, alphaL2, alphaL3, 4, beta0, gamma0);
        ArrayList<Event<SplitContext>> eventsList = CollUtils.list();
        Random rand = new Random(1L);
        Generator.generate(pred, rand, eventsList, 100.0, 100);
    }

    public static String toString(List<Event<SplitContext>> seqn, Indexer<Double> hiddenIndexer, Indexer<String> observedIndexer) {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < seqn.size(); ++i) {
            Event<SplitContext> e1 = seqn.get(i - 1);
            Event<SplitContext> e2 = seqn.get(i);
            result.append(Event.contents(e1, e2).toString(hiddenIndexer, observedIndexer) + "@[" + EasyFormat.fmt2(Event.left(e1, e2)) + "," + EasyFormat.fmt2(Event.right(e1, e2)) + ")\n");
        }
        return result.toString();
    }

    public static Pair<List<Integer>, List<Integer>> generate(Random rand, TargetModel model, int maxL, double delta) {
        ArrayList obss = CollUtils.list();
        ArrayList hids = CollUtils.list();
        double[][] trans = RateMtxUtils.marginalTransitionMtx(model.transitionRates, delta);
        int hidden = SampleUtils.sampleMultinomial(rand, RateMtxUtils.getStationaryDistribution(model.transitionRates));
        for (int i = 0; i < maxL; ++i) {
            int obs = SampleUtils.sampleMultinomial(rand, model.emiPrs[hidden]);
            obss.add(obs);
            hids.add(hidden);
            hidden = SampleUtils.sampleMultinomial(rand, trans[hidden]);
        }
        return Pair.makePair(hids, obss);
    }

    public static <S> SufficientStatistics<S, S> generateHitting(SufficientStatistics<S, S> init, Predictives<S, S> pred, Random rand, double maxT, int maxN, S begSymbol) {
        Event e1;
        double curRight;
        double curLeft;
        ArrayList<Event<S>> eventsList = new ArrayList<Event<S>>(3);
        eventsList.clear();
        SufficientStatisticsImpl<S, S> result = new SufficientStatisticsImpl<S, S>(init);
        double initRight = 0.0;
        double currentDelta = 0.0;
        int cur = 0;
        int begSt = 0;
        Object sc = null;
        SufficientStatisticsImpl<S, S> current = new SufficientStatisticsImpl<S, S>(result);
        Pair<Object, Double> newSample = null;
        S prev = begSymbol;
        newSample = Pair.makePair(pred.sampleState(rand, prev, current), 0.0);
        if (newSample.equals(SplitContext.BEG) || newSample.getSecond() > MAX_INTERVAL) {
            reject += 1.0;
        } else {
            accept += 1.0;
            curLeft = currentDelta + 0.0;
            curRight = curLeft + newSample.getSecond();
            currentDelta += newSample.getSecond().doubleValue();
            eventsList.add(new Event<S>(curLeft, curRight, newSample.getFirst()));
            e1 = (Event)eventsList.get(eventsList.size() - 1);
            sc = Event.tempcontents(e1);
            begSt = ((SplitContext)sc).getX();
            result = current;
        }
        while (((SplitContext)sc).getX() != 3 && cur++ < maxN && currentDelta < maxT) {
            current = new SufficientStatisticsImpl<S, S>(result);
            newSample = null;
            prev = eventsList.isEmpty() ? begSymbol : ((Event)eventsList.get((int)(eventsList.size() - 1)))._contents;
            newSample = eventsList.isEmpty() ? Pair.makePair(pred.sampleState(rand, prev, current), 0.0) : pred.sample(rand, prev, current);
            if (newSample.equals(SplitContext.BEG) || newSample.getSecond() > MAX_INTERVAL) {
                reject += 1.0;
                continue;
            }
            accept += 1.0;
            curLeft = currentDelta + 0.0;
            curRight = curLeft + newSample.getSecond();
            currentDelta += newSample.getSecond().doubleValue();
            eventsList.add(new Event<S>(curLeft, curRight, newSample.getFirst()));
            e1 = (Event)eventsList.get(eventsList.size() - 1);
            sc = Event.tempcontents(e1);
            result = current;
        }
        GEPMain.outputManager.printWrite("hittingTime", "Time", currentDelta, "BegState", begSt, "FinalState", ((SplitContext)sc).getX());
        return result;
    }

    public static SufficientStatistics<SplitContext, SplitContext> generateHitting(Predictives<SplitContext, SplitContext> pred, Random rand, List<Event<SplitContext>> eventsList, double delta, int maxN) {
        return Generator.generateHitting(new SufficientStatisticsImpl(), pred, rand, delta, maxN, SplitContext.BEG);
    }
}

