/*
 * Decompiled with CFR 0.152.
 */
package goblin;

import goblin.BayesRiskMinimizer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nuts.io.IO;
import nuts.util.CollUtils;
import pepper.Corpus;

public class CreatePawleyBaseline {
    public static void main(String[] args) throws IOException {
        Corpus paw = Corpus.parse("/Users/bouchard/w/evolvere/data/austro/20100807/processed/temp/Pawley.cog");
        Corpus blu = Corpus.parse("/Users/bouchard/w/evolvere/data/austro/20100807/processed/All.cog");
        Map<String, String> pawMap = CreatePawleyBaseline.get(paw, "ProtoOceanicPawley");
        Map<String, String> bluMap = CreatePawleyBaseline.get(blu, "ProtoOceanicBlust");
        IO.so("----");
        for (String key : CollUtils.inter(pawMap.keySet(), bluMap.keySet())) {
            IO.so("ID " + key);
            IO.so("TRUTH " + bluMap.get(key));
            IO.so("PAW " + pawMap.get(key));
            IO.so("LOSS " + BayesRiskMinimizer.levenshteinLoss.loss(bluMap.get(key), pawMap.get(key)));
            IO.so("----");
        }
    }

    private static Map<String, String> get(Corpus blu, String langName) {
        HashMap<String, String> result = CollUtils.map();
        for (int i = 0; i < blu.getNWords(); ++i) {
            if (!blu.isKnown(i, langName)) continue;
            result.put(blu.getCognateId(i).toString(), blu.getWord(i, langName));
        }
        return result;
    }
}

