/*
 * Decompiled with CFR 0.152.
 */
package ma;

import fig.basic.Pair;
import fig.basic.UnorderedPair;
import goblin.DerivationTree;
import goblin.Taxon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import ma.MultiAlignment;
import nuts.lang.StringUtils;
import nuts.math.EqClasses;
import nuts.util.Arbre;
import nuts.util.Counter;

public class GreedyDecoder {
    private final Counter<Edge> edgeScores;
    private final Set<Edge> acceptedEdges = new HashSet<Edge>();
    private final Map<Pair<Taxon, Taxon>, SortedMap<Integer, Integer>> pairwiseAlignments = new HashMap<Pair<Taxon, Taxon>, SortedMap<Integer, Integer>>();
    private final EqClasses<Pair<Taxon, Integer>> eqClasses = new EqClasses();
    private final Map<Taxon, String> words;

    public static MultiAlignment decode(Counter<Edge> edgeScores, Map<Taxon, String> seqns) {
        return new GreedyDecoder(edgeScores, seqns).decode();
    }

    private GreedyDecoder(Counter<Edge> edgeScores, Map<Taxon, String> words) {
        this.edgeScores = edgeScores;
        this.words = words;
        this.processEdges();
    }

    @Deprecated
    public MultiAlignment decode() {
        return new MultiAlignment(this.acceptedEdges, this.words);
    }

    private void processEdges() {
        this.init();
        for (Edge edge : this.edgeScores) {
            if (this.acceptedEdges.contains(edge) || !this.isValid(edge)) continue;
            this.add(edge);
        }
    }

    private void init() {
        if (this.eqClasses.representatives().size() > 0) {
            throw new RuntimeException();
        }
        for (Taxon lang : this.words.keySet()) {
            for (int x = 0; x < this.words.get(lang).length(); ++x) {
                this.eqClasses.addNewElt(Pair.makePair(lang, x));
            }
        }
    }

    private boolean isValid(Edge edge) {
        Set<Pair<Taxon, Integer>> class1 = this.eqClasses.eqClass(Pair.makePair(edge.lang1(), edge.index1()));
        Set<Pair<Taxon, Integer>> class2 = this.eqClasses.eqClass(Pair.makePair(edge.lang2(), edge.index2()));
        for (Pair<Taxon, Integer> elt1 : class1) {
            for (Pair<Taxon, Integer> elt2 : class2) {
                if (elt1.getFirst().equals(elt2.getFirst())) {
                    return false;
                }
                if (!this.violatesMonotonicity(elt1.getSecond(), elt2.getSecond(), elt1.getFirst(), elt2.getFirst())) continue;
                return false;
            }
        }
        return true;
    }

    private void add(Edge edge) {
        this.acceptedEdges.add(edge);
        Pair<Taxon, Integer> pt1 = Pair.makePair(edge.lang1(), edge.index1());
        Pair<Taxon, Integer> pt2 = Pair.makePair(edge.lang2(), edge.index2());
        for (Pair<Taxon, Integer> elt1 : this.eqClasses.eqClass(pt1)) {
            for (Pair<Taxon, Integer> elt2 : this.eqClasses.eqClass(pt2)) {
                this.getAlignment(elt1.getFirst(), elt2.getFirst()).put(elt1.getSecond(), elt2.getSecond());
                this.getAlignment(elt2.getFirst(), elt1.getFirst()).put(elt2.getSecond(), elt1.getSecond());
            }
        }
        this.eqClasses.forceNewRelation(pt1, pt2);
    }

    private boolean violatesMonotonicity(int index1, int index2, Taxon lang1, Taxon lang2) {
        SortedMap<Integer, Integer> alignment = this.getAlignment(lang1, lang2);
        SortedMap<Integer, Integer> head = alignment.headMap(index1);
        SortedMap<Integer, Integer> tail = alignment.tailMap(index1);
        if (!head.isEmpty() && (Integer)alignment.get(head.lastKey()) >= index2) {
            return true;
        }
        return !tail.isEmpty() && (Integer)alignment.get(tail.firstKey()) <= index2;
    }

    private SortedMap<Integer, Integer> getAlignment(Taxon lang1, Taxon lang2) {
        Pair<Taxon, Taxon> key = Pair.makePair(lang1, lang2);
        SortedMap<Integer, Integer> result = this.pairwiseAlignments.get(key);
        if (result == null) {
            result = new TreeMap<Integer, Integer>();
            this.pairwiseAlignments.put(key, result);
        }
        return result;
    }

    public static void addToEdgeCounter(Arbre<DerivationTree.DerivationNode> a, Counter<Edge> counter) {
        GreedyDecoder.addToEdgeCounter(MultiAlignment.inducedMultiAlignment(a), counter);
    }

    public static void addToEdgeCounter(MultiAlignment ma, Counter<Edge> counter) {
        EqClasses<MultiAlignment.SequenceCoordinate> eqClasses = ma.eqClasses();
        for (MultiAlignment.SequenceCoordinate rep : eqClasses.representatives()) {
            ArrayList<MultiAlignment.SequenceCoordinate> eqClass = new ArrayList<MultiAlignment.SequenceCoordinate>(eqClasses.eqClass(rep));
            for (int i = 0; i < eqClass.size(); ++i) {
                for (int j = i + 1; j < eqClass.size(); ++j) {
                    MultiAlignment.SequenceCoordinate sc1 = (MultiAlignment.SequenceCoordinate)eqClass.get(i);
                    MultiAlignment.SequenceCoordinate sc2 = (MultiAlignment.SequenceCoordinate)eqClass.get(j);
                    counter.incrementCount(new Edge(sc1.indexInSequence(), sc2.indexInSequence(), sc1.getNodeIdentifier(), sc2.getNodeIdentifier()), 1.0);
                }
            }
        }
    }

    public static void main(String[] args) {
        int i;
        Random rand = new Random(1L);
        HashMap<Taxon, String> seqns = new HashMap<Taxon, String>();
        int len1 = 2;
        int len2 = 2;
        int len3 = 2;
        Taxon l1 = new Taxon("l1");
        Taxon l2 = new Taxon("l2");
        Taxon l3 = new Taxon("l3");
        String s = "";
        for (i = 0; i < len1; ++i) {
            s = s + "a";
        }
        seqns.put(l1, s);
        s = "";
        for (i = 0; i < len2; ++i) {
            s = s + "b";
        }
        seqns.put(l2, s);
        s = "";
        for (i = 0; i < len3; ++i) {
            s = s + "c";
        }
        seqns.put(l3, s);
        for (int it = 0; it < 10000; ++it) {
            int j;
            int i2;
            Counter<Edge> c = new Counter<Edge>();
            for (i2 = 0; i2 < len1; ++i2) {
                for (j = 0; j < len2; ++j) {
                    c.incrementCount(new Edge(i2, j, l1, l2), rand.nextDouble());
                }
            }
            for (i2 = 0; i2 < len1; ++i2) {
                for (j = 0; j < len3; ++j) {
                    c.incrementCount(new Edge(i2, j, l1, l3), rand.nextDouble());
                }
            }
            for (i2 = 0; i2 < len2; ++i2) {
                for (j = 0; j < len3; ++j) {
                    c.incrementCount(new Edge(i2, j, l2, l3), rand.nextDouble());
                }
            }
            try {
                System.out.println(GreedyDecoder.decode(c, seqns));
                continue;
            }
            catch (Exception e) {
                MultiAlignment ma = GreedyDecoder.decode(c, seqns);
                System.out.println(ma);
            }
        }
    }

    public static final class Edge
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final UnorderedPair<Pair<Integer, Taxon>, Pair<Integer, Taxon>> data;
        public static Pattern p = Pattern.compile("\\(\\(([^,]*), ([^)]*)\\), \\(([^,]*), ([^)]*)\\)\\)");

        public int index1() {
            return this.data.getFirst().getFirst();
        }

        public int index2() {
            return this.data.getSecond().getFirst();
        }

        public Taxon lang1() {
            return this.data.getFirst().getSecond();
        }

        public Taxon lang2() {
            return this.data.getSecond().getSecond();
        }

        public Edge(int index1, int index2, Taxon lang1, Taxon lang2) {
            this.data = new UnorderedPair<Pair<Integer, Taxon>, Pair<Integer, Taxon>>(Pair.makePair(index1, lang1), Pair.makePair(index2, lang2));
        }

        public String toString() {
            return this.data.toString();
        }

        public static Edge fromString(String str) {
            List<String> matches = StringUtils.multiSelectFirstRegex(p, str);
            int i1 = Integer.parseInt(matches.get(0));
            int i2 = Integer.parseInt(matches.get(2));
            Taxon l1 = new Taxon(matches.get(1));
            Taxon l2 = new Taxon(matches.get(3));
            return new Edge(i1, i2, l1, l2);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(Object obj) {
            return ((Edge)obj).data.equals(this.data);
        }
    }
}

