/*
 * Decompiled with CFR 0.152.
 */
package marking;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import fig.basic.StrUtils;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import marking.Grade;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.tui.Utils;
import nuts.util.CollUtils;

public class Comment
implements Runnable {
    @Option
    public String sidFile = "student-ids.txt";
    @Option(required=true)
    public String assignmentFolder;

    public static void main(String[] args) {
        IO.run(args, new Comment());
    }

    public static File getSCFile(File directory) {
        return new File(directory, "student-comments.csv");
    }

    public static File getCDFile(File directory) {
        return new File(directory, "comment-descriptions.csv");
    }

    public static void backup(File assignmentFolder) {
        File scFile = Comment.getSCFile(assignmentFolder);
        File cdFile = Comment.getCDFile(assignmentFolder);
        if (cdFile.exists()) {
            IO.cp(cdFile, new File(Execution.getFile("comment-descriptions.csv.bu")));
        }
        if (scFile.exists()) {
            IO.cp(scFile, new File(Execution.getFile("student-comments.csv.bu")));
        }
    }

    @Override
    public void run() {
        AllStudents as = new AllStudents(new File(this.sidFile));
        File directory = new File(this.assignmentFolder);
        File studentFiles = new File(directory, "student-files");
        if (!directory.exists()) {
            directory.mkdir();
            studentFiles.mkdir();
        }
        Comment.backup(directory);
        PrintWriter inputlogs = IOUtils.openOutHard(Execution.getFile("inputs.txt"));
        Grade.CommentDescriptions commentDescriptions = new Grade.CommentDescriptions(directory);
        Grade.StudentComments studentComments = new Grade.StudentComments(directory);
        String cur_sid = "";
        String cur_qid = "";
        as.searchAssignmentFiles(studentFiles);
        block2: while (true) {
            try {
                while (true) {
                    String cmd = Utils.prompt("  [s|q|c|n|x] ");
                    inputlogs.append(cmd + "\n");
                    inputlogs.flush();
                    if (cmd.charAt(0) == 'x') break block2;
                    if (cmd.length() != 0) {
                        if (cmd.charAt(0) == 's') {
                            if (cmd.length() == 1) {
                                cur_sid = as.popCurrent();
                            } else {
                                if (!as.isValidShortcut(cmd)) {
                                    LogInfo.logs("Student id not recognized. Potential choices are:" + as.map.keySet());
                                    continue;
                                }
                                cur_sid = as.getFullStudentID(cmd);
                                as.setCurrent(cur_sid);
                            }
                            as.open(cur_sid);
                            LogInfo.logs("Student id set to: " + cur_sid);
                            continue;
                        }
                        if (cmd.charAt(0) == 'q') {
                            if (!commentDescriptions.containsQuestionId(cmd)) {
                                LogInfo.logs("New question id: " + cmd + " (existing:" + commentDescriptions.allQuestionId() + ")");
                            } else {
                                LogInfo.logs("Question id set to existing qid: " + cmd);
                                LogInfo.track((Object)"Existing comments: ", true);
                                LogInfo.logs(commentDescriptions.toString(cmd));
                                LogInfo.end_track();
                            }
                            cur_qid = cmd;
                            continue;
                        }
                        if (cmd.charAt(0) == 'c' || cmd.charAt(0) == 'n') {
                            if (cur_qid.equals("") || cur_sid.equals("")) {
                                LogInfo.logs("Need to first set a question and student");
                                continue;
                            }
                            String note = Utils.prompt("  Optional notes (or z) ");
                            inputlogs.append(note + "\n");
                            inputlogs.flush();
                            if ("z".equals(note)) {
                                LogInfo.logs("Association cancelled");
                                continue;
                            }
                            boolean isNew = cmd.charAt(0) == 'n';
                            String cid = null;
                            if (isNew) {
                                String desc = StringUtils.selectFirstRegex("^n\\s*(.*)$", cmd);
                                cid = commentDescriptions.add(cur_qid, desc);
                            } else {
                                cid = cmd;
                                if (!commentDescriptions.checkAssociated(cur_qid, cid)) {
                                    LogInfo.logs("Comment " + cid + " is not associated with question " + cur_qid);
                                    continue;
                                }
                            }
                            boolean addResult = studentComments.add(cur_sid, cid, note);
                            if (!addResult) {
                                LogInfo.logs("Warning: command not processed because this association already existed.");
                                continue;
                            }
                            LogInfo.logs("" + cid + " added to " + cur_sid);
                            continue;
                        }
                    }
                    LogInfo.logs("Unknown command, should start by [s|x|q|c|n|x]");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LogInfo.warning("Error: " + e + "\nRetry...");
                continue;
            }
            break;
        }
        inputlogs.close();
        studentComments.close();
        commentDescriptions.close();
    }

    public static Pair<Integer, Map<String, String>> findShort(List<String> ids, int len) {
        HashMap result = CollUtils.map();
        for (String id : ids) {
            if ((id = id.replaceAll("\\s+", "")).equals("")) continue;
            if (!id.matches("[0-9]+")) {
                throw new RuntimeException();
            }
            if (id.length() < len) {
                throw new RuntimeException();
            }
            String shortCut = "s" + id.substring(0, len);
            if (result.containsKey(shortCut)) {
                return Comment.findShort(ids, len + 1);
            }
            result.put(shortCut, "s" + id);
        }
        return Pair.makePair(len, result);
    }

    public static class AllStudents {
        public Map<String, String> map;
        public Map<String, File> fullSID2File;
        public List<String> ids;
        private int current = 0;

        public void setCurrent(String sid) {
            this.current = this.ids.indexOf(sid);
            if (this.current == -1) {
                throw new RuntimeException();
            }
        }

        public String popCurrent() {
            int result = this.current++;
            if (this.current == this.ids.size()) {
                LogInfo.logs("Going back to first student!");
                this.current = 0;
            }
            return this.ids.get(result);
        }

        public void open(String sid) {
            File f = this.fullSID2File.get(sid);
            if (f != null) {
                IO.call("open " + f.getAbsolutePath());
            } else {
                LogInfo.logs("Assignment file not found.");
            }
        }

        private void searchAssignmentFiles(File studentFiles) {
            this.fullSID2File = CollUtils.map();
            HashSet fileNames = CollUtils.set();
            for (File f : IO.ls(studentFiles, "pdf")) {
                String name = IO.nameWithoutExtension(f);
                fileNames.add("s" + name);
                this.fullSID2File.put("s" + name, f);
            }
            HashSet fileNamesCopy = CollUtils.set(fileNames);
            fileNames.removeAll(CollUtils.set(this.ids));
            if (fileNames.size() > 0) {
                LogInfo.warning("Unrecognized student id files: " + StrUtils.join(fileNames, ", "));
            }
            fileNames = fileNamesCopy;
            HashSet<String> studentidset = CollUtils.set(this.ids);
            studentidset.removeAll(fileNamesCopy);
            if (studentidset.size() > 0) {
                LogInfo.warning("Students did not have corresponding file: " + StrUtils.join(studentidset, ", "));
            }
        }

        public boolean isValidShortcut(String shortCut) {
            return this.map.containsKey(shortCut);
        }

        public String getFullStudentID(String shortCut) {
            return this.map.get(shortCut);
        }

        public AllStudents(File sidFile) {
            List<String> ids = IO.f2l(sidFile);
            int shortLen = 1 + Comment.findShort(ids, 2).getFirst();
            this.map = Comment.findShort(ids, shortLen).getSecond();
            HashSet allSIDs = CollUtils.set();
            for (String value : this.map.values()) {
                if (allSIDs.contains(value)) {
                    throw new RuntimeException();
                }
                allSIDs.add(value);
            }
            this.ids = CollUtils.list(allSIDs);
            Collections.sort(this.ids);
        }
    }
}

