/*
 * Decompiled with CFR 0.152.
 */
package marking;

import briefj.BriefIO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.StrUtils;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import marking.FinalGrade;
import nuts.io.IO;
import nuts.math.PlotHistogram;
import nuts.math.StatisticsMap;
import nuts.util.Counter;

public class FinalGradesStat302Version2
implements Runnable {
    public static void main(String[] args) {
        IO.run(args, new FinalGradesStat302Version2());
    }

    @Override
    public void run() {
        Object[] files;
        File skipped = new File("skipped.txt");
        File finalGradesTemplateFile = new File("final-grades-template.csv");
        File weightsFile = new File("weights.csv");
        for (File file : files = new File[]{skipped, finalGradesTemplateFile, weightsFile}) {
            if (file.exists()) continue;
            throw new RuntimeException("The following files need to be in the marking directory: " + Arrays.toString(files));
        }
        LinkedHashSet skippedIds = Sets.newLinkedHashSet();
        for (String line : BriefIO.readLines((File)skipped)) {
            if (line.isEmpty()) continue;
            if (line.contains(" ")) {
                throw new RuntimeException();
            }
            skippedIds.add(line);
        }
        LogInfo.logsForce("skipped = " + skippedIds);
        ArrayList activitySpecs = Lists.newArrayList();
        for (Map<String, String> map : IO.iCSVMap(weightsFile)) {
            LogInfo.logs(map);
            activitySpecs.add(map);
        }
        HashMap failures = Maps.newHashMap();
        HashMap hashMap = Maps.newHashMap();
        Counter<String> letterGradeHist = new Counter<String>();
        int nFails = 0;
        PlotHistogram hist = new PlotHistogram();
        StatisticsMap.DescriptiveStatisticsMap<String> statistics = new StatisticsMap.DescriptiveStatisticsMap<String>();
        LinkedHashMap allScores = Maps.newLinkedHashMap();
        for (String[] activitySpec : activitySpecs) {
            LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
            String sidField = (String)activitySpec.get("studentCol");
            String scoreField = (String)activitySpec.get("scoreCol");
            String activityName = (String)activitySpec.get("activity");
            if (allScores.containsKey(activityName)) {
                throw new RuntimeException();
            }
            allScores.put(activityName, linkedHashMap);
            for (Map entry : BriefIO.readLines((String)((String)activitySpec.get("file"))).indexCSV()) {
                String sid = (String)entry.get(sidField);
                String score = (String)entry.get(scoreField);
                if (linkedHashMap.containsKey(sid)) {
                    throw new RuntimeException();
                }
                linkedHashMap.put(sid, score);
            }
        }
        ArrayList ids = Lists.newArrayList();
        for (Map map : IO.iCSVMap(finalGradesTemplateFile)) {
            String id = (String)map.get("Student Number");
            if (id.contains(" ")) {
                throw new RuntimeException();
            }
            if (skippedIds.contains(id) || id == null) continue;
            LogInfo.track("Compiling grade for " + id);
            ids.add(id);
            double studentSum = 0.0;
            double weightToAddToFinal = 0.0;
            for (Map activitySpec : activitySpecs) {
                String activity = (String)activitySpec.get("activity");
                String currentLog = activity + " : ";
                String fieldStr = (String)((Map)allScores.get(activity)).get(id);
                double weight = Double.parseDouble((String)activitySpec.get("weight"));
                if ("DOCTORNOTE".equals(fieldStr)) {
                    weightToAddToFinal += weight;
                    weight = 0.0;
                    LogInfo.logsForce("Doctor note was produced: adding weight to final.");
                    fieldStr = "0";
                }
                if (activity.equals("final")) {
                    weight += weightToAddToFinal;
                    weightToAddToFinal = 0.0;
                }
                double fieldValue = fieldStr == null || "".equals(fieldStr) || "#N/A".equals(fieldStr) ? 0.0 : Double.parseDouble(fieldStr);
                currentLog = currentLog + fieldStr + " -parse-> " + fieldValue;
                double max = Double.parseDouble((String)activitySpec.get("maxScore"));
                fieldValue = Math.min(max, fieldValue);
                currentLog = currentLog + " -cap-> " + fieldValue + "/" + max;
                currentLog = currentLog + " -norm-> " + (fieldValue /= max);
                double curveExponent = Double.parseDouble((String)activitySpec.get("curveExponent"));
                if (curveExponent > 1.0) {
                    throw new RuntimeException();
                }
                if (curveExponent != 1.0) {
                    fieldValue = this.curve(fieldValue, curveExponent);
                    currentLog = currentLog + " -curve-> " + fieldValue;
                }
                statistics.addValue(activity, fieldValue);
                studentSum += weight * fieldValue;
                LogInfo.logsForce(currentLog);
            }
            if (weightToAddToFinal != 0.0) {
                throw new RuntimeException("Make sure to list final last in the weights.csv file");
            }
            double studentGrade = studentSum;
            if (studentGrade <= 0.5 && studentGrade >= 0.485) {
                studentGrade = 0.5;
                LogInfo.logsForce("Rounding up 48.5 to 50");
            }
            letterGradeHist.incrementCount(FinalGrade.letterGrade(studentGrade), 1.0);
            hashMap.put(id, studentGrade);
            LogInfo.logsForce("student-total = " + studentGrade);
            statistics.addValue("TOTAL", studentGrade);
            hist.addPoint(studentGrade);
            if (studentGrade < 0.5) {
                ++nFails;
                failures.put(id, "" + studentGrade);
            }
            LogInfo.end_track();
        }
        LogInfo.logsForce("nStudents = " + ids.size());
        LogInfo.logsForce("nSkipped = " + skippedIds.size());
        LogInfo.logsForce(statistics.printAll() + "\n");
        LogInfo.logsForce("nFails = " + nFails + " " + failures);
        hist.savePlot(new File(Execution.getFile("hist.pdf")));
        LogInfo.track("Grade hist (unnorm)");
        for (String key : FinalGrade.allLetterGrades) {
            LogInfo.logsForce(key + "\t" + letterGradeHist.getCount(key));
        }
        LogInfo.end_track();
        letterGradeHist.normalize();
        LogInfo.track("Grade hist");
        for (String key : FinalGrade.allLetterGrades) {
            LogInfo.logsForce(key + "\t" + letterGradeHist.getCount(key));
        }
        LogInfo.end_track();
        PrintWriter out = IOUtils.openOutEasy(Execution.getFile("stat302-to-upload.csv"));
        boolean bl = true;
        for (List<String> line : IO.iCSV(finalGradesTemplateFile)) {
            boolean bl2;
            line = new ArrayList<String>(line);
            if (!bl2) {
                String id = line.get(3);
                if (id == null || "".equals(id)) continue;
                line.add(15, "" + (skippedIds.contains(id) ? "" : "" + Math.round((Double)hashMap.get(id) * 100.0)).replaceFirst("[.]0", ""));
            }
            out.println(StrUtils.join(line, ","));
            bl2 = false;
        }
        out.close();
    }

    private double curve(double fieldValue, double curveExponent) {
        if (fieldValue == 0.0) {
            return 0.0;
        }
        double result = Math.pow(fieldValue, curveExponent);
        return result;
    }
}

