/*
 * Decompiled with CFR 0.152.
 */
package marking;

import fig.basic.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import javaxtools.compiler.CharSequenceCompiler;
import javaxtools.compiler.CharSequenceCompilerException;
import marking.Grader;
import nuts.io.IO;
import nuts.util.CollUtils;

public class GraderCreator {
    private static final File template = new File("/Users/bouchard/code/legacy-code/src-scratch/marking/GraderExample.java");
    private int classNameSuffix = 0;
    private Random random = new Random();
    private CharSequenceCompiler<Grader> compiler = new CharSequenceCompiler(this.getClass().getClassLoader(), Arrays.asList(new String[0]));

    private String digits() {
        return '_' + Long.toHexString(this.random.nextLong());
    }

    public Grader createGrader(File formulas, Set<String> commentIds) {
        DiagnosticCollector<JavaFileObject> errs = new DiagnosticCollector<JavaFileObject>();
        try {
            List<Pair<String, String>> formulae = this.parseFormulae(IO.f2l(formulas));
            String packageName = "javaxtools.compiler.examples.plotter.runtime" + this.digits();
            String className = "Fx_" + this.classNameSuffix++ + this.digits();
            String qName = packageName + '.' + className;
            String source = this.fillTemplate(packageName, className, formulae, commentIds);
            Class<Grader> compiledFunction = this.compiler.compile(qName, source, errs, Grader.class);
            return compiledFunction.newInstance();
        }
        catch (CharSequenceCompilerException e) {
            System.out.println(errs.getDiagnostics().get(0).getMessage(new Locale("en")));
            System.err.println(e.getDiagnostics());
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Pair<String, String>> parseFormulae(List<String> f2l) {
        ArrayList<Pair<String, String>> result = CollUtils.list();
        for (String line : f2l) {
            if (line.matches("^\\s*$")) continue;
            String[] fields = line.split("[=]");
            if (fields.length != 2) {
                throw new RuntimeException();
            }
            result.add(Pair.makePair(fields[0], fields[1]));
        }
        return result;
    }

    private String fillTemplate(String packageName, String className, List<Pair<String, String>> formulae, Set<String> commentIds) {
        StringBuilder result = new StringBuilder();
        for (String line : IO.i(template)) {
            if (!line.contains("$template")) {
                result.append(line + "\n");
                continue;
            }
            if (line.contains("$template:package")) {
                result.append("package " + packageName + ";\n");
                continue;
            }
            if (line.contains("$template:class")) {
                result.append("public class " + className + " implements Grader\n");
                continue;
            }
            if (line.contains("$template:R1")) {
                result.append((CharSequence)this.generateDeclarations(commentIds));
                continue;
            }
            if (!line.contains("$template:R2")) continue;
            result.append((CharSequence)this.generateFormulae(formulae));
        }
        return result.toString();
    }

    private StringBuilder generateFormulae(List<Pair<String, String>> formulae) {
        StringBuilder result = new StringBuilder();
        for (Pair<String, String> formula : formulae) {
            result.append("double " + formula.getFirst() + " = " + formula.getSecond() + "\n");
            result.append("result.add(new EvaluatedQuestion(\"" + formula.getFirst() + "\", \"" + formula.getSecond() + "\", " + formula.getFirst() + "));\n");
        }
        return result;
    }

    private StringBuilder generateDeclarations(Set<String> commentIds) {
        StringBuilder result = new StringBuilder();
        for (String commentId : commentIds) {
            result.append("double " + commentId + " = indicators.getCount(\"" + commentId + "\");\n");
        }
        return result;
    }
}

