/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.IOUtils;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.math.Plot2D;
import nuts.maxent.Function;

public class Plot3D {
    private double[] x;
    private double[] y;
    private double[][] z;
    private Function f;
    public Plot3DOptions options = new Plot3DOptions();

    private Plot3D(double[] x, double[] y, double[][] z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Plot3D(Function f) {
        this.f = f;
    }

    public void savePlot(File outputPDFFile) {
        this.create();
        File tempDir = IO.getTempDir("r-temp");
        File rScriptFile = new File(tempDir, "script.r");
        PrintWriter rscript = IOUtils.openOutEasy(rScriptFile);
        rscript.println("pdf('" + Plot2D.escapeQuote(outputPDFFile.getAbsolutePath()) + "')");
        File file_x = new File(tempDir, "data_x.csv");
        this.writeToFile(file_x, this.x);
        rscript.println("data_x <- scan('" + Plot2D.escapeQuote(file_x.getName()) + "')");
        File file_y = new File(tempDir, "data_y.csv");
        this.writeToFile(file_y, this.y);
        rscript.println("data_y <- scan('" + Plot2D.escapeQuote(file_y.getName()) + "')");
        File file_z = new File(tempDir, "data_z.csv");
        this.writeToFile(file_z, this.z);
        rscript.println("data_z <- scan('" + Plot2D.escapeQuote(file_z.getName()) + "')");
        rscript.println("z <- matrix(data_z, " + this.x.length + "," + this.y.length + ")");
        rscript.println("contour(data_x,data_y,z)");
        rscript.println("filled.contour(data_x,data_y,z,color.palette=heat.colors)");
        rscript.println("dev.off()");
        rscript.close();
        File rOut = new File(tempDir, "rOut");
        IO.call("" + Plot2D.rPath + " CMD BATCH " + rScriptFile.getName() + " " + rOut.getName(), null, tempDir);
    }

    private void create() {
        int i;
        if (this.f == null) {
            return;
        }
        double int_x = this.options.max_x - this.options.min_x;
        double int_y = this.options.max_y - this.options.min_y;
        this.x = new double[this.options.res_x];
        this.y = new double[this.options.res_y];
        for (i = 0; i < this.options.res_x; ++i) {
            this.x[i] = this.options.min_x + (double)i / (double)this.options.res_x * int_x;
        }
        for (i = 0; i < this.options.res_y; ++i) {
            this.y[i] = this.options.min_y + (double)i / (double)this.options.res_y * int_y;
        }
        this.z = new double[this.options.res_x][this.options.res_y];
        for (i = 0; i < this.options.res_x; ++i) {
            for (int j = 0; j < this.options.res_y; ++j) {
                double[] cur = new double[]{this.x[j], this.y[i]};
                this.z[i][j] = this.f.valueAt(cur);
            }
        }
    }

    private void writeToFile(File f, double[][] z2) {
        PrintWriter out = IOUtils.openOutEasy(f);
        for (int r = 0; r < z2.length; ++r) {
            for (int c = 0; c < z2[0].length; ++c) {
                out.println(CSV.body(z2[r][c]));
            }
        }
        out.close();
    }

    private void writeToFile(File f, double[] data) {
        PrintWriter out = IOUtils.openOutEasy(f);
        for (double datum : data) {
            out.println(CSV.body(datum));
        }
        out.close();
    }

    public static void main(String[] args) {
        IO.run(args, new Tester());
    }

    public double getMin_x() {
        return this.options.min_x;
    }

    public void setMin_x(double minX) {
        this.options.min_x = minX;
    }

    public double getMax_x() {
        return this.options.max_x;
    }

    public void setMax_x(double maxX) {
        this.options.max_x = maxX;
    }

    public double getMin_y() {
        return this.options.min_y;
    }

    public void setMin_y(double minY) {
        this.options.min_y = minY;
    }

    public double getMax_y() {
        return this.options.max_y;
    }

    public void setMax_y(double maxY) {
        this.options.max_y = maxY;
    }

    public int getRes_x() {
        return this.options.res_x;
    }

    public void setRes_x(int resX) {
        this.options.res_x = resX;
    }

    public int getRes_y() {
        return this.options.res_y;
    }

    public void setRes_y(int resY) {
        this.options.res_y = resY;
    }

    public static class Tester
    implements Runnable {
        @Override
        public void run() {
            Function f = new Function(){

                @Override
                public double valueAt(double[] x) {
                    return 100.0 * (x[0] > x[1] ? 1.0 : 0.0);
                }

                @Override
                public int dimension() {
                    throw new RuntimeException();
                }
            };
            Plot3D plot = new Plot3D(f);
            plot.setMax_x(2.0);
            plot.setMin_y(-1.2);
            File out = new File(Execution.getFile("out.pdf"));
            plot.savePlot(out);
        }
    }

    public static class Plot3DOptions {
        @Option
        public double min_x = 0.0;
        @Option
        public double max_x = 1.0;
        @Option
        public double min_y = 0.0;
        @Option
        public double max_y = 1.0;
        @Option
        public int res_x = 100;
        @Option
        public int res_y = 100;

        public Plot3DOptions(double min_x, double max_x, double min_y, double max_y, int res_x, int res_y) {
            this.min_x = min_x;
            this.max_x = max_x;
            this.min_y = min_y;
            this.max_y = max_y;
            this.res_x = res_x;
            this.res_y = res_y;
        }

        public Plot3DOptions() {
        }
    }
}

