/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.NumUtils;
import fig.basic.Option;
import fig.basic.Pair;
import fig.prob.SampleUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import nuts.lang.StringUtils;
import nuts.math.MeanVar;
import nuts.math.MeasureZeroException;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.CounterUtils;
import nuts.util.MathUtils;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class Sampling {
    @Option
    public static int timeToWaitForOthers = 30000;
    @Option
    public static int syncInterval = 180000;
    @Option
    public static boolean printLog = false;
    @Option
    public static boolean garbageCollectSyncFiles = true;
    public static String startedSignal = "STRTDSGNLFILE";

    public static boolean sampleBern(double prToBeTrue, Random rand) {
        return rand.nextDouble() < prToBeTrue;
    }

    public static <S> S sampleCounter(Counter<S> items, Random rand) {
        MathUtils.checkClose(1.0, items.totalCount());
        double[] prs = new double[items.size()];
        ArrayList<S> keys = new ArrayList<S>(items.size());
        int i = 0;
        for (S key : items.keySet()) {
            prs[i] = items.getCount(key);
            keys.add(key);
            ++i;
        }
        int index = SampleUtils.sampleMultinomial(rand, prs);
        return (S)keys.get(index);
    }

    public static double min1exp(double logRatio) {
        if (logRatio >= 0.0) {
            return 1.0;
        }
        return Math.exp(logRatio);
    }

    public static <T> T randomElt(Collection<T> collection, Random rand) {
        if (collection.isEmpty()) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(rand.nextInt(list.size()));
        }
        int sampledIndex = rand.nextInt(collection.size());
        Iterator<T> iter = collection.iterator();
        for (int i = 0; i < sampledIndex; ++i) {
            iter.next();
        }
        return iter.next();
    }

    public static long[] createSeeds(int n, Random metaSeed) {
        long[] result = new long[n];
        for (int i = 0; i < n; ++i) {
            result[i] = metaSeed.nextLong();
        }
        return result;
    }

    public static <T> T metropolisHastingsStep(Random rand, Proposal<T> q) {
        return Sampling.metropolisHastingsStep(rand, q, null);
    }

    public static <T> T metropolisHastingsStep(Random rand, Proposal<T> q, SummaryStatistics acceptStats) {
        T proposed = q.proposed();
        double cRatio = q.mhRatio();
        if (cRatio < 0.0 || cRatio > 1.0) {
            throw new RuntimeException("Malformed ratio:" + cRatio);
        }
        if (rand.nextDouble() < cRatio) {
            if (acceptStats != null) {
                acceptStats.addValue(1.0);
            }
            return proposed;
        }
        if (acceptStats != null) {
            acceptStats.addValue(0.0);
        }
        return q.initial();
    }

    public static Counter<Integer> efficientMultinomialSampling(Random rand, double[] w, int nSamples) {
        ArrayList<Double> darts = new ArrayList<Double>(nSamples);
        for (int n = 0; n < nSamples; ++n) {
            darts.add(rand.nextDouble());
        }
        Collections.sort(darts);
        Counter<Integer> result = new Counter<Integer>();
        double sum = 0.0;
        int nxtDartIdx = 0;
        for (int i = 0; i < w.length; ++i) {
            double curLen = w[i];
            if (curLen < 0.0 - MathUtils.threshold) {
                throw new RuntimeException();
            }
            double right = sum + curLen;
            for (int dartIdx = nxtDartIdx; dartIdx < darts.size() && (Double)darts.get(dartIdx) < right; ++dartIdx) {
                result.incrementCount(i, 1.0);
                ++nxtDartIdx;
            }
            sum = right;
        }
        if (Double.isNaN(sum)) {
            throw new MeasureZeroException();
        }
        MathUtils.checkClose(1.0, sum);
        if (result.totalCount() != (double)nSamples) {
            throw new RuntimeException();
        }
        return result;
    }

    public static Counter<Integer> efficientMultinomialSampling(Random rand, List<Double> w, int nSamples) {
        ArrayList<Double> darts = new ArrayList<Double>(nSamples);
        for (int n = 0; n < nSamples; ++n) {
            darts.add(rand.nextDouble());
        }
        Collections.sort(darts);
        Counter<Integer> result = new Counter<Integer>();
        double sum = 0.0;
        int nxtDartIdx = 0;
        for (int i = 0; i < w.size(); ++i) {
            double curLen = w.get(i);
            if (curLen < 0.0 - MathUtils.threshold) {
                throw new RuntimeException();
            }
            double right = sum + curLen;
            for (int dartIdx = nxtDartIdx; dartIdx < darts.size() && (Double)darts.get(dartIdx) < right; ++dartIdx) {
                result.incrementCount(i, 1.0);
                ++nxtDartIdx;
            }
            sum = right;
        }
        if (Double.isNaN(sum)) {
            throw new MeasureZeroException();
        }
        MathUtils.checkClose(1.0, sum);
        if (result.totalCount() != (double)nSamples) {
            throw new RuntimeException();
        }
        return result;
    }

    public static Counter<Integer> _inefficientMultinomialSampling(Random rand, double[] w, int nSamples) {
        Counter<Integer> result = new Counter<Integer>();
        for (int i = 0; i < nSamples; ++i) {
            result.incrementCount(SampleUtils.sampleMultinomial(rand, w), 1.0);
        }
        return result;
    }

    public static double expectedNumberDistinctParticles(double[] ws, double M) {
        double s = 0.0;
        double norm = 0.0;
        double N = ws.length;
        int i = 0;
        while ((double)i < N) {
            double w = ws[i];
            norm += w;
            double cur = Math.pow(1.0 - w, M);
            s += cur;
            ++i;
        }
        MathUtils.checkClose(1.0, norm);
        return N - s;
    }

    public static List<Integer> sampleWithoutReplacement(Random rand, int s, int n) {
        int i;
        if (n > s || s < 0 || n < 0) {
            throw new RuntimeException();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(s);
        ArrayList<Integer> result = new ArrayList<Integer>(n);
        for (i = 0; i < s; ++i) {
            list.add(i);
        }
        Collections.shuffle(list, rand);
        for (i = 0; i < n; ++i) {
            result.add((Integer)list.get(i));
        }
        return result;
    }

    public static <T> Set<T> sampleSubset(Random rand, Set<T> s, int n) {
        ArrayList<T> elts = new ArrayList<T>(s);
        List<Integer> indices = Sampling.sampleWithoutReplacement(rand, s.size(), n);
        HashSet result = new HashSet();
        for (int index : indices) {
            result.add(elts.get(index));
        }
        return result;
    }

    public static double mhRatio(double forwardPathLogPr, double reversedPathLogPr, double newStateLogPr, double oldStateLogPr) {
        double logRatio = newStateLogPr + reversedPathLogPr - oldStateLogPr - forwardPathLogPr;
        return Math.min(1.0, Math.exp(logRatio));
    }

    public static void scaleExp(List<Double> prs) {
        int i;
        double max = Double.NEGATIVE_INFINITY;
        for (i = 0; i < prs.size(); ++i) {
            max = Math.max(max, prs.get(i));
        }
        for (i = 0; i < prs.size(); ++i) {
            if (prs.get(i) == Double.NEGATIVE_INFINITY) {
                prs.set(i, 0.0);
                continue;
            }
            prs.set(i, Math.exp(prs.get(i) - max));
        }
    }

    public static int nextInt(Random rand, int left, int right) {
        return left + rand.nextInt(right - left);
    }

    public static double nextDouble(Random rand, double left, double right) {
        return left + (right - left) * rand.nextDouble();
    }

    public static int sample(Random random, List<Double> probs) {
        double norm = 0.0;
        for (double prob : probs) {
            if (prob < 0.0) {
                throw new RuntimeException("Bad probs: " + probs.toString());
            }
            norm += prob;
        }
        if (norm == 0.0) {
            throw new RuntimeException();
        }
        double v = random.nextDouble();
        double sum = 0.0;
        for (int i = 0; i < probs.size(); ++i) {
            if (!(v < (sum += probs.get(i) / norm))) continue;
            return i;
        }
        throw new RuntimeException("Bad probs: " + probs);
    }

    public static double geometricLogPr(int n, double rate) {
        if (rate <= 0.0 || rate > 1.0) {
            throw new RuntimeException();
        }
        if (n < 0) {
            throw new RuntimeException();
        }
        return Math.log(1.0 - rate) * (double)n + Math.log(rate);
    }

    public static int sampleGeometric(Random rand, double rate) {
        double partialSum;
        if (rate <= 0.0 || rate > 1.0) {
            throw new RuntimeException();
        }
        double draw = rand.nextDouble();
        double current = partialSum = rate;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (draw < partialSum) {
                return i;
            }
            partialSum += current * (1.0 - rate);
            current *= 1.0 - rate;
        }
        throw new RuntimeException();
    }

    public static double meanOfGeometric(double rate) {
        return (1.0 - rate) / rate;
    }

    public static double varOfGeometric(double rate) {
        return (1.0 - rate) / rate / rate;
    }

    public static double sampleExponential(Random rand, double param) {
        return SampleUtils.sampleGamma(rand, 1.0, 1.0 / param);
    }

    public static double exponentialDensity(double param, double x) {
        double lambda = 1.0 / param;
        return lambda * Math.exp(-lambda * x);
    }

    public static double exponentialLogCDF(double param, double x) {
        double lambda = 1.0 / param;
        return Math.log(1.0 - Math.exp(-lambda * x));
    }

    public static double exponentialLogDensity(double param, double x) {
        double lambda = 1.0 / param;
        return Math.log(lambda) + -lambda * x;
    }

    public static void main(String[] args) {
        Random rand = new Random(1L);
        Sampling.testMulti(rand);
        Sampling.test(10.0);
        Counter<Set> c = new Counter<Set>();
        for (int i = 0; i < 1000; ++i) {
            c.incrementCount(new HashSet<Integer>(Sampling.sampleWithoutReplacement(rand, 3, 2)), 1.0);
        }
        for (Set s : c) {
            System.out.println(s + ":" + c.getCount(s));
        }
    }

    private static void testMulti(Random rand) {
        MathUtils.threshold = 0.01;
        double[] w = new double[10];
        for (int i = 0; i < w.length; ++i) {
            w[i] = rand.nextDouble();
        }
        NumUtils.normalize(w);
        Counter<Integer> result = Sampling.efficientMultinomialSampling(rand, w, 10000000);
        result.normalize();
        for (int i = 0; i < w.length; ++i) {
            MathUtils.checkClose(w[i], result.getCount(i));
            System.out.println(w[i]);
            System.out.println(result.getCount(i));
        }
    }

    public static void test(double rate) {
        MeanVar mv = new MeanVar();
        double nIters = 1000.0;
        Random rand = new Random(20L);
        int i = 0;
        while ((double)i < 1000.0) {
            double current = Sampling.sampleExponential(rand, rate);
            mv.addPoint(current);
            ++i;
        }
        System.out.println("Simulated:" + mv.toString());
    }

    public static <T extends Serializable> AsyncDistributedComputation<T> createDistributedSuffStatCoordinator(String sharedDirectoryPath, List<Serializable> allIds, VariableChangeListener<T> listener) {
        if (sharedDirectoryPath == null || sharedDirectoryPath.equals("")) {
            return new AsyncDistributedComputation<T>(null, 0, new HashSet<Serializable>(allIds), syncInterval, 1, listener);
        }
        File sharedDirectory = new File(sharedDirectoryPath);
        if (!sharedDirectory.exists()) {
            sharedDirectory.mkdirs();
        }
        if (Sampling.isPartyStarted(sharedDirectory)) {
            throw new RuntimeException("Some execution is or was already started in this sync directory");
        }
        long myCreationTime = System.currentTimeMillis();
        Sampling.signal(sharedDirectory, "" + myCreationTime);
        if (printLog) {
            LogInfo.logs("Waiting for worker friends to come up");
        }
        try {
            Thread.sleep(timeToWaitForOthers);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        Sampling.signal(sharedDirectory, startedSignal + myCreationTime);
        int nWorkers = Sampling.nWorkers(sharedDirectory);
        if (printLog) {
            LogInfo.logs("Total number of workers: " + nWorkers);
        }
        int myWorkerNumber = Sampling.myWorkerNumber(sharedDirectory, myCreationTime);
        if (printLog) {
            LogInfo.logs("My worker number: " + myWorkerNumber);
        }
        List<List<Serializable>> partitions = Sampling.partition(allIds, nWorkers);
        HashSet<Serializable> myVariables = new HashSet<Serializable>((Collection)partitions.get(myWorkerNumber));
        if (printLog) {
            LogInfo.logs("You got " + myVariables.size() + " of the " + allIds.size() + " random variables");
        }
        return new AsyncDistributedComputation<T>(sharedDirectory, myWorkerNumber, myVariables, syncInterval, nWorkers, listener);
    }

    private static <T> List<List<T>> partition(List<T> list, int nParts) {
        int partitionSize = (int)((double)list.size() / (double)nParts);
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int currentIndex = 0;
        for (int i = 0; i < nParts; ++i) {
            int nextIndex = i == nParts - 1 ? list.size() : currentIndex + partitionSize;
            result.add(list.subList(currentIndex, nextIndex));
            currentIndex = nextIndex;
        }
        return result;
    }

    private static int myWorkerNumber(File sharedDirectory, long myCreationTime) {
        ArrayList<Long> numbers = new ArrayList<Long>();
        for (String fileName : sharedDirectory.list()) {
            if (!fileName.matches("^[0-9]+$")) continue;
            numbers.add(Long.parseLong(fileName));
        }
        Collections.sort(numbers);
        if (Sampling.multiplicity(numbers, new Long(myCreationTime)) != 1) {
            throw new RuntimeException();
        }
        return numbers.indexOf(myCreationTime);
    }

    public static <T> int multiplicity(Collection<T> collection, T item) {
        int result = 0;
        for (T current : collection) {
            if (!item.equals(current)) continue;
            ++result;
        }
        return result;
    }

    private static int nWorkers(File sharedDirectory) {
        int result = 0;
        for (String fileName : sharedDirectory.list()) {
            if (!fileName.matches("^[0-9]+$")) continue;
            ++result;
        }
        return result;
    }

    public static boolean isPartyStarted(File sharedDirectory) {
        String[] files;
        for (String file : files = sharedDirectory.list()) {
            if (!file.contains(startedSignal)) continue;
            return true;
        }
        return false;
    }

    public static void signal(File sharedDirectory, String signalContents) {
        File signalFile = new File(sharedDirectory, signalContents);
        try {
            if (!signalFile.createNewFile()) {
                throw new RuntimeException("Shared directory not writeable");
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public static List<Integer> randomPermutation(int n, Random rand) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            result.add(i);
        }
        Collections.shuffle(result, rand);
        return result;
    }

    private static Counter<Integer> addEqual(Counter<Integer> counter, double[] state) {
        for (int i = 0; i < state.length; ++i) {
            counter.incrementCount(i, state[i]);
        }
        return counter;
    }

    public static LinearSuffStat copy(LinearSuffStat original) {
        LinearSuffStat result = original.newInstance();
        result.add(original);
        return result;
    }

    public static class CounterAverager<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Counter<T> counter = new Counter();
        private double N = 0.0;

        public void add(Counter<T> increment) {
            for (T key : increment.keySet()) {
                this.counter.incrementCount(key, increment.getCount(key));
            }
            this.N += 1.0;
        }

        public int getN() {
            return (int)this.N;
        }

        public Counter<T> getAverage() {
            if (this.N == 0.0) {
                throw new RuntimeException();
            }
            Counter<T> result = new Counter<T>(this.counter);
            CounterUtils.scaleEquals(result, 1.0 / this.N);
            return result;
        }
    }

    public static interface LinearSuffStat
    extends Serializable {
        public void add(LinearSuffStat var1);

        public void scale(double var1);

        public LinearSuffStat newInstance();
    }

    public static class CounterSuffStat
    implements LinearSuffStat {
        private static final long serialVersionUID = 1L;
        private final Counter counter;

        public CounterSuffStat() {
            this.counter = new Counter();
        }

        public CounterSuffStat(Counter counter) {
            this.counter = counter;
        }

        @Override
        public void add(LinearSuffStat other) {
            if (!(other instanceof CounterSuffStat)) {
                throw new RuntimeException();
            }
            this.counter.incrementAll(((CounterSuffStat)other).counter);
        }

        @Override
        public LinearSuffStat newInstance() {
            return new CounterSuffStat();
        }

        @Override
        public void scale(double scaling) {
            CounterUtils.scaleEquals(this.counter, scaling);
        }

        public String toString() {
            return this.counter.toString();
        }
    }

    public static class SparseUpdateMCAverager
    implements VariableChangeListener<LinearSuffStat> {
        private int currentTime = 0;
        private final Map<Serializable, DelayedStat> delayedStats = new HashMap<Serializable, DelayedStat>();
        private final LinearSuffStat partialSums;

        public SparseUpdateMCAverager(LinearSuffStat initial) {
            this.partialSums = initial;
        }

        @Override
        public void update(Serializable variableId, LinearSuffStat suffStat) {
            suffStat = Sampling.copy(suffStat);
            this.flush(variableId);
            this.delay(variableId, suffStat);
            ++this.currentTime;
        }

        public LinearSuffStat getAverage() {
            if (this.currentTime == 0) {
                LinearSuffStat result = this.partialSums.newInstance();
                result.add(this.partialSums);
                return result;
            }
            this.flush();
            LinearSuffStat result = Sampling.copy(this.partialSums);
            result.scale(1.0 / (double)this.currentTime);
            return result;
        }

        private void delay(Serializable variableId, LinearSuffStat suffStat) {
            if (this.delayedStats.containsKey(variableId)) {
                throw new RuntimeException();
            }
            DelayedStat stat = new DelayedStat(this.currentTime, suffStat);
            this.delayedStats.put(variableId, stat);
        }

        public void flush() {
            ArrayList<Serializable> keys = new ArrayList<Serializable>(this.delayedStats.keySet());
            for (Serializable id : keys) {
                this.flush(id);
            }
        }

        public void flush(Serializable variableId) {
            DelayedStat delayedStat = this.delayedStats.get(variableId);
            if (delayedStat == null) {
                return;
            }
            this.delayedStats.remove(variableId);
            this.partialSums.add(delayedStat.toSuffStat(this.currentTime));
        }

        private static class DelayedStat {
            private final int createTime;
            private LinearSuffStat suffStat;

            private DelayedStat(int time, LinearSuffStat stat) {
                this.createTime = time;
                this.suffStat = stat;
            }

            private LinearSuffStat toSuffStat(int currentTime) {
                int delta = currentTime - this.createTime;
                LinearSuffStat result = this.suffStat;
                result.scale(delta);
                return result;
            }
        }
    }

    public static class LazyAverager<T> {
        private int currentTime = 0;
        private Counter<T> lastUpdateTimes = new Counter();
        private Counter<T> curValues = new Counter();
        private Counter<T> partialSum = new Counter();

        public Counter<T> getAverage() {
            Counter<T> result = new Counter<T>();
            if (this.currentTime == 0) {
                return result;
            }
            this.flush();
            for (T key : this.partialSum.keySet()) {
                result.setCount(key, this.partialSum.getCount(key) / (double)this.currentTime);
            }
            return result;
        }

        public void update(Counter<T> newValues) {
            for (T key : newValues.keySet()) {
                this.flush(key);
            }
            for (T key : newValues.keySet()) {
                this.lastUpdateTimes.setCount(key, this.currentTime);
                this.curValues.setCount(key, newValues.getCount(key));
            }
            ++this.currentTime;
        }

        private void flush() {
            for (T key : CollUtils.list(this.lastUpdateTimes.keySet())) {
                this.flush(key);
            }
        }

        private void flush(T key) {
            double value = this.curValues.getCount(key);
            double lastUpdateTime = this.lastUpdateTimes.getCount(key);
            this.lastUpdateTimes.removeKey(key);
            this.curValues.removeKey(key);
            int delta = this.currentTime - (int)lastUpdateTime;
            this.partialSum.incrementCount(key, (double)delta * value);
        }
    }

    public static class AsyncDistributedComputation<T extends Serializable> {
        public final File sharedDirectory;
        public final int myWorkerNumber;
        private final Set<Serializable> myVariables;
        private final Set<Integer>[] downloadedPackets;
        public final long targetSyncInteval;
        private final VariableChangeListener<T> listener;
        private long nextSyncTime;
        private List<ComputationPacket<T>> packetsToSend = new ArrayList<ComputationPacket<T>>();
        private int packetNumber = 0;
        public static final String packetFilePrefix = "PACKET";
        public static final String packetReadFilePrefix = "READ";

        public AsyncDistributedComputation(File sharedDirectory, int myWorkerNumber, Set<Serializable> myVariables, long targetSyncInteval, int nWorkers, VariableChangeListener<T> listener) {
            this.listener = listener;
            this.sharedDirectory = sharedDirectory;
            this.myWorkerNumber = myWorkerNumber;
            this.myVariables = myVariables;
            this.targetSyncInteval = targetSyncInteval;
            this.downloadedPackets = new Set[nWorkers];
            for (int i = 0; i < this.downloadedPackets.length; ++i) {
                this.downloadedPackets[i] = new HashSet<Integer>();
            }
            this.resetNextSyncTime();
        }

        public Set<Serializable> myVariables() {
            return Collections.unmodifiableSet(this.myVariables);
        }

        public int nWorkers() {
            return this.downloadedPackets.length;
        }

        public void update(Serializable variableId, T current) {
            if (!this.myVariables.contains(variableId)) {
                throw new RuntimeException();
            }
            if (this.nWorkers() > 1) {
                this.packetsToSend.add(new ComputationPacket<T>(variableId, current));
            }
            this.listener.update(variableId, current);
            if (System.currentTimeMillis() > this.nextSyncTime) {
                this.synchronize();
            }
        }

        private void updateFromFriends(ComputationPacket<T> packet) {
            if (this.myVariables.contains(((ComputationPacket)packet).variableId)) {
                throw new RuntimeException();
            }
            this.listener.update(((ComputationPacket)packet).variableId, ((ComputationPacket)packet).result);
        }

        public void synchronize() {
            if (this.nWorkers() == 1) {
                this.nextSyncTime = Long.MAX_VALUE;
                return;
            }
            this.send();
            this.receive();
            this.garbageCollect();
            this.resetNextSyncTime();
        }

        private void signalPacketRead(int workerCreatorId, int packetId) {
            Sampling.signal(this.sharedDirectory, AsyncDistributedComputation.createWorkerFileName(packetReadFilePrefix, workerCreatorId, packetId) + "." + this.myWorkerNumber);
        }

        private void garbageCollect() {
            if (!garbageCollectSyncFiles) {
                return;
            }
            String[] files = this.sharedDirectory.list();
            HashMap db = new HashMap();
            for (String candidate : files) {
                if (!AsyncDistributedComputation.isPacketReadFileName(candidate)) continue;
                int creator = AsyncDistributedComputation.getWorkerCreatorFromPacketReadFileName(candidate);
                int reader = AsyncDistributedComputation.getWorkerReaderFromPacketReadFileName(candidate);
                int packetN = AsyncDistributedComputation.getPacketNumberFromPacketReadFileName(candidate);
                Pair<Integer, Integer> key = Pair.makePair(creator, packetN);
                if (db.get(key) == null) {
                    db.put(key, new HashSet());
                }
                ((Set)db.get(key)).add(reader);
            }
            for (Pair key : db.keySet()) {
                if (((Set)db.get(key)).size() != this.nWorkers() - 1) continue;
                File packet = new File(this.sharedDirectory, AsyncDistributedComputation.createWorkerFileName(packetFilePrefix, (Integer)key.getFirst(), (Integer)key.getSecond()));
                if (!packet.delete()) {
                    LogInfo.warning("Could not delete file.. will retry later");
                    return;
                }
                LogInfo.logs("Deleted " + packet.getPath() + " (not needed anymore)");
                for (int i = 0; i < this.nWorkers(); ++i) {
                    if (i == (Integer)key.getFirst()) continue;
                    File signal = new File(this.sharedDirectory, AsyncDistributedComputation.createWorkerFileName(packetReadFilePrefix, (Integer)key.getFirst(), (Integer)key.getSecond()) + "." + i);
                    signal.delete();
                }
            }
        }

        private void resetNextSyncTime() {
            this.nextSyncTime = System.currentTimeMillis() + this.targetSyncInteval;
        }

        private void send() {
            String fileName = this.createCurrentPacketFileName();
            File file = new File(this.sharedDirectory, fileName);
            try {
                this.uploadPackets(this.packetsToSend, file);
                if (printLog) {
                    LogInfo.logs("******** Upload of my packet group successful");
                }
                ++this.packetNumber;
                this.packetsToSend = new ArrayList<ComputationPacket<T>>();
            }
            catch (IOException ioe) {
                System.err.println("Problem with uploading " + file.getPath() + "... will retry later");
                ioe.printStackTrace();
            }
        }

        private void uploadPackets(List<ComputationPacket<T>> diffGroupToSend, File file) throws IOException {
            ObjectOutputStream oos = IOUtils.openBinOut(file);
            oos.writeObject(diffGroupToSend);
            oos.close();
        }

        private void receive() {
            List<ComputationPacket<T>> newDiffGroups = this.downloadNewPackets();
            if (printLog) {
                LogInfo.logs("******** " + newDiffGroups.size() + " packets downloaded");
            }
            Collections.sort(newDiffGroups);
            for (ComputationPacket<T> packet : newDiffGroups) {
                this.updateFromFriends(packet);
            }
        }

        private List<ComputationPacket<T>> downloadNewPackets() {
            String[] files = this.sharedDirectory.list();
            ArrayList<ComputationPacket<T>> result = new ArrayList<ComputationPacket<T>>();
            for (String candidate : files) {
                if (!AsyncDistributedComputation.isSyncFileName(candidate)) continue;
                int worker = AsyncDistributedComputation.getWorkerFromSyncFileName(candidate);
                int packetN = AsyncDistributedComputation.getPacketNumberFromSyncFileName(candidate);
                if (worker == this.myWorkerNumber || this.downloadedPackets[worker].contains(packetN)) continue;
                File candidateFile = null;
                try {
                    candidateFile = new File(this.sharedDirectory, candidate);
                    result.addAll(this.downloadPacket(candidateFile));
                    this.downloadedPackets[worker].add(packetN);
                    this.signalPacketRead(worker, packetN);
                }
                catch (IOException ioe) {
                    System.err.println("Problem with downloading " + candidateFile.getPath() + "... will retry later");
                    ioe.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException();
                }
            }
            return result;
        }

        private List<ComputationPacket<T>> downloadPacket(File file) throws IOException, ClassNotFoundException {
            ObjectInputStream ois = IOUtils.openBinIn(file);
            List result = (List)ois.readObject();
            ois.close();
            return result;
        }

        private String createCurrentPacketFileName() {
            return AsyncDistributedComputation.createWorkerFileName(packetFilePrefix, this.myWorkerNumber, this.packetNumber);
        }

        private static String createWorkerFileName(String prefix, int workerNumber, int aPacket) {
            return prefix + "." + workerNumber + "." + aPacket;
        }

        private static boolean isSyncFileName(String fileName) {
            return fileName.matches("^PACKET[.][0-9]+[.][0-9]+$");
        }

        private static int getWorkerFromSyncFileName(String fileName) {
            return Integer.parseInt(StringUtils.selectRegex("^PACKET[.]([0-9]+)[.][0-9]+$", fileName).get(0));
        }

        private static int getPacketNumberFromSyncFileName(String fileName) {
            return Integer.parseInt(StringUtils.selectRegex("^PACKET[.][0-9]+[.]([0-9]+)$", fileName).get(0));
        }

        private static boolean isPacketReadFileName(String fileName) {
            return fileName.matches("^READ[.][0-9]+[.][0-9]+[.][0-9]+$");
        }

        private static int getWorkerCreatorFromPacketReadFileName(String fileName) {
            return Integer.parseInt(StringUtils.selectRegex("^READ[.]([0-9]+)[.][0-9]+[.][0-9]+$", fileName).get(0));
        }

        private static int getWorkerReaderFromPacketReadFileName(String fileName) {
            return Integer.parseInt(StringUtils.selectRegex("^READ[.][0-9]+[.][0-9]+[.]([0-9]+)$", fileName).get(0));
        }

        private static int getPacketNumberFromPacketReadFileName(String fileName) {
            return Integer.parseInt(StringUtils.selectRegex("^READ[.][0-9]+[.]([0-9]+)[.][0-9]+$", fileName).get(0));
        }
    }

    public static class ForkedChangeListener<T extends Serializable>
    implements VariableChangeListener<T> {
        public final List<VariableChangeListener<T>> listeners = new ArrayList<VariableChangeListener<T>>();

        @Override
        public void update(Serializable variableId, T result) {
            for (VariableChangeListener<T> listener : this.listeners) {
                listener.update(variableId, result);
            }
        }
    }

    public static interface VariableChangeListener<T extends Serializable> {
        public void update(Serializable var1, T var2);
    }

    public static final class ComputationPacket<T extends Serializable>
    implements Serializable,
    Comparable<ComputationPacket> {
        private static final long serialVersionUID = 1L;
        private final T result;
        private final Serializable variableId;
        private final long time;

        public ComputationPacket(Serializable variableId, T result) {
            this.result = result;
            this.variableId = variableId;
            this.time = System.currentTimeMillis();
        }

        @Override
        public int compareTo(ComputationPacket other) {
            return new Long(this.time).compareTo(new Long(other.time));
        }
    }

    public static class RandomSrcsScrambler {
        private List<Random> srcs = new ArrayList<Random>();
        @Option(gloss="Change this seed if you want to change the seed of all registered srcs")
        public Random masterRandom = new Random(1L);

        public void addSrc(Random rand) {
            this.srcs.add(rand);
        }

        public void scramble() {
            for (Random src : this.srcs) {
                src.setSeed(this.masterRandom.nextLong() * src.nextLong());
            }
        }
    }

    public static interface Proposal<T> {
        public T initial();

        public T proposed();

        public double mhRatio();
    }
}

