/*
 * Decompiled with CFR 0.152.
 */
package nuts.math;

import fig.basic.Pair;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import nuts.io.IO;
import nuts.util.CollUtils;

public class TopoSort {
    public static <T, L extends Comparable<L>> boolean onlineTopologicalSort(PartialOrder<T> po, Map<T, L> n2i, T x, T y) {
        Object node;
        if (x.equals(y)) {
            return false;
        }
        Comparable lb = (Comparable)n2i.get(y);
        Comparable ub = (Comparable)n2i.get(x);
        if (ub.compareTo(lb) < 0) {
            return true;
        }
        HashSet fwd = new HashSet(4, 0.75f);
        HashSet bwd = new HashSet(4, 0.75f);
        ArrayDeque<T> deque = new ArrayDeque<T>();
        deque.add(y);
        while (!deque.isEmpty()) {
            node = deque.pop();
            fwd.add(node);
            for (T next : po.next(node)) {
                Comparable nextPos = (Comparable)n2i.get(next);
                if (nextPos.compareTo(ub) == 0) {
                    return false;
                }
                if (fwd.contains(next) || nextPos.compareTo(ub) >= 0) continue;
                deque.push(next);
            }
        }
        deque = new ArrayDeque();
        deque.add(x);
        while (!deque.isEmpty()) {
            node = deque.pop();
            bwd.add(node);
            for (T prev : po.prev(node)) {
                Iterator prevPos = (Comparable)n2i.get(prev);
                if (bwd.contains(prev) || prevPos.compareTo((Comparable)lb) <= 0) continue;
                deque.push(prev);
            }
        }
        List spfwd = TopoSort.sortedPairedList(fwd, n2i);
        List spbwd = TopoSort.sortedPairedList(bwd, n2i);
        ArrayList<Object> merged = new ArrayList<Object>(spfwd.size() + spbwd.size());
        for (Pair p : spfwd) {
            merged.add(p.getSecond());
        }
        for (Pair p : spbwd) {
            merged.add(p.getSecond());
        }
        Collections.sort(merged);
        int currentIdxIdx = 0;
        for (Pair cur : spbwd) {
            n2i.put(cur.getFirst(), merged.get(currentIdxIdx++));
        }
        for (Pair cur : spfwd) {
            n2i.put(cur.getFirst(), merged.get(currentIdxIdx++));
        }
        return true;
    }

    private static <T, L extends Comparable<L>> List<Pair<T, L>> sortedPairedList(Set<T> set, Map<T, L> n2i) {
        ArrayList<Pair<T, L>> list = new ArrayList<Pair<T, L>>(set.size());
        for (T elt : set) {
            list.add(Pair.makePair(elt, n2i.get(elt)));
        }
        Collections.sort(list, new Comparator<Pair<T, L>>(){

            @Override
            public int compare(Pair<T, L> arg0, Pair<T, L> arg1) {
                return ((Comparable)arg0.getSecond()).compareTo(arg1.getSecond());
            }
        });
        return list;
    }

    public static <T> List<T> topologicalSort(PartialOrder<T> po) {
        HashSet<T> remaining = new HashSet<T>(po.nodes());
        ArrayList result = new ArrayList(remaining.size());
        while (!remaining.isEmpty()) {
            HashSet visited = new HashSet();
            Object elt = remaining.iterator().next();
            Set<T> temp = null;
            while (!(temp = po.prev(elt)).isEmpty()) {
                elt = temp.iterator().next();
                if (visited.contains(elt)) {
                    return null;
                }
                visited.add(elt);
            }
            TopoSort.dfs(po, elt, remaining, result);
        }
        Collections.reverse(result);
        if (!TopoSort.isCorrectTopoSort(po, result)) {
            return null;
        }
        return result;
    }

    private static <T> void dfs(PartialOrder<T> po, T current, Set<T> remaining, List<T> result) {
        remaining.remove(current);
        for (T child : po.next(current)) {
            if (!remaining.contains(child)) continue;
            TopoSort.dfs(po, child, remaining, result);
        }
        result.add(current);
    }

    private static <T> void dfs2(PartialOrder<T> po, T _current, Set<T> remaining, List<T> result) {
        IO.warnOnce("DANGER: partially untested code: switch to dfs() for safety");
        ArrayDeque<T> stack = new ArrayDeque<T>();
        stack.push(_current);
        while (!stack.isEmpty()) {
            Object current = stack.pop();
            if (remaining.contains(current)) continue;
            remaining.remove(current);
            result.add(current);
        }
        Collections.reverse(result);
    }

    public static <T> boolean isCorrectTopoSort(PartialOrder<T> po, List<T> proposed) {
        Map<T, Integer> inverted = CollUtils.invert(proposed);
        for (T elt : proposed) {
            int current = inverted.get(elt);
            for (T other : po.next(elt)) {
                if (inverted.get(other) > current) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        SetOrder so = new SetOrder(5);
        System.out.println(so.nodes());
        System.out.println(TopoSort.topologicalSort(so));
        System.out.println("Testing online version...");
        HashOrder<Set<Integer>> hashOrder = new HashOrder<Set<Integer>>(so.nodes());
        ArrayList<Set<Integer>> all = new ArrayList<Set<Integer>>(so.nodes());
        Random rand = new Random(1L);
        Map<Set<Integer>, Integer> current = CollUtils.invert(TopoSort.topologicalSort(hashOrder));
        for (int i = 0; i < 1000; ++i) {
            if (i == 42) {
                System.out.println("going to crash");
            }
            System.out.println(i + " Current po: " + ((HashOrder)hashOrder).nexts);
            Set x = (Set)all.get(rand.nextInt(all.size()));
            Set y = (Set)all.get(rand.nextInt(all.size()));
            System.out.println("Current edge considered: " + x + " -> " + y);
            boolean online = TopoSort.onlineTopologicalSort(hashOrder, current, x, y);
            System.out.println("Online: " + online);
            List<Set<Integer>> converted = TopoSort.convert(current);
            System.out.println("Online order: " + converted);
            hashOrder.add(x, y);
            if (online && !TopoSort.isCorrectTopoSort(hashOrder, converted)) {
                throw new RuntimeException();
            }
            if (TopoSort.topologicalSort(hashOrder) != null != online) {
                throw new RuntimeException();
            }
            if (!so.next(x).contains(y)) {
                System.out.println("rejected");
                hashOrder.remove(x, y);
            } else {
                System.out.println("kept");
            }
            System.out.println("----");
        }
    }

    private static <T> List<T> convert(Map<T, Integer> current) {
        ArrayList<T> result = new ArrayList<T>(current.size());
        for (int i = 0; i < current.size(); ++i) {
            result.add(null);
        }
        for (T o : current.keySet()) {
            result.set(current.get(o), o);
        }
        return result;
    }

    public static class SetOrder
    implements PartialOrder<Set<Integer>> {
        public final int size;
        public final boolean cyclic;

        public SetOrder(int size) {
            this.size = size;
            this.cyclic = false;
        }

        public SetOrder(int size, boolean introduceCycle) {
            this.size = size;
            this.cyclic = introduceCycle;
        }

        @Override
        public Set<Set<Integer>> next(Set<Integer> n) {
            HashSet<Set<Integer>> result = new HashSet<Set<Integer>>();
            for (int i = 0; i < this.size; ++i) {
                if (n.contains(i)) continue;
                HashSet<Integer> cur = new HashSet<Integer>(n.size() + 1);
                cur.addAll(n);
                cur.add(i);
                result.add(cur);
            }
            if (this.cyclic && result.size() == 0) {
                result.add(new HashSet());
            }
            return result;
        }

        @Override
        public Set<Set<Integer>> nodes() {
            HashSet<Set<Integer>> result = new HashSet<Set<Integer>>();
            this.nodes(new HashSet<Integer>(), result);
            return result;
        }

        private void nodes(Set<Integer> cur, Set<Set<Integer>> result) {
            result.add(cur);
            for (Set<Integer> successor : this.next(cur)) {
                if (result.contains(successor)) continue;
                this.nodes(successor, result);
            }
        }

        @Override
        public Set<Set<Integer>> prev(Set<Integer> n) {
            HashSet<Set<Integer>> result = new HashSet<Set<Integer>>();
            for (int i = 0; i < this.size; ++i) {
                if (!n.contains(i)) continue;
                HashSet<Integer> cur = new HashSet<Integer>(n.size());
                cur.addAll(n);
                cur.remove(i);
                result.add(cur);
            }
            return result;
        }
    }

    public static final class HashOrder<T>
    implements PartialOrder<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<T, Set<T>> nexts = new HashMap<T, Set<T>>();
        private final Map<T, Set<T>> prevs = new HashMap<T, Set<T>>();

        public HashOrder() {
        }

        public HashOrder(Set<T> initialObjects) {
            for (T o : initialObjects) {
                this.nexts.put(o, new HashSet());
                this.prevs.put(o, new HashSet());
            }
        }

        @Override
        public Set<T> next(T n) {
            return this.nexts.get(n);
        }

        @Override
        public Set<T> nodes() {
            return this.nexts.keySet();
        }

        @Override
        public Set<T> prev(T n) {
            return this.prevs.get(n);
        }

        public void add(T x) {
            if (this.nexts.containsKey(x)) {
                return;
            }
            this.nexts.put(x, new HashSet());
            this.prevs.put(x, new HashSet());
        }

        public void add(T x, T y) {
            this.add(x);
            this.add(y);
            this.nexts.get(x).add(y);
            this.prevs.get(y).add(x);
        }

        public void add(Pair<T, T> p) {
            this.add(p.getFirst(), p.getSecond());
        }

        public void remove(T x, T y) {
            if (!this.nexts.containsKey(x) || !this.nexts.containsKey(y)) {
                throw new RuntimeException();
            }
            this.nexts.get(x).remove(y);
            this.prevs.get(y).remove(x);
        }

        public void remove(Pair<T, T> p) {
            this.remove(p.getFirst(), p.getSecond());
        }
    }

    private static final class OnlineSorter<T> {
        private final PartialOrder<T> po;
        private final T x;
        private final T y;
        private final Map<T, Integer> n2i;
        private final int lb;
        private final int ub;
        private final Set<T> fwd = new HashSet<T>();
        private final Set<T> bwd = new HashSet<T>();

        public OnlineSorter(PartialOrder<T> po, T x, T y, Map<T, Integer> n2i) {
            this.po = po;
            this.x = x;
            this.y = y;
            this.n2i = n2i;
            this.lb = n2i.get(y);
            this.ub = n2i.get(x);
        }

        private boolean doIt() {
            if (this.ub < this.lb) {
                return true;
            }
            if (!this.fwd2(this.y)) {
                return false;
            }
            this.bwd2(this.x);
            this.reassign();
            return true;
        }

        private void reassign() {
            List spfwd = TopoSort.sortedPairedList(this.fwd, this.n2i);
            List spbwd = TopoSort.sortedPairedList(this.bwd, this.n2i);
            ArrayList merged = new ArrayList();
            for (Pair p : spfwd) {
                merged.add(p.getSecond());
            }
            for (Pair p : spbwd) {
                merged.add(p.getSecond());
            }
            Collections.sort(merged);
            int currentIdxIdx = 0;
            for (Pair cur : spbwd) {
                this.n2i.put((T)cur.getFirst(), (Integer)merged.get(currentIdxIdx++));
            }
            for (Pair cur : spfwd) {
                this.n2i.put((T)cur.getFirst(), (Integer)merged.get(currentIdxIdx++));
            }
        }

        private boolean fwd2(T node) {
            ArrayDeque<T> deque = new ArrayDeque<T>();
            deque.add(node);
            while (!deque.isEmpty()) {
                node = deque.pop();
                this.fwd.add(node);
                for (T next : this.po.next(node)) {
                    int nextPos = this.n2i.get(next);
                    if (nextPos == this.ub) {
                        return false;
                    }
                    if (this.fwd.contains(next) || nextPos >= this.ub) continue;
                    deque.push(next);
                }
            }
            return true;
        }

        private void bwd2(T node) {
            ArrayDeque<T> deque = new ArrayDeque<T>();
            deque.add(node);
            while (!deque.isEmpty()) {
                node = deque.pop();
                this.bwd.add(node);
                for (T prev : this.po.prev(node)) {
                    int prevPos = this.n2i.get(prev);
                    if (this.bwd.contains(prev) || prevPos <= this.lb) continue;
                    deque.push(prev);
                }
            }
        }
    }

    public static interface PartialOrder<T> {
        public Set<T> next(T var1);

        public Set<T> prev(T var1);

        public Set<T> nodes();
    }
}

