/*
 * Decompiled with CFR 0.152.
 */
package nuts.tui;

import Jama.Matrix;
import fig.basic.Pair;
import fig.basic.StrUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nuts.io.CSV;
import nuts.lispparser.ParseException;
import nuts.tools.CSV2Latex;
import nuts.util.CollUtils;
import nuts.util.Counter;
import nuts.util.EasyFormat;

public class Table {
    private final Map<Pair<Integer, Integer>, String[]> entries = new HashMap<Pair<Integer, Integer>, String[]>();
    private final Counter<Integer> maxHeights = new Counter();
    private final Counter<Integer> maxWidths = new Counter();
    private int nColumns;
    private int nRows;
    private boolean borderDefault = true;
    public static final String css = "table.with-borders {border-width: 1px 1px 1px 1px;border-spacing: 2px;border-style: solid solid solid solid;border-color: black black black black;border-collapse: collapse;background-color: white;}table.with-borders td {border-width: 1px 1px 1px 1px;padding: 1px 1px 1px 1px;border-style: dotted dotted dotted dotted;border-color: gray gray gray gray;background-color: white;-moz-border-radius: 0px 0px 0px 0px;}table.without-borders {border-width: 1px 1px 1px 1px;border-spacing: 2px;border-style: none none none none;border-collapse: collapse;background-color: white;}table.without-borders td {border-width: 1px 1px 1px 1px;padding: 1px 1px 1px 1px;border-style: none none none none;background-color: white;-moz-border-radius: 0px 0px 0px 0px;}";

    public Table() {
    }

    public Table transpose() {
        Table result = new Table();
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nColumns; ++col) {
                result.set(col, row, this.get(row, col));
            }
        }
        return result;
    }

    public Table(Populator populator) {
        populator.setTable(this);
        populator.populate();
    }

    public final void set(int row, int column, double number) {
        this.set(row, column, EasyFormat.fmt2(number));
    }

    public final void set(int row, int column, String text) {
        this.nColumns = Math.max(this.nColumns, column + 1);
        this.nRows = Math.max(this.nRows, row + 1);
        String[] lines = text.split("\\n");
        this.maxHeights.setCount(row, Math.max(this.maxHeights.getCount(row), (double)lines.length));
        for (String line : lines) {
            this.maxWidths.setCount(column, Math.max(this.maxWidths.getCount(column), (double)line.length()));
        }
        this.entries.put(new Pair<Integer, Integer>(row, column), lines);
    }

    public final void append(int row, int column, String text) {
        String[] entries = this.entries.get(new Pair<Integer, Integer>(row, column));
        String lastEntry = entries != null ? entries[entries.length - 1] : null;
        this.set(row, column, (lastEntry != null ? lastEntry : "") + text);
    }

    public final void addLines(int row, int column, String text) {
        Pair<Integer, Integer> key = new Pair<Integer, Integer>(row, column);
        String currentString = StrUtils.join((Object[])this.entries.get(key), "\n");
        if (!currentString.equals("")) {
            currentString = currentString + "\n";
        }
        currentString = currentString + text;
        this.set(row, column, currentString);
    }

    public void setBorder(boolean value) {
        this.borderDefault = value;
    }

    public String toString() {
        return this.toString(this.borderDefault);
    }

    public String toHTML() {
        return this.toHTML(this.borderDefault);
    }

    public String toHTML(boolean printBorders) {
        StringBuilder builder = new StringBuilder();
        builder.append("<table class=\"" + (printBorders ? "with-borders" : "without-borders") + "\">");
        for (int row = 0; row < this.nRows; ++row) {
            builder.append("\n<tr>");
            for (int col = 0; col < this.nColumns; ++col) {
                builder.append("<td>");
                Pair<Integer, Integer> key = new Pair<Integer, Integer>(row, col);
                String[] entry = this.entries.get(key);
                if (entry != null) {
                    for (int i = 0; i < entry.length; ++i) {
                        builder.append(entry[i] + (i < entry.length - 1 ? "<br/>" : "") + "");
                    }
                }
                builder.append("</td>");
            }
            builder.append("</tr>");
        }
        builder.append("\n</table>\n");
        return builder.toString();
    }

    public String toCSV() {
        return this.toCSV(false);
    }

    public String toCSV(boolean isFirstHeader) {
        StringBuilder result = new StringBuilder();
        for (int row = 0; row < this.nRows; ++row) {
            ArrayList line = CollUtils.list();
            for (int col = 0; col < this.nColumns; ++col) {
                line.add((isFirstHeader && row == 0 && col == 0 ? "#" : "") + this.get(row, col));
            }
            result.append(CSV.body(line) + "\n");
        }
        return result.toString();
    }

    public String toLatex() {
        StringBuilder result = new StringBuilder();
        ArrayList<String> header = CollUtils.list();
        for (int i = 0; i < this.nColumns; ++i) {
            header.add(this.get(0, i));
        }
        result.append(CSV2Latex.superHeader(header, "l") + "\n");
        Table indentTable = new Table();
        for (int row = 1; row < this.nRows; ++row) {
            for (int col = 0; col < this.nColumns; ++col) {
                indentTable.set(row - 1, col, this.get(row, col) + (col == this.nColumns - 1 ? "\\\\" : " & "));
            }
        }
        indentTable.setBorder(false);
        result.append(indentTable.toString() + "\n");
        result.append(CSV2Latex.superFooter() + "\n");
        return result.toString();
    }

    public String get(int row, int col) {
        Pair<Integer, Integer> key = new Pair<Integer, Integer>(row, col);
        String[] entry = this.entries.get(key);
        if (entry == null) {
            return "";
        }
        return StrUtils.join(entry, "\n");
    }

    public String toString(boolean printBorders) {
        StringBuilder builder = new StringBuilder();
        if (printBorders) {
            builder.append(this.horizontalSeparator() + "\n");
        }
        for (int row = 0; row < this.nRows; ++row) {
            int rowLine = 0;
            while ((double)rowLine < this.maxHeights.getCount(row)) {
                if (printBorders) {
                    builder.append("|");
                }
                for (int col = 0; col < this.nColumns; ++col) {
                    Pair<Integer, Integer> key = new Pair<Integer, Integer>(row, col);
                    String text = this.entries.get(key) == null || rowLine >= this.entries.get(key).length ? "" : this.entries.get(key)[rowLine];
                    builder.append(this.pad(text, (int)this.maxWidths.getCount(col), " "));
                    if (!printBorders) continue;
                    builder.append("|");
                }
                if ((double)rowLine != this.maxHeights.getCount(row) - 1.0) {
                    builder.append("\n");
                }
                ++rowLine;
            }
            if (printBorders) {
                builder.append("\n" + this.horizontalSeparator());
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private StringBuilder horizontalSeparator() {
        StringBuilder builder = new StringBuilder();
        builder.append("+");
        for (int col = 0; col < this.nColumns; ++col) {
            builder.append(this.pad("", (int)this.maxWidths.getCount(col), "-") + "+");
        }
        return builder;
    }

    private String pad(String s, int finalLength, String pad) {
        if (s.length() > finalLength) {
            throw new RuntimeException();
        }
        StringBuilder b = new StringBuilder();
        b.append(s);
        while (b.length() < finalLength) {
            b.append(pad);
        }
        return b.toString();
    }

    public static Table fromMatrix(final double[][] nums, final boolean printBorder, final boolean format, final boolean csv) {
        Table t = new Table(new Populator(){

            @Override
            public void populate() {
                for (int i = 0; i < nums.length; ++i) {
                    for (int j = 0; j < nums[i].length; ++j) {
                        this.addLines(i, j, (format ? EasyFormat.fmt2(nums[i][j]) : Double.valueOf(nums[i][j])) + (csv && j != nums[i].length - 1 ? "," : "") + (printBorder ? "" : " "));
                    }
                }
            }
        });
        t.setBorder(printBorder);
        return t;
    }

    public static String toString(double[][] nums) {
        Table table = Table.fromMatrix(nums, true, true, false);
        return table.toString();
    }

    public static String toString(Matrix m) {
        return Table.toString(m.getArrayCopy());
    }

    public static void main(String[] args) throws ParseException {
        Table table = new Table(new Populator(){

            @Override
            public void populate() {
                int j;
                int i;
                for (i = 0; i < 10; ++i) {
                    for (j = 0; j < 10; ++j) {
                        if (i > j) continue;
                        this.addLines(i, j, "Sum:" + (i + j));
                    }
                }
                for (i = 0; i < 10; ++i) {
                    for (j = 0; j < 10; ++j) {
                        if (i > j) continue;
                        this.addLines(i, j, "Prod:" + i * j);
                    }
                }
            }
        });
        System.out.println(table.toString());
        System.out.println(table.toHTML(false));
    }

    public static abstract class Populator {
        private Table table;

        private void setTable(Table table) {
            this.table = table;
        }

        public Populator() {
        }

        public Populator(DecimalFormat fmt) {
            throw new UnsupportedOperationException();
        }

        public abstract void populate();

        public final void set(int row, int column, double number) {
            this.table.set(row, column, number);
        }

        public final void set(int row, int column, String text) {
            this.table.set(row, column, text);
        }

        public final void append(int row, int column, String text) {
            this.table.append(row, column, text);
        }

        public final void addLines(int row, int column, String text) {
            this.table.addLines(row, column, text);
        }
    }
}

