/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import fig.basic.Parallelizer;
import fig.exec.Execution;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nuts.io.Extensions;
import nuts.io.IO;
import nuts.util.CollUtils;

public class IncrementalExperiment
implements Runnable {
    public final System system;
    private Map<OutputType, File> evaluations;
    private List<String> name;
    private List<File> inputFiles;
    @Option
    public int nThreads = 1;
    @Option
    public File inputDirectory = null;
    @Option
    public String inputSuffixFilter = null;
    @Option
    public int nReestimations = Integer.MAX_VALUE;
    @Option
    public String outputTypeClassPackage = "";
    @Option
    public ArrayList<String> refOutputTypes = CollUtils.list();
    @Option
    public ArrayList<File> refDirectories = CollUtils.list();
    private File baseDir = null;
    private Map<System, List<Map<OutputType, File>>> cache = CollUtils.map();
    private File lastIterDir = null;
    public static final TxtOutput TXT_OUTPUT = new TxtOutput();

    public String getFileName(int replicaIndex, String extension) {
        return IO.appendSuffix(this.name.get(replicaIndex), extension);
    }

    public int nReplica() {
        return this.name.size();
    }

    public void setBaseDir(File f) {
        this.baseDir = f;
    }

    @Override
    public void run() {
        this.init();
        this.runSystem(this.system);
    }

    public void init() {
        if (this.baseDir == null) {
            this.baseDir = new File(Execution.getVirtualExecDir());
        }
        if (this.refOutputTypes.size() != this.refDirectories.size()) {
            throw new RuntimeException();
        }
        this.name = CollUtils.list();
        this.inputFiles = CollUtils.list();
        for (File f : IO.ls(this.inputDirectory, this.inputSuffixFilter)) {
            this.name.add(IO.nameWithoutExtension(f));
            this.inputFiles.add(f);
        }
        this.evaluations = CollUtils.map();
        for (int i = 0; i < this.refOutputTypes.size(); ++i) {
            this.evaluations.put(this.getRefOutputType(i), this.refDirectories.get(i));
        }
    }

    public OutputType getRefOutputType(int i) {
        String classPath = (this.outputTypeClassPackage.equals("") ? "" : this.outputTypeClassPackage + ".") + this.refOutputTypes.get(i);
        try {
            Class<?> aClass = Class.forName(classPath);
            return (OutputType)aClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IncrementalExperiment(System system) {
        this.system = system;
    }

    public File getLastIterationDir() {
        return this.lastIterDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<OutputType, File>> runSystem(final System s) {
        if (this.cache.containsKey(s)) {
            LogInfo.logs("Already ran " + s.name() + "... using cache");
            return this.cache.get(s);
        }
        LogInfo.logsForce("Starting " + s.name());
        final ArrayList inits = CollUtils.list();
        for (int i = 0; i < this.nReplica(); ++i) {
            inits.add(new HashMap());
        }
        Map<OutputType, System> requiredInitializers = s.requiredInferenceInitializers();
        HashSet<System> systemsToRun = CollUtils.set(requiredInitializers.values());
        for (System initializer : systemsToRun) {
            LogInfo.logs("" + s.name() + " needs to be inialized with " + initializer.name());
            List<Map<OutputType, File>> currentOutput = this.runSystem(initializer);
            for (int i = 0; i < this.nReplica(); ++i) {
                for (OutputType type : requiredInitializers.keySet()) {
                    if (!requiredInitializers.get(type).equals(initializer)) continue;
                    ((Map)inits.get(i)).put(type, currentOutput.get(i).get(type));
                }
            }
        }
        LogInfo.logs("Starting inference-estimation loop for " + s.name());
        ArrayList result = null;
        for (int iter = 0; iter < this.nReestimations; ++iter) {
            try {
                File currentOutputDir;
                LogInfo.track("Iteration " + iter + (this.nReestimations == Integer.MAX_VALUE ? "" : "/" + this.nReestimations));
                this.lastIterDir = currentOutputDir = new File(this.baseDir, "" + s.name() + "." + Extensions.extension2String(iter));
                currentOutputDir.mkdir();
                final ArrayList currentOutputs = CollUtils.list();
                final HashMap currentOutputDirectories = CollUtils.map();
                boolean parallelize = s instanceof Parallelizable;
                int nThreads = parallelize ? this.nThreads : 1;
                LogInfo.track("Doing inference on " + this.nReplica() + " replica (" + nThreads + " threads)");
                Parallelizer<Integer> parallelizer = new Parallelizer<Integer>(nThreads);
                parallelizer.setPrimaryThread();
                parallelizer.process(CollUtils.ints(this.nReplica()), new Parallelizer.Processor<Integer>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void process(Integer i, int _i, int _n, boolean log) {
                        if (log) {
                            LogInfo.logs("Processing " + i + "/" + IncrementalExperiment.this.nReplica());
                        }
                        InferenceContext context = new InferenceContext(i, currentOutputDir, (Map)inits.get(i));
                        s.inference(context);
                        IncrementalExperiment incrementalExperiment = IncrementalExperiment.this;
                        synchronized (incrementalExperiment) {
                            currentOutputs.add(context.outputFilesUsed);
                            currentOutputDirectories.putAll(context.allOutputDirectoriesUsed);
                        }
                    }
                });
                LogInfo.end_track();
                for (Pair descrTypePair : currentOutputDirectories.keySet()) {
                    for (OutputType refType : this.evaluations.keySet()) {
                        OutputType type;
                        if (!refType.canEvaluate(type = (OutputType)descrTypePair.getSecond())) continue;
                        type.evaluate(this.evaluations.get(type), (File)currentOutputDirectories.get(descrTypePair));
                    }
                }
                EstimationContext context = new EstimationContext(currentOutputDir);
                boolean shouldContinue = false;
                if (s instanceof ReestimatedSystem) {
                    shouldContinue = ((ReestimatedSystem)s).estimation(context);
                }
                if (shouldContinue && iter != this.nReestimations - 1) continue;
                result = currentOutputs;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                LogInfo.error(e);
                continue;
            }
            finally {
                LogInfo.end_track();
            }
        }
        this.cache.put(s, result);
        return result;
    }

    public static class TxtOutput
    implements OutputType {
        private TxtOutput() {
        }

        @Override
        public boolean canEvaluate(OutputType guess) {
            return false;
        }

        @Override
        public void evaluate(File refDir, File guessDir) {
        }

        @Override
        public String extension() {
            return "txt";
        }

        @Override
        public String name() {
            return "txt";
        }
    }

    public static class EstimationContext {
        private final File currentSystemDirectory;

        public EstimationContext(File currentSystemDir) {
            this.currentSystemDirectory = currentSystemDir;
        }

        public File getCurrentSystemDirectory() {
            return this.currentSystemDirectory;
        }
    }

    public class InferenceContext {
        private final int replicaIndex;
        private final File currentSystemDirectory;
        private final Map<OutputType, File> inits;
        private Map<OutputType, File> outputFilesUsed = CollUtils.map();
        private Map<OutputType, File> mainOutputDirectoriesUsed = CollUtils.map();
        private Map<Pair<String, OutputType>, File> allOutputDirectoriesUsed = CollUtils.map();

        public InferenceContext(int replicaIndex, File currentSystemDir, Map<OutputType, File> inits) {
            this.inits = inits;
            this.replicaIndex = replicaIndex;
            this.currentSystemDirectory = currentSystemDir;
        }

        public int replicaIndex() {
            return this.replicaIndex;
        }

        public File getSystemDirectory() {
            return this.currentSystemDirectory;
        }

        private File getOutputDirectory(OutputType type, String descr) {
            File subDir = new File(this.currentSystemDirectory, type.name() + (descr == null ? "" : "-" + descr));
            subDir.mkdir();
            this.allOutputDirectoriesUsed.put(Pair.makePair(descr, type), subDir);
            if (descr == null) {
                this.mainOutputDirectoriesUsed.put(type, subDir);
            }
            return subDir;
        }

        public File getMainOutputFile(OutputType type) {
            return this.getOutputFile(type, null);
        }

        public File getOutputFile(OutputType output, String descr) {
            File subDir = this.getOutputDirectory(output, descr);
            File result = new File(subDir, IncrementalExperiment.this.getFileName(this.replicaIndex, output.extension()));
            if (descr == null) {
                this.outputFilesUsed.put(output, result);
            }
            return result;
        }

        public File getInit(OutputType type) {
            return this.inits.get(type);
        }

        public File getInput() {
            return (File)IncrementalExperiment.this.inputFiles.get(this.replicaIndex);
        }
    }

    public static abstract class AbstractSystem
    implements System {
        protected final Map<OutputType, System> requiredInitializers = CollUtils.map();

        @Override
        public Map<OutputType, System> requiredInferenceInitializers() {
            return this.requiredInitializers;
        }
    }

    public static interface Parallelizable {
    }

    public static interface System {
        public String name();

        public void inference(InferenceContext var1);

        public Map<OutputType, System> requiredInferenceInitializers();
    }

    public static interface ReestimatedSystem
    extends System {
        public boolean estimation(EstimationContext var1);
    }

    public static interface OutputType {
        public boolean canEvaluate(OutputType var1);

        public void evaluate(File var1, File var2);

        public String name();

        public String extension();
    }
}

