/*
 * Decompiled with CFR 0.152.
 */
package nuts.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nuts.lispparser.LispParser;
import nuts.lispparser.ParseException;
import nuts.util.Arbre;

public class Tree<L>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private L label = null;
    private List<Tree<L>> children;

    public Tree(Arbre<L> arbre) {
        this.label = arbre.getContents();
        this.children = new ArrayList<Tree<L>>();
        for (Arbre<L> arbreChild : arbre.getChildren()) {
            this.children.add(new Tree<Arbre<L>>(arbreChild));
        }
    }

    public List<Tree<L>> getChildren() {
        return this.children;
    }

    public void setChildren(List<Tree<L>> children) {
        this.children = children;
    }

    public L getLabel() {
        return this.label;
    }

    public void setLabel(L label) {
        this.label = label;
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public boolean isPreTerminal() {
        return this.getChildren().size() == 1 && this.getChildren().get(0).isLeaf();
    }

    public boolean isPhrasal() {
        return !this.isLeaf() && !this.isPreTerminal();
    }

    public List<L> getYield() {
        ArrayList yield = new ArrayList();
        Tree.appendYield(this, yield);
        return yield;
    }

    private static <L> void appendYield(Tree<L> tree, List<L> yield) {
        if (tree.isLeaf()) {
            yield.add(tree.getLabel());
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendYield(child, yield);
        }
    }

    public List<L> getPreTerminalYield() {
        ArrayList yield = new ArrayList();
        Tree.appendPreTerminalYield(this, yield);
        return yield;
    }

    private static <L> void appendPreTerminalYield(Tree<L> tree, List<L> yield) {
        if (tree.isPreTerminal()) {
            yield.add(tree.getLabel());
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendPreTerminalYield(child, yield);
        }
    }

    public List<Tree<L>> getPreOrderTraversal() {
        ArrayList<Tree<L>> traversal = new ArrayList<Tree<L>>();
        Tree.traversalHelper(this, traversal, true);
        return traversal;
    }

    public List<Tree<L>> getPostOrderTraversal() {
        ArrayList<Tree<L>> traversal = new ArrayList<Tree<L>>();
        Tree.traversalHelper(this, traversal, false);
        return traversal;
    }

    private static <L> void traversalHelper(Tree<L> tree, List<Tree<L>> traversal, boolean preOrder) {
        if (preOrder) {
            traversal.add(tree);
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.traversalHelper(child, traversal, preOrder);
        }
        if (!preOrder) {
            traversal.add(tree);
        }
    }

    public List<Tree<L>> toSubTreeList() {
        return this.getPreOrderTraversal();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb);
        return sb.toString();
    }

    public void toStringBuilder(StringBuilder sb) {
        if (!this.isLeaf()) {
            sb.append('(');
        }
        if (this.getLabel() != null) {
            sb.append(this.getLabel());
        }
        if (!this.isLeaf()) {
            for (Tree<L> child : this.getChildren()) {
                sb.append(' ');
                child.toStringBuilder(sb);
            }
            sb.append(')');
        }
    }

    public Tree<L> deepCopy() {
        return Tree.deepCopy(this);
    }

    private static <L> Tree<L> deepCopy(Tree<L> tree) {
        ArrayList<Tree<L>> childrenCopies = new ArrayList<Tree<L>>();
        for (Tree<L> child : tree.getChildren()) {
            childrenCopies.add(Tree.deepCopy(child));
        }
        return new Tree<L>(tree.getLabel(), childrenCopies);
    }

    public Tree(L label, List<Tree<L>> children) {
        this.label = label;
        this.children = children;
    }

    public Tree() {
        this.label = null;
        this.children = new ArrayList<Tree<L>>();
    }

    public Tree(L label) {
        this.label = label;
        this.children = new ArrayList<Tree<L>>();
    }

    public static Tree<String> parse(String treeDescr) {
        try {
            return new LispParser(treeDescr).parse();
        }
        catch (ParseException e) {
            throw new RuntimeException();
        }
    }
}

