/*
 * Decompiled with CFR 0.152.
 */
package pedi.main;

import fenchel.factor.multisites.MSUnaryMap;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.NumUtils;
import fig.basic.Option;
import fig.basic.OptionSet;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import nuts.io.CSV;
import nuts.io.IO;
import nuts.lang.ArrayUtils;
import nuts.util.CollUtils;
import nuts.util.MathUtils;
import pedi.BiAllelicDiploidGenotype;
import pedi.Genotype;
import pedi.Genotypes;
import pedi.Individual;
import pedi.Model;
import pedi.PedigreeUtils;
import pedi.RegularPedigree;
import pedi.factor.FactorEncodings;
import pedi.factor.PedigreeNode;
import pedi.main.DataSource;
import pedi.main.PedigreeModelOptions;
import pedi.main.PhenotypeOptions;
import pedi.pheno.DiseasePhenotypes;
import pedi.pheno.DiseaseTypes;
import pedi.simulator.DataSimulator;
import pedi.simulator.DataSimulatorOptions;
import pedi.simulator.WFSimulator;
import pedi.simulator.WFSimulatorOptions;

public abstract class PediMain
implements Runnable {
    @Option
    public static boolean newLinkageModel = true;
    @OptionSet(name="wf")
    public WFSimulatorOptions wfSimulatorOptions = new WFSimulatorOptions();
    @OptionSet(name="pedsim")
    public DataSimulatorOptions pedsimOptions = new DataSimulatorOptions();
    @OptionSet(name="model")
    public PedigreeModelOptions options = new PedigreeModelOptions();
    @OptionSet(name="pheno")
    public PhenotypeOptions phenoOptions = new PhenotypeOptions();
    @OptionSet(name="pen")
    public PenetranceParameters penOptions = new PenetranceParameters();
    @Option
    public double probabilityInternalNodeHeldout = 0.5;
    @Option
    public boolean saveReconstructions = false;
    @Option
    public Random heldoutRandom = new Random(1L);
    @Option
    public DataSource dataSource = DataSource.WF;
    @Option
    public String pedigreePath = "";
    public static PenetranceParameters globalPenetranceParams;
    private RegularPedigree pedigree;
    private Genotypes data;
    private DiseasePhenotypes phenotypes;
    private boolean pedigreeAndDataLoaded = false;
    private boolean phenotypesLoaded = false;
    private double[][] diseaseLocusIndics = null;
    private int trueDiseasePosition;
    private Map<Individual, Boolean> affections;
    private File evaluateDir = null;
    private PrintWriter genoEvalSummary = null;
    private PrintWriter haploEvalSummary = null;
    private PrintWriter phenoEvalSummary = null;
    private double[] cumulative = null;
    private File recombRates;
    private File pedigreeAndDataFile;
    private Map<Individual, Integer> genders;

    private void ensureLoaded() {
        globalPenetranceParams = this.penOptions;
        this.options.recombRate = this.pedsimOptions.recombRate() / this.options.recombPenalty;
        if (newLinkageModel) {
            if (this.phenoOptions.diseaseType != DiseaseTypes.NEW_RECESSIVE && this.phenoOptions.diseaseType != DiseaseTypes.NEW_RECESSIVE2) {
                throw new RuntimeException();
            }
            this.pedsimOptions.nMarkers = this.pedsimOptions.nMarkers * 2 + 1;
        }
        if (this.pedigreeAndDataLoaded) {
            return;
        }
        if (this.dataSource == DataSource.WF) {
            this.loadWF();
        } else if (this.dataSource == DataSource.LOAD) {
            this.loadFromFile();
        } else {
            throw new RuntimeException();
        }
        this.holdOutData();
        this.pedigreeAndDataLoaded = true;
        this.ensurePhenotypesLoaded();
    }

    public Model getModel() {
        return new Model(this.getPedigree(), this.getData(), this.options, this.getPhenotype());
    }

    public DiseasePhenotypes getPhenotype() {
        this.ensurePhenotypesLoaded();
        return this.phenotypes;
    }

    private boolean sampleAffection(Individual i, double[][] diseaseLocusIndics) {
        double[][] temp = new double[this.data.genomeSize()][2];
        double[][][] dis = new double[][][]{diseaseLocusIndics, temp};
        for (int j = 0; j < this.data.genomeSize(); ++j) {
            temp[j][0] = 1.0;
        }
        return this.phenoOptions.diseaseType.sampleAffection(this.phenoOptions.affectionRand, this.forceGet(i).getHeldoutAlleleIndicator(0), this.forceGet(i).getHeldoutAlleleIndicator(1), dis);
    }

    private void sampleDiseaseLocus() {
        if (this.diseaseLocusIndics != null) {
            throw new RuntimeException();
        }
        this.diseaseLocusIndics = new double[this.data.genomeSize()][2];
        if (newLinkageModel) {
            int nFlanks = this.data.genomeSize() / 2 + 1;
            this.trueDiseasePosition = 2 * this.phenoOptions.diseaseLocusRand.nextInt(nFlanks);
        } else {
            this.trueDiseasePosition = this.phenoOptions.diseaseLocusRand.nextInt(this.data.genomeSize());
        }
        LogInfo.logsForce("trueDiseaseLocus=" + this.trueDiseasePosition);
        IO.writeToDisk(new File(Execution.getFile("trueDiseaseLocus.txt")), "" + this.trueDiseasePosition);
        for (int site = 0; site < this.data.genomeSize(); ++site) {
            this.diseaseLocusIndics[site][site == this.trueDiseasePosition ? 1 : 0] = 1.0;
        }
    }

    public Map<Individual, Boolean> getAffections() {
        this.ensurePhenotypesLoaded();
        return this.affections;
    }

    private void ensurePhenotypesLoaded() {
        if (this.phenotypesLoaded || !this.phenoOptions.usePhenotypeModel) {
            return;
        }
        this.ensureLoaded();
        LogInfo.track((Object)"Preparing affection data", true);
        this.sampleDiseaseLocus();
        this.affections = new HashMap<Individual, Boolean>();
        if (newLinkageModel) {
            this.data.setHiddenMarkersToOne(this.trueDiseasePosition);
        }
        for (Individual i : this.getPedigree().individuals()) {
            if (!(this.phenoOptions.affectionHeldOutRand.nextDouble() > this.phenoOptions.probabilityAffectionHeldout)) continue;
            this.affections.put(i, this.sampleAffection(i, this.diseaseLocusIndics));
        }
        if (newLinkageModel) {
            this.data.removeEvenMarkers();
        }
        LogInfo.logs("Affection observed for " + this.affections.keySet().size() + " of " + this.getPedigree().individuals().size() + " individuals");
        Collection affected = CollUtils.invert(this.affections).get(true);
        LogInfo.logs("Of these, " + (affected == null ? 0 : affected.size()) + " are affected");
        this.phenotypes = new DiseasePhenotypes(this.phenoOptions.diseaseType, this.affections);
        this.phenotypesLoaded = true;
        LogInfo.end_track();
    }

    private BiAllelicDiploidGenotype getHeldout(Individual n) {
        return (BiAllelicDiploidGenotype)this.data.getHeldoutGenotype(n);
    }

    private BiAllelicDiploidGenotype forceGet(Individual n) {
        BiAllelicDiploidGenotype result = this.getHeldout(n);
        if (result != null) {
            return result;
        }
        return (BiAllelicDiploidGenotype)this.data.getGenotype(n);
    }

    private void loadFromFile() {
        throw new RuntimeException();
    }

    public String join(List descriptionKeys, List descriptionValues) {
        StringBuilder result = new StringBuilder();
        int size = descriptionKeys.size();
        if (size != descriptionValues.size()) {
            throw new RuntimeException();
        }
        for (int i = 0; i < size; ++i) {
            result.append("" + descriptionKeys.get(i) + "=" + descriptionValues.get(i) + (i == size - 1 ? "" : ","));
        }
        return result.toString();
    }

    public void evaluate(MSUnaryMap<PedigreeNode> beliefs, List descriptionKeys, List descriptionValues) {
        this.evaluateHaplotypes(beliefs, descriptionKeys, descriptionValues);
        if (this.phenoOptions.usePhenotypeModel) {
            int i;
            double[][] guesses = beliefs.getUnaryArray(PedigreeNode.createDiseaseNode(0));
            double[] dist = new double[guesses.length];
            for (i = 0; i < guesses.length; ++i) {
                dist[i] = 1.0 - guesses[i][0];
            }
            NumUtils.normalize(dist);
            this.evaluateDiseaseLocus(descriptionKeys, descriptionValues, dist);
            if (this.cumulative == null) {
                this.cumulative = new double[dist.length];
            }
            for (i = 0; i < this.cumulative.length; ++i) {
                int n = i;
                this.cumulative[n] = this.cumulative[n] + dist[i];
            }
            double[] current = (double[])this.cumulative.clone();
            NumUtils.normalize(current);
            descriptionValues.set(0, descriptionValues.get(0) + "-cumulative");
            this.evaluateDiseaseLocus(descriptionKeys, descriptionValues, current);
        }
    }

    public void evaluateDiseaseLocus(List descriptionKeys, List descriptionValues, double[] dist) {
        dist = (double[])dist.clone();
        if (newLinkageModel) {
            for (int i = 0; i < dist.length; ++i) {
                if (i % 2 != 1) continue;
                dist[i] = 0.0;
            }
        }
        NumUtils.normalize(dist);
        LogInfo.track((Object)("diseaseLocusEval(" + this.join(descriptionKeys, descriptionValues) + ")"), true);
        if (this.phenoEvalSummary == null) {
            this.phenoEvalSummary = IOUtils.openOutHard(Execution.getFile("phenotypesEvaluationSummary.csv"));
            ArrayList<String> csvHead = new ArrayList<String>(descriptionKeys);
            csvHead.add("minPred");
            csvHead.add("truePos");
            csvHead.add("guessPos");
            csvHead.add("dist");
            csvHead.add("dist1");
            csvHead.add("dist10");
            csvHead.add("dist100");
            csvHead.add("perplexity");
            csvHead.add("rank");
            csvHead.add("normalizedRank");
            this.phenoEvalSummary.println(CSV.header(csvHead));
        }
        int truePosition = this.trueDiseasePosition;
        double perplexity = 1.0 / dist[truePosition];
        int guess = MathUtils.argmax(dist);
        double rank = this.findRank(dist, truePosition);
        double normalizedRank = rank / (double)dist.length;
        LogInfo.logs("Truth=" + truePosition);
        LogInfo.logs("Guess=" + guess);
        LogInfo.logs("Perplexity=" + perplexity);
        LogInfo.logs("NormalizedRank=" + normalizedRank);
        double minPred = ArrayUtils.min(dist);
        ArrayList<String> csvBody = new ArrayList<String>(descriptionValues);
        csvBody.add("" + minPred);
        csvBody.add("" + truePosition);
        csvBody.add("" + guess);
        csvBody.add("" + Math.abs(truePosition - guess));
        csvBody.add("" + Math.min(1, Math.abs(truePosition - guess)));
        csvBody.add("" + Math.min(10, Math.abs(truePosition - guess)));
        csvBody.add("" + Math.min(100, Math.abs(truePosition - guess)));
        csvBody.add("" + perplexity);
        csvBody.add("" + rank);
        csvBody.add("" + normalizedRank);
        this.phenoEvalSummary.println(CSV.body(csvBody));
        this.phenoEvalSummary.flush();
        LogInfo.end_track();
    }

    private double findRank(double[] dist, int truePosition) {
        double valueOfTruePos = dist[truePosition];
        double larger = 0.0;
        double equal = 0.0;
        for (double value : dist) {
            if (value > valueOfTruePos) {
                larger += 1.0;
            }
            if (value != valueOfTruePos) continue;
            equal += 1.0;
        }
        return larger + (equal - 1.0) / 2.0;
    }

    private void evaluateHaplotypes(MSUnaryMap<PedigreeNode> beliefs, List descriptionKeys, List descriptionValues) {
        if (this.haploEvalSummary == null) {
            this.haploEvalSummary = IOUtils.openOutHard(Execution.getFile("haplotypesEvaluationSummary.csv"));
            ArrayList<String> csvHead = new ArrayList<String>(descriptionKeys);
            csvHead.add("haplotypeLoss");
            this.haploEvalSummary.println(CSV.header(csvHead));
        }
        double num = 0.0;
        double denom = 0.0;
        FactorEncodings fenc = this.getFactorEncodings();
        for (Individual n : this.data.heldoutIndividuals()) {
            if (this.pedigree.founders().contains(n)) continue;
            Individual m = this.pedigree.parent(n, 0);
            Individual f = this.pedigree.parent(n, 1);
            if (this.pedigree.founders().contains(m) && this.pedigree.founders().contains(f)) continue;
            BiAllelicDiploidGenotype truth = this.getHeldout(n);
            PedigreeNode current = PedigreeNode.createHaplotypeNode(n);
            double[][] guesses = beliefs.getUnaryArray(current);
            for (int site = 0; site < guesses.length; ++site) {
                if (newLinkageModel && site % 2 == 0) continue;
                int guessedHaplotype = ArrayUtils.argmax(guesses[site]);
                int[] guessAlleles = new int[]{fenc.alleleCode(guessedHaplotype, 0), fenc.alleleCode(guessedHaplotype, 1)};
                int[] trueAlleles = new int[]{truth.getHeldoutHaplotype(site, 0), truth.getHeldoutHaplotype(site, 1)};
                for (int i = 0; i < 2; ++i) {
                    boolean correct = guessAlleles[i] == trueAlleles[i];
                    num += correct ? 0.0 : 1.0;
                    denom += 1.0;
                }
            }
        }
        LogInfo.logs("haplotypeEditLoss(" + this.join(descriptionKeys, descriptionValues) + ")=" + num / denom);
        ArrayList<String> csvBody = new ArrayList<String>(descriptionValues);
        csvBody.add("" + num / denom);
        this.haploEvalSummary.println(CSV.body(csvBody));
        this.haploEvalSummary.flush();
    }

    private void evaluateGenotypes(MSUnaryMap<PedigreeNode> beliefs, List descriptionKeys, List descriptionValues) {
        if (this.saveReconstructions && this.evaluateDir == null) {
            this.evaluateDir = new File(Execution.getFile("genotypeEvaluation"));
            this.evaluateDir.mkdir();
        }
        if (this.genoEvalSummary == null) {
            this.genoEvalSummary = IOUtils.openOutHard(Execution.getFile("genotypeEvaluationSummary.csv"));
            ArrayList<String> csvHead = new ArrayList<String>(descriptionKeys);
            csvHead.add("genotypeEditD");
            this.genoEvalSummary.println(CSV.header(csvHead));
        }
        FactorEncodings fenc = this.getFactorEncodings();
        double num = 0.0;
        double denom = 0.0;
        for (Individual n : this.data.heldoutIndividuals()) {
            PrintWriter out = null;
            if (this.saveReconstructions) {
                out = IOUtils.openOutHard(new File(this.evaluateDir, "indiv=" + n + "," + this.join(descriptionKeys, descriptionValues) + ".csv"));
                out.println(CSV.header("truth", "guess", "editD", "posterior") + "\n");
            }
            Genotype trueGenotypes = this.data.getHeldoutGenotype(n);
            double[][] truths = trueGenotypes.getUnaryFactor();
            PedigreeNode current = PedigreeNode.createHaplotypeNode(n);
            double[][] guesses = beliefs.getUnaryArray(current);
            for (int site = 0; site < guesses.length; ++site) {
                double editD = fenc.mapGenotypeEditDistance(truths[site], guesses[site], out);
                num += editD;
                denom += 2.0;
            }
            if (!this.saveReconstructions) continue;
            out.close();
        }
        ArrayList<String> csvBody = new ArrayList<String>(descriptionValues);
        csvBody.add("" + num / denom);
        this.genoEvalSummary.println(CSV.body(csvBody));
        this.genoEvalSummary.flush();
    }

    public FactorEncodings getFactorEncodings() {
        this.ensureLoaded();
        return this.data.getFactorEncodings();
    }

    public RegularPedigree getPedigree() {
        this.ensureLoaded();
        return this.pedigree;
    }

    public File getRecombRatesFile() {
        this.ensureLoaded();
        return this.recombRates;
    }

    public Map<Individual, Integer> getGenders() {
        this.ensureLoaded();
        return this.genders;
    }

    private void loadWF() {
        File founderHaps;
        LogInfo.track((Object)"Generating WF pedigree", true);
        File pedigreeFile = new File(Execution.getFile("output.ped"));
        WFSimulator sim = new WFSimulator();
        this.pedigree = sim.simulate(this.wfSimulatorOptions.halfPopSize, this.wfSimulatorOptions.nGenerations, this.wfSimulatorOptions.fractionTypedParents, this.wfSimulatorOptions.wfPedigreeRand, this.wfSimulatorOptions.monogamous, pedigreeFile);
        this.genders = sim.reader.getGenders();
        if (this.wfSimulatorOptions.render) {
            PedigreeUtils.render(pedigreeFile);
        }
        LogInfo.logsForce("Loaded:" + this.pedigree);
        LogInfo.end_track();
        RegularPedigree rp = RegularPedigree.getRegularPedigree(this.pedigree);
        int nSites = this.pedsimOptions.nMarkers;
        this.recombRates = new File(Execution.getFile("rates.rec"));
        File file = founderHaps = this.pedsimOptions.useRealData ? new File("" + this.pedsimOptions.nMarkers + ".haps.1") : new File(Execution.getFile("founders.hap"));
        if (this.pedsimOptions.useRealData && !founderHaps.exists()) {
            throw new RuntimeException("Real data file does not exist:" + founderHaps.getAbsolutePath());
        }
        DataSimulator.writeUniformRecombRateFile(this.recombRates, this.pedsimOptions.recombRate(), nSites);
        if (!this.pedsimOptions.useRealData) {
            DataSimulator.writeUniformFounderHaplotypes(founderHaps, this.pedsimOptions.alleleFreq, rp.founders().size() * 2, nSites, this.pedsimOptions.dataGenRand);
        }
        this.pedigreeAndDataFile = new File(Execution.getFile("data.ped"));
        this.data = DataSimulator.simulateData(this.recombRates, founderHaps, pedigreeFile, this.pedigreeAndDataFile, this.pedsimOptions.dataGenRand);
    }

    public Genotypes getData() {
        this.ensureLoaded();
        return this.data;
    }

    private void holdOutData() {
        LogInfo.track((Object)"Holding out:", true);
        int n = 0;
        for (Individual i : CollUtils.list(this.data.genotypedIndividuals())) {
            if (this.pedigree.founders().contains(i) || !(this.heldoutRandom.nextDouble() < this.probabilityInternalNodeHeldout)) continue;
            ++n;
            LogInfo.logs("" + i);
            this.data.holdout(i);
        }
        LogInfo.logs("" + n + " individuals held out");
        LogInfo.end_track();
    }

    public static class PenetranceParameters {
        @Option
        public double p0 = 0.0;
        @Option
        public double p1 = 0.0;
        @Option
        public double p2 = 1.0;
    }
}

