/*
 * Decompiled with CFR 0.152.
 */
package pedi.tests;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import fig.basic.IOUtils;
import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import nuts.io.IO;
import nuts.math.Sampling;
import pedi.Individual;
import pedi.Pedigree;
import pedi.PedigreeUtils;
import pedi.RegularPedigree;
import pedi.io.PedigreeFileReader;
import pedi.tests.Node;

public class GenerateIndepSites
implements Runnable {
    @Option
    public double alleleFreq = 0.5;
    @Option
    public int nSites = 10;

    public static void main(String[] args) {
        IO.run(args, new GenerateIndepSites());
    }

    @Override
    public void run() {
        PedigreeFileReader reader = new PedigreeFileReader();
        reader.read(new File("/Users/bouchard/Documents/data/quebecPedigree/justGenealogy.ped"));
        RegularPedigree p = RegularPedigree.getRegularPedigree(reader.getPedigree());
        List<Pedigree> ccs = PedigreeUtils.connectedSubpedigrees(p);
        Ordering<Pedigree> order = new Ordering<Pedigree>(){

            public int compare(Pedigree arg0, Pedigree arg1) {
                return arg0.individuals().size() - arg1.individuals().size();
            }
        };
        p = RegularPedigree.getRegularPedigree((Pedigree)order.max(ccs));
        Random rand = new Random(1L);
        PrintWriter out = IOUtils.openOutHard(Execution.getFile("data.txt"));
        ArrayList leaves = Lists.newArrayList(p.leaves());
        out.print("#");
        for (Individual i : leaves) {
            out.print(i + "\t");
        }
        out.println();
        for (int s = 0; s < this.nSites; ++s) {
            List<Pair<Integer, Integer>> generated = GenerateIndepSites.generate(p, leaves, this.alleleFreq, rand);
            for (Pair<Integer, Integer> haplo : generated) {
                out.print("(" + haplo.getFirst() + "," + haplo.getSecond() + ")\t");
            }
            out.println();
        }
        out.close();
    }

    public static List<Pair<Integer, Integer>> generate(RegularPedigree p, List<Individual> individuals, double alleleFreq, Random rand) {
        ArrayList result = Lists.newArrayList();
        HashMap generatedAlleles = Maps.newHashMap();
        HashMap generatedInherit = Maps.newHashMap();
        for (Individual i : individuals) {
            result.add(Pair.makePair(GenerateIndepSites.generate(new Node(i, 0), generatedAlleles, generatedInherit, p, alleleFreq, rand), GenerateIndepSites.generate(new Node(i, 1), generatedAlleles, generatedInherit, p, alleleFreq, rand)));
        }
        return result;
    }

    private static Integer generate(Node n, Map<Node, Integer> generatedAlleles, Map<Node, Integer> generatedInherit, RegularPedigree p, double alleleFreq, Random rand) {
        if (generatedAlleles.containsKey(n)) {
            return generatedAlleles.get(n);
        }
        Integer result = null;
        Individual parent = p.parent(n.i, n.chr);
        if (parent == null) {
            result = Sampling.sampleBern(alleleFreq, rand) ? 0 : 1;
        } else {
            Integer parentNodeIdx = generatedInherit.get(n);
            if (parentNodeIdx == null) {
                parentNodeIdx = Sampling.sampleBern(0.5, rand) ? 0 : 1;
                generatedInherit.put(n, parentNodeIdx);
            }
            Node parentNode = new Node(parent, parentNodeIdx);
            result = GenerateIndepSites.generate(parentNode, generatedAlleles, generatedInherit, p, alleleFreq, rand);
        }
        generatedAlleles.put(n, result);
        return result;
    }
}

