/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import goblin.HLParamsUpdater;
import java.util.List;
import java.util.regex.Pattern;
import nuts.io.IO;
import nuts.lang.StringUtils;
import nuts.tui.Utils;
import nuts.util.Counter;
import nuts.util.CounterMap;

public class AnalyzeFeatures {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("pepper.AnalyzeFeatures <edits.contextEdits> [cmds]");
            return;
        }
        IO.so("Loading stats from " + args[0]);
        IO.so("Type help if you are lost");
        Counter stats = HLParamsUpdater.restoreCounter(args[0]);
        if (args.length == 1) {
            String cmd;
            while (!(cmd = Utils.hardPrompt()).equals("")) {
                if (cmd.equals("help")) {
                    IO.so("M <pattern> : number of matches for the given pattern\n[C ]<pattern_with_one_capturing_gp> : number of matches for each different capturing gp\nH <pattern_with_two_capturing_gp> : hierarchically organized matches for 2 capturing gp\nI <pattern_with_two_capturing_gp> : same as above with inverse hierarchy\nF <pattern_with_two_capturing_gp> : same as above but without hierarchies at all\n<empty_line> : exit\n");
                    continue;
                }
                AnalyzeFeatures.process(cmd, stats);
            }
        } else {
            for (String line : IO.i(args[1])) {
                AnalyzeFeatures.process(line, stats);
            }
        }
    }

    private static void process(String cmd, Counter<String> stats) {
        try {
            IO.so("Cmd: " + cmd);
            if (cmd.matches("^H\\s.*")) {
                AnalyzeFeatures.processHierarchicalCapture(Pattern.compile(cmd.substring(2)), stats, false);
            } else if (cmd.matches("^I\\s.*")) {
                AnalyzeFeatures.processHierarchicalCapture(Pattern.compile(cmd.substring(2)), stats, true);
            } else if (cmd.matches("^F\\s.*")) {
                AnalyzeFeatures.processFlatCapture(Pattern.compile(cmd.substring(2)), stats);
            } else if (cmd.matches("^M\\s.*")) {
                cmd = cmd.substring(2) + "()";
            } else if (cmd.matches("^C\\s.*")) {
                cmd = cmd.substring(2);
            }
            Pattern p = Pattern.compile(cmd);
            Counter<String> counter = new Counter<String>();
            for (String key : stats.keySet()) {
                String match = StringUtils.selectFirstRegex(p, key);
                if (match == null) continue;
                counter.incrementCount(match, stats.getCount(key));
            }
            for (String key : counter) {
                IO.so(key + "\t" + counter.getCount(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void processFlatCapture(Pattern p, Counter<String> stats) {
        Counter<String> counter = new Counter<String>();
        for (String key : stats.keySet()) {
            List<String> match = StringUtils.multiSelectFirstRegex(p, key);
            if (match == null) continue;
            if (match.size() != 2) {
                throw new RuntimeException();
            }
            counter.incrementCount(match.get(0) + "," + match.get(1), stats.getCount(key));
        }
        for (String key : counter) {
            IO.so(key + "\t" + counter.getCount(key));
        }
    }

    private static void processHierarchicalCapture(Pattern p, Counter<String> stats, boolean invert) {
        CounterMap<String, String> counter = new CounterMap<String, String>();
        for (String key : stats.keySet()) {
            List<String> match = StringUtils.multiSelectFirstRegex(p, key);
            if (match == null) continue;
            if (match.size() != 2) {
                throw new RuntimeException();
            }
            if (invert) {
                counter.incrementCount(match.get(1), match.get(0), stats.getCount(key));
                continue;
            }
            counter.incrementCount(match.get(0), match.get(1), stats.getCount(key));
        }
        Counter<String> totalCounts = new Counter<String>();
        for (String key1 : counter.keySet()) {
            totalCounts.setCount(key1, counter.getCounter(key1).totalCount());
        }
        for (String key1 : totalCounts) {
            IO.so(key1 + "\t" + totalCounts.getCount(key1));
            for (String key2 : counter.getCounter(key1)) {
                IO.so("\t" + key2 + "\t" + counter.getCounter(key1).getCount(key2));
            }
        }
    }
}

