/*
 * Decompiled with CFR 0.152.
 */
package pepper;

import java.io.Serializable;
import pepper.Edit;
import pepper.Encodings;

public class Effect
implements Comparable<Effect>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final int y;
    public final int z;
    private final Encodings enc;

    public Effect(Encodings enc, int y, int z) {
        this.enc = enc;
        this.y = y;
        this.z = z;
    }

    public Effect(Encodings enc, int y) {
        this.enc = enc;
        this.y = y;
        this.z = -1;
    }

    public Effect(Encodings enc) {
        this.enc = enc;
        this.y = -1;
        this.z = -1;
    }

    public Edit.EditType getEditType() {
        if (this.y == -1) {
            return Edit.EditType.DELETION;
        }
        if (this.z == -1) {
            return Edit.EditType.SUBSTITUTION;
        }
        return Edit.EditType.FISSION;
    }

    public boolean isDeletion() {
        return this.getEditType().equals((Object)Edit.EditType.DELETION);
    }

    public boolean isSubstitution() {
        return this.getEditType().equals((Object)Edit.EditType.SUBSTITUTION);
    }

    public boolean isFission() {
        return this.getEditType().equals((Object)Edit.EditType.FISSION);
    }

    public String toString() {
        if (this.y == -1) {
            return String.format("* -> / *", new Object[0]);
        }
        if (this.z == -1) {
            return String.format("* -> %c / *", Character.valueOf(this.x2s(this.y)));
        }
        return String.format("* -> %c %c / *", Character.valueOf(this.x2s(this.y)), Character.valueOf(this.x2s(this.z)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Effect)) {
            return false;
        }
        Effect o_cast = (Effect)o;
        if (this.y != o_cast.y) {
            return false;
        }
        return this.z == o_cast.z;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + this.y;
        hashCode = 29 * hashCode + this.z;
        return hashCode;
    }

    private char x2s(int x) {
        return this.enc.phoneId2Char(x);
    }

    @Override
    public int compareTo(Effect o) {
        return this.toString().compareTo(o.toString());
    }
}

