/*
 * Decompiled with CFR 0.152.
 */
package pepper.editmodel;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import nuts.io.Extensions;
import pepper.Edit;
import pepper.Encodings;
import pepper.editmodel.Utils;

public class OldMain {
    public static Encodings createEncodings(List<String> allWords) throws IOException {
        Encodings enc = null;
        if (Encodings.encodingsType == Encodings.EncodingType.TOY_CTX_FREE) {
            LogInfo.logs("Toy ctx free encs");
            enc = Encodings.getEncoding(Encodings.EncodingType.TOY_CTX_FREE);
            return enc;
        }
        if (Encodings.encodingsType != Encodings.EncodingType.REAL) {
            throw new RuntimeException();
        }
        LogInfo.track((Object)"Creating the Encodings", true);
        HashSet<Character> occurringCharacters = new HashSet<Character>();
        OldMain.addCharacters(allWords, occurringCharacters);
        LogInfo.logs("" + occurringCharacters.size() + " distinct characters encountered.");
        enc = Encodings.realEncoding(occurringCharacters);
        LogInfo.logs("Vowels info loaded from " + Encodings.ipaVowelsFile + " " + Encodings.vowelsIndices);
        LogInfo.logs("Consonants info loaded from " + Encodings.ipaConsonantsFile + " " + Encodings.consonantIndices);
        LogInfo.logs(enc.toString());
        OldMain.dumpStat("phonemes", "Character encodings", enc.toString());
        LogInfo.end_track();
        return enc;
    }

    private static void addCharacters(List<String> words, Set<Character> set) {
        for (String word : words) {
            if (word == null) continue;
            char[] cArray = word.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character character = Character.valueOf(cArray[i]);
                set.add(character);
            }
        }
    }

    public static List<Edit> inDelSubRules(Encodings enc) {
        Encodings globalEnc = enc;
        int NC = globalEnc.getNumberOfEqClasses();
        int alpha = globalEnc.getNumberOfPhonemes();
        HashSet<Edit> result = new HashSet<Edit>();
        for (int c1 = 0; c1 < NC; ++c1) {
            for (int x = 0; x < alpha; ++x) {
                for (int c2 = 0; c2 < NC; ++c2) {
                    if (x != globalEnc.getBoundaryPhoneId()) {
                        result.add(new Edit(enc, c1, x, c2));
                        for (int y = 0; y < alpha; ++y) {
                            result.add(new Edit(enc, c1, x, c2, y));
                            result.add(new Edit(enc, c1, x, c2, x, y));
                            result.add(new Edit(enc, c1, x, c2, y, x));
                        }
                        continue;
                    }
                    result.add(new Edit(enc, c1, x, c2, x));
                }
            }
        }
        LinkedList<Edit> list = new LinkedList<Edit>();
        list.addAll(result);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpStat(String name, String desc, String stats) throws IOException {
        if (stats == null || stats.equals("")) {
            return;
        }
        String fileName = Utils.safeGetExecFilePath(name);
        try (PrintWriter out = IOUtils.openOut(fileName);){
            out.append(stats);
            LogInfo.logs(desc + " dumped in " + fileName);
        }
    }

    public static void dumpStat(String name, int iter, String desc, String stats) throws IOException {
        OldMain.dumpStat(name + "." + Extensions.extension2String(iter), desc, stats);
    }
}

