/*
 * Decompiled with CFR 0.152.
 */
package poly;

import functional.Fct;
import poly.Complex;

public class CmpxPoly
implements Fct<Complex, Complex> {
    private final Complex[] coef;
    private final int degree;

    public CmpxPoly(Complex[] coef) {
        this.coef = coef;
        this.degree = coef.length - 1;
    }

    public int degree() {
        return this.degree;
    }

    @Override
    public Complex applyTo(Complex x) {
        Complex result = this.coef[this.degree];
        for (int i = this.degree - 1; i >= 0; --i) {
            result = Complex.plus(this.coef[i], Complex.times(x, result));
        }
        return result;
    }

    private Complex lazyApplyTo(Complex x) {
        Complex result = Complex.zero();
        for (int i = 0; i <= this.degree; ++i) {
            result = Complex.plus(result, Complex.times(this.coef[i], Complex.pow(x, i)));
        }
        return result;
    }

    public static void main(String[] args) {
        Complex[] coef = new Complex[]{new Complex(-5.0), new Complex(3.0), new Complex(-3.0), new Complex(1.0)};
        CmpxPoly poly = new CmpxPoly(coef);
        Complex x = new Complex(0.4, 0.9);
        System.out.println(poly.applyTo(x));
        System.out.println(poly.lazyApplyTo(x));
    }
}

