/*
 * Decompiled with CFR 0.152.
 */
package practice;

import ev.hmm.HetPairHMM;
import ev.par.ExponentialFamily;
import ev.par.FeatureExtractor;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import goblin.Taxon;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import ma.MSAPoset;
import ma.SequenceType;
import nuts.io.IO;
import nuts.math.Sampling;
import nuts.maxent.MaxentClassifier;
import nuts.util.CollUtils;
import pepper.Encodings;
import practice.CognateTreeKernel;
import practice.ForestState;
import practice.Language;
import practice.LanguagePair;
import practice.MinEditDistance;

public class DataInput
implements Runnable {
    @Option(required=false)
    public boolean weighted = false;
    @Option(required=false)
    public boolean printMatrix = true;
    @Option(required=true)
    public int numIter;
    @Option
    public double threshold;
    @Option(required=true)
    public int N;
    public String languageListPath = "data/processed/languageList";
    public static final String filepath = "data/processed/All.cog";
    public static final Pattern whiteSpace = Pattern.compile("\\s*");
    public ArrayList<MinEditDistance> groups = CollUtils.list();
    HashMap<String, List<Language.Cognate>> goldCognates = new HashMap();
    HashMap<String, Boolean> languageMap = new HashMap();
    private int numLangs;
    public static int NUM_SOUNDS = 0;
    public static double PI = 0.0;
    public static int SEQ_LENGTH;
    public static int NUM_OBS_CUTOFF;
    int numSamples = 100;
    List<ForestState> particles = CollUtils.list();
    @Option(required=true)
    public int seed;
    public Random rand;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Integer, ArrayList<String>> readData(String path, int wordCountThreshold) {
        Hashtable<Integer, ArrayList<String>> wordlist = new Hashtable<Integer, ArrayList<String>>();
        BufferedReader reader = null;
        try {
            reader = IOUtils.openIn(filepath);
            String line = null;
            String[] tokens = null;
            line = null;
            int numLines = 0;
            MinEditDistance med = null;
            while ((line = reader.readLine()) != null) {
                ++numLines;
                tokens = line.split("\\s+");
                String token = null;
                for (int i = 0; i < tokens.length; ++i) {
                    token = tokens[i];
                    if (i == 0) {
                        med = new MinEditDistance(token);
                    }
                    if (token.trim().equals("?")) continue;
                    if (numLines == 1) {
                        wordlist.put(i, new ArrayList());
                        continue;
                    }
                    ArrayList<String> words = wordlist.get(i);
                    words.add(token);
                    med.addWord(token);
                }
                if (med.getNumWords() <= wordCountThreshold) continue;
                this.groups.add(med);
            }
            LogInfo.logs("num languages read=" + wordlist.size());
            ArrayList<String> words = wordlist.get(new Integer(0));
            LogInfo.logsForce(words.size());
        }
        catch (IOException ioe) {
            LogInfo.logs(ioe);
        }
        finally {
            if (reader != null) {
                IOUtils.closeEasy(reader);
            }
        }
        return wordlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Language> readData(String path) {
        ArrayList<Language> languages = new ArrayList<Language>();
        BufferedReader reader = null;
        BufferedReader languageReader = null;
        try {
            reader = IOUtils.openIn(filepath);
            languageReader = IOUtils.openIn(this.languageListPath);
            String line = null;
            while ((line = languageReader.readLine()) != null) {
                String language = line.trim();
                this.languageMap.put(language, true);
            }
            String[] tokens = null;
            int numLines = 0;
            int numWords = 0;
            while ((line = reader.readLine()) != null) {
                ++numLines;
                tokens = line.split("\\s+");
                String token = null;
                String cognateGroup = tokens[0];
                String meaning = cognateGroup.split("\\(")[0];
                for (int i = 1; i < tokens.length; ++i) {
                    token = tokens[i];
                    if (token.trim().equals("?")) continue;
                    if (numLines == 1) {
                        languages.add(i - 1, new Language(token));
                        continue;
                    }
                    ++numWords;
                    Language language = languages.get(i - 1);
                    if (!this.languageMap.containsKey(language.name)) continue;
                    language.addWord(numLines, meaning, token);
                    if (!this.goldCognates.containsKey(cognateGroup)) {
                        this.goldCognates.put(cognateGroup, new ArrayList());
                    }
                    this.goldCognates.get(cognateGroup).add(new Language.Cognate(numLines, meaning, token, new Taxon(languages.get((int)(i - 1)).name)));
                }
            }
            LogInfo.logs("number of words=" + numWords);
            LogInfo.logs("number of gold cognates=" + this.goldCognates.size());
            LogInfo.logs("num languages read=" + languages.size());
        }
        catch (IOException ioe) {
            LogInfo.logs(ioe);
        }
        finally {
            if (reader != null) {
                IOUtils.closeEasy(reader);
            }
            if (languageReader != null) {
                IOUtils.closeEasy(languageReader);
            }
        }
        return languages;
    }

    public void computeDistanceBetweenGroups(int numSamples, int seed) {
        double total = 0.0;
        Random rand = new Random(seed);
        int g1 = 0;
        int g2 = 0;
        for (int i = 0; i < numSamples; ++i) {
            g1 = rand.nextInt(this.groups.size() - 1) + 1;
            while ((g2 = rand.nextInt(this.groups.size() - 1) + 1) == g1) {
            }
            total += this.groups.get(g1).computeDistance(this.groups.get(g2));
        }
        double average = total / (double)numSamples;
        LogInfo.logs("Avg Between Distance=" + average);
    }

    public void learnNGram(ArrayList<Language> languages) {
        for (Language l : languages) {
            l.learnBigram();
        }
    }

    public static void main(String[] args) {
        IO.run(args, new DataInput());
    }

    @Override
    public void run() {
        DataInput di = new DataInput();
        ArrayList<Language> languages = di.readData(filepath);
        ArrayList tempLanguages = CollUtils.list();
        for (Language language : languages) {
            if (!di.languageMap.containsKey(language.name)) continue;
            tempLanguages.add(language);
        }
        languages = tempLanguages;
        LogInfo.logs("numLanguages=" + languages.size());
        ArrayList<Integer> noWords = CollUtils.list();
        for (int i = 0; i < languages.size(); ++i) {
            Language l = languages.get(i);
            if (l.wordlist.size() != 0) continue;
            LogInfo.logs(l.name + " has " + l.wordlist.size() + " words");
            noWords.add(i);
        }
        for (Integer i : noWords) {
            languages.remove(i);
        }
        this.numLangs = languages.size();
        LogInfo.logs(languages.size());
        di.numIter = this.numIter;
        di.eliminateUnrecognizable();
        this.learnNGram(languages);
        HashMap<String, Language> langs = new HashMap<String, Language>();
        for (Language l : languages) {
            langs.put(l.name, l);
        }
        di.rand = new Random(this.seed);
        di.goldMSA(langs);
    }

    public void eliminateUnrecognizable() {
        Encodings encoding = null;
        try {
            encoding = Encodings.realEncoding();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int numUnrecog = 0;
        for (String key : this.goldCognates.keySet()) {
            block3: for (Language.Cognate cognate : this.goldCognates.get(key)) {
                for (int i = 0; i < cognate.word.length(); ++i) {
                    if (encoding.char2PhoneId(cognate.word.charAt(i)) >= 0) continue;
                    cognate.recognizable = false;
                    ++numUnrecog;
                    continue block3;
                }
            }
        }
        LogInfo.logs("numUnrecog=" + numUnrecog);
    }

    public void goldMSA(HashMap<String, Language> languages) {
        Map<Taxon, Integer> points;
        LogInfo.logs("numIter=" + this.numIter);
        Encodings encoding = null;
        try {
            encoding = Encodings.realEncoding();
            if (NUM_SOUNDS == 0) {
                NUM_SOUNDS = Encodings.allCharsInRealEnc().size();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList sequencesList = CollUtils.list();
        for (String gloss : this.goldCognates.keySet()) {
            HashMap<Taxon, String> sequences = new HashMap<Taxon, String>();
            for (Language.Cognate cognate : this.goldCognates.get(gloss)) {
                if (!cognate.recognizable) continue;
                sequences.put(cognate.lang, cognate.word);
                LogInfo.logs(gloss + ":" + cognate.lang.toString());
            }
            if (sequences.size() <= 1) continue;
            sequencesList.add(sequences);
        }
        LogInfo.logs("number of gold cognates after processing: " + sequencesList.size());
        ExponentialFamily.ExponentialFamilyOptions opt = new ExponentialFamily.ExponentialFamilyOptions();
        opt.encodingType = SequenceType.PHONEMES;
        FeatureExtractor.FeatureOptions fopt = new FeatureExtractor.FeatureOptions();
        fopt.hydrophobicModeling = false;
        ExponentialFamily fam = ExponentialFamily.createExpfam(new MaxentClassifier.MaxentOptions<Object>(), opt, fopt, null);
        int numProcessed = 0;
        for (int iter = 0; iter < this.numIter; ++iter) {
            LogInfo.logs("iter=" + iter);
            numProcessed = 0;
            for (Iterator sequences : sequencesList) {
                ArrayList langs = CollUtils.list(sequences.keySet());
                LogInfo.logs("Processing " + ++numProcessed + "/" + sequencesList.size() + ". There are " + langs.size() + " languages in total.");
                for (int l = 0; l < langs.size(); ++l) {
                    Taxon l1 = (Taxon)langs.get(l);
                    for (int k = l + 1; k < langs.size(); ++k) {
                        Taxon l2 = (Taxon)langs.get(k);
                        String s1 = (String)sequences.get(l1);
                        String s2 = (String)sequences.get(l2);
                        HetPairHMM hh = fam.getHMM(s1, s2, l1, l2);
                        fam.addSufficientStatistics(hh, l1, l2);
                    }
                }
            }
            fam.updateParameters();
        }
        int[][] correspondences = new int[NUM_SOUNDS][NUM_SOUNDS];
        int numWordsProcessed = 0;
        for (Map sequences : sequencesList) {
            MSAPoset poset = fam.maxRecallAlignFromAllPairs(sequences);
            for (MSAPoset.Column column : poset.columns()) {
                points = column.getPoints();
                int[] chars = new int[NUM_SOUNDS];
                for (Taxon taxon : points.keySet()) {
                    char ch = poset.charAt(column, taxon);
                    int n = encoding.char2PhoneId(ch);
                    chars[n] = chars[n] + 1;
                }
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] <= 0) continue;
                    int[] nArray = correspondences[i];
                    int n = i;
                    nArray[n] = nArray[n] + chars[i];
                    for (int j = i + 1; j < chars.length; ++j) {
                        if (chars[j] <= 0) continue;
                        int[] nArray2 = correspondences[i];
                        int n2 = j;
                        nArray2[n2] = nArray2[n2] + chars[j];
                        int[] nArray3 = correspondences[j];
                        int n3 = i;
                        nArray3[n3] = nArray3[n3] + chars[i];
                    }
                }
            }
            numWordsProcessed += sequences.size();
        }
        LogInfo.logs("numWordsProcessed=" + numWordsProcessed);
        PI = 1.0 / (double)NUM_SOUNDS;
        for (Map sequences : sequencesList) {
            MSAPoset poset = fam.maxRecallAlignFromAllPairs(sequences);
            LogInfo.logs(poset.toString());
            LogInfo.logs("length=" + poset.columns().size());
            LogInfo.logs("begin=" + SEQ_LENGTH);
            for (MSAPoset.Column column : poset.columns()) {
                points = column.getPoints();
                for (Taxon taxon : points.keySet()) {
                    char ch = poset.charAt(column, taxon);
                    if (!languages.containsKey(taxon.toString())) {
                        LogInfo.logs("Not in the data: " + taxon.toString());
                        continue;
                    }
                    languages.get(taxon.toString()).addData(SEQ_LENGTH, encoding.char2PhoneId(ch), ch);
                }
                ++SEQ_LENGTH;
            }
            LogInfo.logs("end=" + SEQ_LENGTH);
        }
        LogInfo.logs("ppos=" + SEQ_LENGTH);
        ArrayList<Language> languageList = CollUtils.list();
        for (Language language : languages.values()) {
            languageList.add(language);
        }
        for (Language lang : languageList) {
            LogInfo.logs("lang=" + lang.name);
        }
        this.smc(languageList);
    }

    public void smc(List<Language> languageList) {
        ForestState.RateMatrix rm = new ForestState.RateMatrix(NUM_SOUNDS);
        CognateTreeKernel kernel = new CognateTreeKernel(languageList, rm, 0.75);
        ArrayList<Double> weights = CollUtils.list();
        int R = kernel.getInitial().nIterationLeft();
        LogInfo.logs("ITER=1 out of " + R);
        for (int i = 0; i < this.numSamples; ++i) {
            Pair<ForestState, Double> pair = kernel.next(this.rand, kernel.getInitial());
            this.particles.add(pair.getFirst());
            LogInfo.logs("weight=" + pair.getSecond());
            weights.add((double)pair.getSecond());
        }
        List<Integer> resampleIndex = this.resample(weights);
        ArrayList tempParticles = CollUtils.list();
        for (int r = 1; r < R; ++r) {
            LogInfo.logs("ITER=" + (r + 1) + " out of " + R);
            weights = CollUtils.list();
            tempParticles = CollUtils.list();
            for (int i = 0; i < this.numSamples; ++i) {
                int index = resampleIndex.get(i);
                Pair<ForestState, Double> pair = kernel.next(this.rand, this.particles.get(index));
                tempParticles.add(i, pair.getFirst());
                LogInfo.logs("weight=" + pair.getSecond());
                weights.add(i, (double)pair.getSecond());
            }
            this.particles = tempParticles;
            if (r >= R - 1) continue;
            resampleIndex = this.resample(weights);
        }
        for (Language language : languageList) {
            LogInfo.logs(language.name);
            LogInfo.logs(language.sequence.toString());
        }
        for (int i = 0; i < 10; ++i) {
            int sample = Sampling.sample(this.rand, weights);
            ForestState fs = this.particles.get(sample);
            LogInfo.logs(fs.toString() + ": w=" + weights.get(sample));
        }
    }

    public List<Integer> resample(List<Double> weights) {
        ArrayList<Integer> resampleIndex = CollUtils.list();
        for (int i = 0; i < this.numSamples; ++i) {
            resampleIndex.add(Sampling.sample(this.rand, weights));
        }
        return resampleIndex;
    }

    public Hashtable<String, LanguagePair> model1ROC(List<Language> languages) {
        int numLangs = languages.size();
        int numWords = 0;
        Hashtable<String, LanguagePair> pairs = new Hashtable<String, LanguagePair>();
        while (numWords < this.N) {
            int l = this.rand.nextInt(numLangs);
            int k = this.rand.nextInt(numLangs);
            Language l1 = languages.get(l);
            Language l2 = languages.get(k);
            String pairKey = l2.name + "_" + l1.name;
            if (pairs.containsKey(pairKey) || pairs.containsKey(pairKey = l1.name + "_" + l2.name)) continue;
            LanguagePair pair = new LanguagePair(l1, l2);
            for (Integer key : l1.wordlist.keySet()) {
                if (!l2.wordlist.containsKey(key)) continue;
                List<Language.Cognate> words1 = l1.wordlist.get(key);
                List<Language.Cognate> words2 = l2.wordlist.get(key);
                for (Language.Cognate c1 : words1) {
                    for (Language.Cognate c2 : words2) {
                        pair.addCognates(c1, c2);
                    }
                }
            }
            numWords += pair.size();
            pairs.put(pairKey, pair);
        }
        LogInfo.logs("numWords=" + numWords);
        LogInfo.logs("numLanguages=" + pairs.size());
        ExponentialFamily.ExponentialFamilyOptions opt = new ExponentialFamily.ExponentialFamilyOptions();
        opt.encodingType = SequenceType.PHONEMES;
        FeatureExtractor.FeatureOptions fopt = new FeatureExtractor.FeatureOptions();
        fopt.hydrophobicModeling = false;
        int languagesProcessed = 0;
        int wordsProcessed = 0;
        for (String pairKey : pairs.keySet()) {
            ExponentialFamily fam = ExponentialFamily.createExpfam(new MaxentClassifier.MaxentOptions<Object>(), opt, fopt, null);
            HetPairHMM hh = null;
            LanguagePair pair = pairs.get(pairKey);
            Language l1 = pair.l1;
            Language l2 = pair.l2;
            Taxon lang1 = new Taxon(l1.name);
            Taxon lang2 = new Taxon(l2.name);
            for (int iter = 0; iter < this.numIter; ++iter) {
                LogInfo.logs("iter=" + iter);
                double suff = 0.0;
                double p = pair.getParam();
                for (int index = 0; index < pair.cognates.size(); ++index) {
                    Pair<Language.Cognate, Language.Cognate> cognates = pair.cognates.get(index);
                    Language.Cognate c1 = cognates.getFirst();
                    Language.Cognate c2 = cognates.getSecond();
                    String w1 = c1.word;
                    String w2 = c2.word;
                    hh = fam.getHMM(w1, w2, lang1, lang2);
                    fam.addSufficientStatistics(hh, lang1, lang2);
                    double joint = Math.exp(hh.logSumProduct());
                    double logpx = Math.exp(l1.logp(w1));
                    double logpy = Math.exp(l2.logp(w2));
                    double alpha = p * joint / ((1.0 - p) * logpx * logpy + p * joint);
                    if (iter == this.numIter - 1) {
                        pair.storeCw1w2(c1, c2, alpha);
                        LogInfo.logs("(" + l1.name + ", " + l2.name + ")(" + alpha + "," + joint + "," + logpx + "," + logpy + "," + p + ")");
                        LogInfo.logs(hh.viterbi());
                    }
                    suff += alpha;
                }
                if (iter == this.numIter - 1) break;
                pair.update(suff);
                fam.updateParameters();
            }
            LogInfo.logs(++languagesProcessed + "/" + pairs.size() + " processed.");
            LogInfo.logs((wordsProcessed += pair.cognates.size()) + "/" + numWords + " processed.");
        }
        return pairs;
    }

    public double[][] model1(List<Language> languages) {
        double[][] pr = new double[this.numIter][3];
        int numLangs = languages.size();
        int numWords = 0;
        Hashtable<String, LanguagePair> pairs = new Hashtable<String, LanguagePair>();
        while (numWords < this.N) {
            int l = this.rand.nextInt(numLangs);
            int k = this.rand.nextInt(numLangs);
            Language l1 = languages.get(l);
            Language l2 = languages.get(k);
            String pairKey = l2.name + "_" + l1.name;
            if (pairs.containsKey(pairKey) || pairs.containsKey(pairKey = l1.name + "_" + l2.name)) continue;
            LanguagePair pair = new LanguagePair(l1, l2);
            for (Integer key : l1.wordlist.keySet()) {
                if (!l2.wordlist.containsKey(key)) continue;
                List<Language.Cognate> words1 = l1.wordlist.get(key);
                List<Language.Cognate> words2 = l2.wordlist.get(key);
                for (Language.Cognate c1 : words1) {
                    for (Language.Cognate c2 : words2) {
                        pair.addCognates(c1, c2);
                    }
                }
            }
            numWords += pair.size();
            pairs.put(pairKey, pair);
        }
        ExponentialFamily.ExponentialFamilyOptions opt = new ExponentialFamily.ExponentialFamilyOptions();
        opt.encodingType = SequenceType.PHONEMES;
        FeatureExtractor.FeatureOptions fopt = new FeatureExtractor.FeatureOptions();
        fopt.hydrophobicModeling = false;
        block4: for (String pairKey : pairs.keySet()) {
            ExponentialFamily fam = ExponentialFamily.createExpfam(new MaxentClassifier.MaxentOptions<Object>(), opt, fopt, null);
            HetPairHMM hh = null;
            for (int iter = 0; iter < this.numIter; ++iter) {
                LogInfo.logs("iter=" + iter);
                LanguagePair pair = (LanguagePair)pairs.get(pairKey);
                Language l1 = pair.l1;
                Language l2 = pair.l2;
                Taxon lang1 = new Taxon(l1.name);
                Taxon lang2 = new Taxon(l2.name);
                double suff = 0.0;
                double p = pair.getParam();
                for (int index = 0; index < pair.cognates.size(); ++index) {
                    Pair<Language.Cognate, Language.Cognate> cognates = pair.cognates.get(index);
                    Language.Cognate c1 = cognates.getFirst();
                    Language.Cognate c2 = cognates.getSecond();
                    String w1 = c1.word;
                    String w2 = c2.word;
                    hh = fam.getHMM(w1, w2, lang1, lang2);
                    fam.addSufficientStatistics(hh, lang1, lang2);
                    double joint = Math.exp(hh.logSumProduct());
                    double logpx = Math.exp(l1.logp(w1));
                    double logpy = Math.exp(l2.logp(w2));
                    double alpha = p * joint / ((1.0 - p) * logpx * logpy + p * joint);
                    double[] dArray = pr[iter];
                    dArray[0] = dArray[0] + (double)(c1.groupId == c2.groupId ? 1 : 0);
                    if (alpha > this.threshold) {
                        double[] dArray2 = pr[iter];
                        dArray2[1] = dArray2[1] + 1.0;
                        if (c1.groupId == c2.groupId) {
                            double[] dArray3 = pr[iter];
                            dArray3[2] = dArray3[2] + 1.0;
                            if (iter == this.numIter - 1) {
                                LogInfo.logs("(" + l1.name + ", " + l2.name + ")(" + alpha + "," + joint + "," + logpx + "," + logpy + "," + p + ")");
                                LogInfo.logs(hh.viterbi());
                            }
                        }
                    } else if (iter == this.numIter - 1 && c1.groupId == c2.groupId) {
                        LogInfo.logs("(" + l1.name + ", " + l2.name + ")(" + alpha + "," + joint + "," + logpx + "," + logpy + "," + p + ")");
                        LogInfo.logs(hh.viterbi());
                    }
                    suff += alpha;
                }
                this.numIter = 1;
                if (iter == 1) continue block4;
                pair.update(suff);
                fam.updateParameters();
            }
        }
        LogInfo.logs("numWords=" + numWords);
        return pr;
    }

    public double[][] model2(List<Language> languages) {
        LanguagePair pair;
        double[][] pr2 = new double[this.numIter][3];
        int numLangs = languages.size();
        ExponentialFamily.ExponentialFamilyOptions opt = new ExponentialFamily.ExponentialFamilyOptions();
        opt.encodingType = SequenceType.PHONEMES;
        FeatureExtractor.FeatureOptions fopt = new FeatureExtractor.FeatureOptions();
        fopt.hydrophobicModeling = false;
        ExponentialFamily fam = ExponentialFamily.createExpfam(new MaxentClassifier.MaxentOptions<Object>(), opt, fopt, null);
        HetPairHMM hh = null;
        int numWords = 0;
        Hashtable<String, LanguagePair> pairs = new Hashtable<String, LanguagePair>();
        while (numWords < this.N) {
            int l = this.rand.nextInt(numLangs);
            int k = this.rand.nextInt(numLangs);
            Language l1 = languages.get(l);
            Language l2 = languages.get(k);
            String pairKey = l2.name + "_" + l1.name;
            if (pairs.containsKey(pairKey) || pairs.containsKey(pairKey = l1.name + "_" + l2.name)) continue;
            pair = new LanguagePair(l1, l2);
            for (Integer key : l1.wordlist.keySet()) {
                if (!l2.wordlist.containsKey(key)) continue;
                List<Language.Cognate> words1 = l1.wordlist.get(key);
                List<Language.Cognate> words2 = l2.wordlist.get(key);
                for (Language.Cognate c1 : words1) {
                    for (Language.Cognate c2 : words2) {
                        pair.addCognates(c1, c2);
                    }
                }
            }
            numWords += pair.size();
            pairs.put(pairKey, pair);
        }
        for (int iter = 0; iter < this.numIter; ++iter) {
            LogInfo.logs("iter=" + iter);
            for (String pairKey : pairs.keySet()) {
                double suff = 0.0;
                pair = (LanguagePair)pairs.get(pairKey);
                Language l1 = pair.l1;
                Language l2 = pair.l2;
                Taxon lang1 = new Taxon(l1.name);
                Taxon lang2 = new Taxon(l2.name);
                double p = pair.getParam();
                for (int index = 0; index < pair.cognates.size(); ++index) {
                    Pair<Language.Cognate, Language.Cognate> cognates = pair.cognates.get(index);
                    Language.Cognate c1 = cognates.getFirst();
                    Language.Cognate c2 = cognates.getSecond();
                    if (!c1.meaning.equalsIgnoreCase(c2.meaning)) {
                        LogInfo.logs("Error in data handling!");
                        System.exit(-1);
                    }
                    String w1 = c1.word;
                    String w2 = c2.word;
                    hh = fam.getHMM(w1, w2, lang1, lang2);
                    fam.addSufficientStatistics(hh, lang1, lang2);
                    double joint = Math.exp(hh.logSumProduct());
                    double logpx = Math.exp(l1.logp(w1));
                    double logpy = Math.exp(l2.logp(w2));
                    double alpha = p * joint / ((1.0 - p) * logpx * logpy + p * joint);
                    double[] dArray = pr2[iter];
                    dArray[0] = dArray[0] + (double)(c1.groupId == c2.groupId ? 1 : 0);
                    if (alpha > this.threshold) {
                        double[] dArray2 = pr2[iter];
                        dArray2[1] = dArray2[1] + 1.0;
                        if (c1.groupId == c2.groupId) {
                            double[] dArray3 = pr2[iter];
                            dArray3[2] = dArray3[2] + 1.0;
                            if (iter == this.numIter - 1) {
                                LogInfo.logs("(" + l1.name + ", " + l2.name + ")(" + alpha + "," + joint + "," + logpx + "," + logpy + "," + p + ")");
                                LogInfo.logs(hh.viterbi());
                            }
                        }
                    } else if (iter == this.numIter - 1 && c1.groupId == c2.groupId) {
                        LogInfo.logs("(" + l1.name + ", " + l2.name + ")(" + alpha + "," + joint + "," + logpx + "," + logpy + "," + p + ")");
                        LogInfo.logs(hh.viterbi());
                    }
                    suff += alpha;
                }
                pair.update(suff);
            }
            if (iter >= this.numIter - 1) continue;
            fam.updateParameters();
        }
        LogInfo.logs("numWords=" + numWords);
        return pr2;
    }

    static {
        NUM_OBS_CUTOFF = 4;
    }
}

