/*
 * Decompiled with CFR 0.152.
 */
package pty.io;

import fig.basic.Option;
import fig.exec.Execution;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import nuts.io.IO;
import nuts.util.EasyFormat;
import pty.io.WalsAnn;

public class WalsData
implements Runnable {
    @Option
    public String walsPath = "data/wals_data";
    @Option(gloss="Restrict to family (empty for no restriction)")
    public String family = "";
    @Option(gloss="If a site has more than maxNCharacters characters, reject it")
    public int maxNCharacters = Integer.MAX_VALUE;
    @Option(gloss="If a language has less than minNFeatures features, reject it")
    public int minNFeatures = 20;
    @Option
    public ArrayList<Operation> operations = new ArrayList<Operation>(Arrays.asList(Operation.PHYLIP));
    @Option(gloss="Seed for bootstrap")
    public Random rand = new Random(1L);
    @Option
    public int nBootstrapSamples = 100;
    private Map<String, Map<Integer, Integer>> data = new HashMap<String, Map<Integer, Integer>>();
    private List<Integer> features = new ArrayList<Integer>();
    private List<String> langs = new ArrayList<String>();
    private Map<String, String> lang2Family = new HashMap<String, String>();
    private Map<String, String> lang2Full = new HashMap<String, String>();
    private Map<String, String> lang2Genus = new HashMap<String, String>();

    public static WalsData parse(File dir) {
        WalsData result = new WalsData();
        result._parse(dir);
        return result;
    }

    public String getFullLanguageName(String walsCode) {
        return this.lang2Full.get(walsCode);
    }

    public String getFamily(String walsCode) {
        return this.lang2Family.get(walsCode);
    }

    public String getGenus(String walsCode) {
        return this.lang2Genus.get(walsCode);
    }

    @Override
    public void run() {
        this._parse(new File(this.walsPath));
        for (Operation op : this.operations) {
            op.doIt(this);
        }
    }

    public static void main(String[] args) {
        Execution.run(args, new WalsData());
    }

    private WalsData() {
    }

    private void _parse(File root) {
        File dataPtsFile = new File(root, "datapoints.tab");
        File langFile = new File(root, "languages.tab");
        this.parseLanguages(langFile);
        this.parseFeatures(dataPtsFile);
    }

    private void parseLanguages(File langFile) {
        for (String line : IO.i(langFile)) {
            if (line.startsWith("wals")) continue;
            String[] fields = line.split("\\t");
            this.lang2Family.put(fields[0], fields[5]);
            this.lang2Full.put(fields[0], fields[1]);
            this.lang2Genus.put(fields[0], fields[4]);
        }
    }

    private void parseFeatures(File dataPtsFile) {
        HashSet<Integer> _features = new HashSet<Integer>();
        for (String line : IO.i(dataPtsFile)) {
            if (line.startsWith("wals_code")) continue;
            String[] fields = line.split("\\t");
            String langCode = fields[0];
            HashMap<Integer, Integer> type2value = new HashMap<Integer, Integer>();
            this.data.put(langCode, type2value);
            for (int i = 1; i < fields.length; ++i) {
                if (fields[i].equals("")) continue;
                type2value.put(i, Integer.parseInt(fields[i]));
                _features.add(i);
            }
        }
        this.langs.addAll(this.data.keySet());
        Collections.sort(this.langs);
        this.features.addAll(_features);
        Collections.sort(this.features);
    }

    public Set<Integer> getPossibleStates(int feature) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (String lang : this.langs) {
            if (!this.hasFeature(lang, feature)) continue;
            result.add(this.feature(lang, feature));
        }
        return result;
    }

    public List<Integer> allFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public Set<Integer> getKnownFeatures(String lang) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int feature : this.allFeatures()) {
            if (!this.hasFeature(lang, feature)) continue;
            result.add(feature);
        }
        return result;
    }

    public double distance(String lang1, String lang2, List<Integer> features) {
        ArrayList<Integer> inter = new ArrayList<Integer>();
        for (int f : features) {
            if (!this.hasFeature(lang1, f) || !this.hasFeature(lang2, f)) continue;
            inter.add(f);
        }
        if (inter.size() == 0) {
            return 1.0;
        }
        double num = 0.0;
        Iterator iterator = inter.iterator();
        while (iterator.hasNext()) {
            int f = (Integer)iterator.next();
            if (this.feature(lang1, f) == this.feature(lang2, f)) continue;
            num += 1.0;
        }
        return num / (double)inter.size();
    }

    public void matrices(int minNFeatures, int nBoots, Random rand, String familyRestr) {
        List<String> langs = this.langWithMinNFeatures(minNFeatures, familyRestr);
        for (int i = 0; i < nBoots; ++i) {
            System.out.print("  " + langs.size() + "\n");
            List<Integer> bsFeatures = this.getBootstrap(rand);
            for (String lang : langs) {
                System.out.print(WalsAnn.cleanForPhylip(lang));
                for (String lang2 : langs) {
                    System.out.print(EasyFormat.fmt(this.distance(lang, lang2, bsFeatures)) + "  ");
                }
                System.out.print("\n");
            }
            System.out.print("\n");
        }
    }

    private List<Integer> getBootstrap(Random rand) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.features.size(); ++i) {
            result.add(this.features.get(rand.nextInt(this.features.size())));
        }
        return result;
    }

    public List<String> langWithMinNFeatures(int minNFeatures, String familyRestr) {
        ArrayList<String> result = new ArrayList<String>();
        for (String lang : this.langs) {
            if (familyRestr != null && !familyRestr.equals("") && !this.lang2Family.get(lang).equals(familyRestr) || this.getKnownFeatures(lang).size() < minNFeatures) continue;
            result.add(lang);
        }
        return result;
    }

    public String toPhylipString(int maxNCharacters, int minNFeatures, String familyRestr) {
        List<String> langs = this.langWithMinNFeatures(minNFeatures, familyRestr);
        int nLangs = 0;
        StringBuilder result = new StringBuilder();
        ArrayList<Integer> features = new ArrayList<Integer>(this.allFeatures());
        Iterator i = features.iterator();
        while (i.hasNext()) {
            if (this.getPossibleStates((Integer)i.next()).size() <= maxNCharacters) continue;
            i.remove();
        }
        for (String lang : langs) {
            ++nLangs;
            result.append(WalsAnn.fillWithSpaces(lang, 10));
            Iterator iterator = features.iterator();
            while (iterator.hasNext()) {
                int f = (Integer)iterator.next();
                if (this.hasFeature(lang, f)) {
                    result.append(this.feature(lang, f));
                    continue;
                }
                result.append("?");
            }
            result.append("\n");
        }
        return "" + nLangs + " " + features.size() + "\n" + result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("wals_code\t");
        Iterator<Object> iterator = this.allFeatures().iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            result.append("" + i + "\t");
        }
        for (String lang : this.langs) {
            result.append("\n" + lang);
            for (int i : this.allFeatures()) {
                if (this.hasFeature(lang, i)) {
                    result.append("\t" + this.feature(lang, i));
                    continue;
                }
                result.append("\t");
            }
        }
        return result.toString();
    }

    public int feature(String lang, Integer i) {
        if (!this.hasFeature(lang, i)) {
            throw new RuntimeException();
        }
        return this.data.get(lang).get(i);
    }

    public boolean hasFeature(String lang, Integer i) {
        return this.data.get(lang).containsKey(i);
    }

    public static enum Operation {
        PHYLIP{

            @Override
            public void doIt(WalsData wd) {
                IO.so("\n" + wd.toPhylipString(wd.maxNCharacters, wd.minNFeatures, wd.family));
            }
        }
        ,
        MTX{

            @Override
            public void doIt(WalsData wd) {
                System.out.println();
                wd.matrices(wd.minNFeatures, wd.nBootstrapSamples, wd.rand, wd.family);
            }
        };


        public abstract void doIt(WalsData var1);
    }
}

