/*
 * Decompiled with CFR 0.152.
 */
package pty.smc;

import pty.smc.PartialCoalescentState;

public class LazyPCS {
    private PartialCoalescentState state = null;
    private PartialCoalescentState statecopy = null;
    private double queuedMerger = 0.0;
    private int queuedLeft = -1;
    private int queueRight = -1;
    private double queuedDeltaLeft = 0.0;
    private double queuedDeltaRight = 0.0;

    public LazyPCS(PartialCoalescentState pcs) {
        this.statecopy = pcs;
    }

    public LazyPCS(PartialCoalescentState pcs, double delta, int left, int right) {
        this.queuedLeft = left;
        this.queueRight = right;
        this.queuedMerger = delta;
        this.state = pcs;
    }

    public LazyPCS(PartialCoalescentState pcs, double delta, int left, int right, double deltaLeft, double deltaRight) {
        this.queuedLeft = left;
        this.queueRight = right;
        this.queuedMerger = delta;
        this.state = pcs;
        this.queuedDeltaLeft = deltaLeft;
        this.queuedDeltaRight = deltaRight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nIterationsLeft() {
        LazyPCS lazyPCS = this;
        synchronized (lazyPCS) {
            if (this.state != null && this.statecopy != null) {
                throw new RuntimeException();
            }
            if (this.statecopy != null) {
                return this.statecopy.nIterationsLeft();
            }
            return this.state.nIterationsLeft() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyQueue() {
        if (this.queuedLeft == -1) {
            return;
        }
        LazyPCS lazyPCS = this;
        synchronized (lazyPCS) {
            if (this.queuedLeft == -1) {
                return;
            }
            this.statecopy = this.state.coalesce(this.queuedLeft, this.queueRight, this.queuedMerger, this.queuedDeltaLeft, this.queuedDeltaRight);
            this.state = null;
            this.queuedLeft = -1;
        }
    }

    public PartialCoalescentState getState() {
        this.applyQueue();
        if (this.statecopy == null) {
            throw new RuntimeException();
        }
        return this.statecopy;
    }
}

